/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.impl.Page;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.SharedNothingBackupActivation;
import org.apache.activemq.artemis.tests.integration.cluster.failover.NettyFailoverInVMTest;
import org.apache.activemq.artemis.tests.integration.cluster.util.SameProcessActiveMQServer;
import org.apache.activemq.artemis.tests.integration.cluster.util.TestableServer;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyReplicatedFailoverTest
extends NettyFailoverInVMTest {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    protected TestableServer createTestableServer(Configuration config) {
        return new SameProcessActiveMQServer(this.createServer(true, config));
    }

    @Override
    protected void createConfigs() throws Exception {
        this.createReplicatedConfigs();
    }

    @Override
    protected final void crash(boolean waitFailure, ClientSession ... sessions) throws Exception {
        if (sessions.length > 0) {
            for (ClientSession session : sessions) {
                NettyReplicatedFailoverTest.waitForRemoteBackup(session.getSessionFactory(), 5, true, this.backupServer.getServer());
            }
        } else {
            NettyReplicatedFailoverTest.waitForRemoteBackup(null, 5, true, this.backupServer.getServer());
        }
        super.crash(waitFailure, sessions);
    }

    @Override
    protected final void crash(ClientSession ... sessions) throws Exception {
        this.crash(true, sessions);
    }

    @Test
    public void testPagedInSync() throws Exception {
        String queueName = "testPagedInSync";
        ConnectionFactory factory = CFUtil.createConnectionFactory("core", "tcp://localhost:61616");
        try (Connection conn = factory.createConnection();){
            Session session = conn.createSession(true, 0);
            jakarta.jms.Queue queue = session.createQueue(queueName);
            MessageProducer producer = session.createProducer((Destination)queue);
            producer.send((Message)session.createTextMessage("hello"));
            session.commit();
            Queue serverQueue = this.primaryServer.getServer().locateQueue(queueName);
            Assertions.assertNotNull((Object)serverQueue);
            serverQueue.getPagingStore().startPaging();
            for (int i = 0; i < 50; ++i) {
                producer.send((Message)session.createTextMessage("hello"));
                session.commit();
                serverQueue.getPagingStore().forceAnotherPage();
            }
            this.backupServer.stop();
            this.backupServer.start();
            Wait.assertTrue(() -> ((ActiveMQServer)this.backupServer.getServer()).isReplicaSync());
            SharedNothingBackupActivation activation = (SharedNothingBackupActivation)this.backupServer.getServer().getActivation();
            Map currentPages = (Map)activation.getReplicationEndpoint().getPageIndex().get(SimpleString.of((String)queueName));
            logger.info("There are {} page files open", (Object)currentPages.size());
            Wait.assertTrue(() -> currentPages.size() <= 1, (long)10000L);
            producer.send((Message)session.createTextMessage("on currentPage"));
            session.commit();
            PagingStore store = this.primaryServer.getServer().getPagingManager().getPageStore(SimpleString.of((String)queueName));
            Page currentPage = store.getCurrentPage();
            logger.info("Page {}", (Object)currentPage.getPageId());
            Page depaged = null;
            while ((depaged = store.depage()) != null && currentPage.getPageId() != depaged.getPageId()) {
                logger.info("depage :: {} and currentPageID={}", (Object)depaged.getPageId(), (Object)currentPage.getPageId());
            }
            Assertions.assertNotNull((Object)depaged);
            logger.info("Depaged:: {}", (Object)depaged.getPageId());
            for (int i = 0; i < 10; ++i) {
                producer.send((Message)session.createTextMessage("on current page"));
                session.commit();
                store.depage();
            }
            logger.info("Size:: {}", (Object)currentPages.size());
            Wait.assertTrue(() -> currentPages.size() <= 1, (long)10000L);
        }
    }
}

