/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.warnings;

import java.lang.invoke.MethodHandles;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterCleanNodeShutdownTest
extends ClusterTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Test
    public void testNoWarningErrorsDuringRestartingNodesInCluster() throws Exception {
        this.setupServer(0, this.isFileStorage(), this.isNetty());
        this.setupServer(1, this.isFileStorage(), this.isNetty());
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0);
        this.startServers(0, 1);
        Wait.assertTrue(() -> {
            this.getServer(0).getClusterManager().getClusterController().awaitConnectionToReplicationCluster();
            return true;
        }, (long)2000L);
        Wait.assertTrue(() -> {
            this.getServer(1).getClusterManager().getClusterController().awaitConnectionToReplicationCluster();
            return true;
        }, (long)2000L);
        logger.debug("server 0 = {}", (Object)this.getServer(0).getNodeID());
        logger.debug("server 1 = {}", (Object)this.getServer(1).getNodeID());
        this.setupSessionFactory(0, this.isNetty(), 15);
        this.setupSessionFactory(1, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue10", null, true);
        this.createQueue(1, "queues.testaddress", "queue10", null, true);
        this.addConsumer(0, 0, "queue10", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 0, true);
        this.waitForBindings(0, "queues.testaddress", 1, 0, false);
        this.waitForBindings(1, "queues.testaddress", 1, 1, false);
        this.sendInRange(1, "queues.testaddress", 0, 10, true, null);
        try (AssertionLoggerHandler loggerHandler = new AssertionLoggerHandler(true);){
            logger.debug("*****************************************************************************");
            this.stopServers(0);
            Wait.assertTrue(() -> !this.getServer(0).isStarted() && !this.getServer(0).isActive(), (long)2000L);
            logger.debug("*****************************************************************************");
            Assertions.assertFalse((boolean)loggerHandler.findText(new String[]{"AMQ212037", " [code=DISCONNECTED]"}), (String)"Connection failure detected for an expected DISCONNECT event");
            Assertions.assertFalse((boolean)loggerHandler.hasLevel(AssertionLoggerHandler.LogLevel.WARN), (String)"WARN found");
        }
        this.startServers(0);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 0, true);
        this.waitForBindings(0, "queues.testaddress", 1, 0, false);
        this.waitForBindings(1, "queues.testaddress", 1, 1, false);
        this.sendInRange(1, "queues.testaddress", 10, 20, false, null);
        this.verifyReceiveAllInRange(0, 20, 0);
        logger.debug("*****************************************************************************");
    }

    public boolean isNetty() {
        return true;
    }
}

