/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.federation;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import org.apache.activemq.artemis.core.config.FederationConfiguration;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.tests.integration.federation.FederatedTestBase;
import org.apache.activemq.artemis.tests.integration.federation.FederatedTestUtil;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NettyFederatedQueueTest
extends FederatedTestBase {
    @Override
    protected boolean isNetty() {
        return true;
    }

    @Override
    protected boolean isPersistenceEnabled() {
        return true;
    }

    @Test
    public void testFederatedQueueBiDirectionalUpstream() throws Exception {
        AssertionLoggerHandler loggerHandler = new AssertionLoggerHandler();
        this.runAfter(() -> loggerHandler.close());
        String queueName = this.getName();
        FederationConfiguration federationConfiguration0 = FederatedTestUtil.createQueueUpstreamFederationConfiguration("server1", queueName);
        this.getServer(0).getConfiguration().getFederationConfigurations().add(federationConfiguration0);
        this.getServer(0).getFederationManager().deploy();
        FederationConfiguration federationConfiguration1 = FederatedTestUtil.createQueueUpstreamFederationConfiguration("server0", queueName);
        this.getServer(1).getConfiguration().getFederationConfigurations().add(federationConfiguration1);
        this.getServer(1).getFederationManager().deploy();
        ConnectionFactory cf1 = CFUtil.createConnectionFactory("CORE", "tcp://localhost:61616?consumerWindowSize=0");
        ConnectionFactory cf2 = CFUtil.createConnectionFactory("CORE", "tcp://localhost:61617?consumerWindowSize=0");
        Connection connection1 = cf1.createConnection();
        connection1.start();
        this.runAfter(() -> ((Connection)connection1).close());
        Session session1 = connection1.createSession(true, 0);
        MessageProducer producer1 = session1.createProducer((Destination)session1.createQueue(queueName));
        Connection connection2 = cf2.createConnection();
        connection2.start();
        this.runAfter(() -> ((Connection)connection2).close());
        Session session2 = connection2.createSession(false, 1);
        MessageConsumer consumer2 = session2.createConsumer((Destination)session2.createQueue(queueName));
        producer1.send((Message)session1.createTextMessage("Test"));
        session1.commit();
        Assertions.assertNotNull((Object)consumer2.receive(5000L));
        for (int i = 0; i < 1000; ++i) {
            producer1.send((Message)session1.createTextMessage("test"));
        }
        session1.commit();
        MessageConsumer consumer1 = session1.createConsumer((Destination)session1.createQueue(queueName));
        for (int i = 0; i < 100; ++i) {
            Assertions.assertNotNull((Object)consumer1.receive(5000L));
            session1.commit();
            Assertions.assertNotNull((Object)consumer2.receive(5000L));
        }
        Assertions.assertNotNull((Object)consumer2.receive(5000L));
        Assertions.assertFalse((boolean)loggerHandler.findText(new String[]{"AMQ222153"}));
    }
}

