/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.bridge;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.transaction.TransactionManager;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnectorFactory;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.jms.bridge.ConnectionFactoryFactory;
import org.apache.activemq.artemis.jms.bridge.DestinationFactory;
import org.apache.activemq.artemis.jms.bridge.QualityOfServiceMode;
import org.apache.activemq.artemis.jms.bridge.impl.JMSBridgeImpl;
import org.apache.activemq.artemis.jms.client.ActiveMQJMSConnectionFactory;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class JMSBridgeImplTest
extends ActiveMQTestBase {
    private static final String SOURCE = RandomUtil.randomString();
    private static final String TARGET = RandomUtil.randomString();
    private ActiveMQServer server;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(false, this.createDefaultInVMConfig());
        this.server.start();
        this.server.createQueue(QueueConfiguration.of((String)SOURCE).setRoutingType(RoutingType.ANYCAST));
        this.server.createQueue(QueueConfiguration.of((String)TARGET).setRoutingType(RoutingType.ANYCAST));
    }

    private static ConnectionFactory createConnectionFactory() {
        ActiveMQJMSConnectionFactory cf = (ActiveMQJMSConnectionFactory)ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(InVMConnectorFactory.class.getName())});
        cf.setReconnectAttempts(0);
        cf.setBlockOnNonDurableSend(true);
        cf.setBlockOnDurableSend(true);
        return cf;
    }

    @Test
    public void testExceptionOnSourceAndManualRestartSucceeds() throws Exception {
        final AtomicReference sourceConn = new AtomicReference();
        ActiveMQJMSConnectionFactory failingSourceCF = new ActiveMQJMSConnectionFactory(false, new TransportConfiguration[]{new TransportConfiguration(InVMConnectorFactory.class.getName())}){
            private static final long serialVersionUID = -8866390811966688830L;

            public Connection createConnection() throws JMSException {
                sourceConn.set(super.createConnection());
                return (Connection)sourceConn.get();
            }
        };
        failingSourceCF.setReconnectAttempts(0);
        failingSourceCF.setBlockOnNonDurableSend(true);
        failingSourceCF.setBlockOnDurableSend(true);
        ConnectionFactoryFactory sourceCFF = () -> failingSourceCF;
        ConnectionFactoryFactory targetCFF = () -> JMSBridgeImplTest.createConnectionFactory();
        DestinationFactory sourceDF = () -> ActiveMQJMSClient.createQueue((String)SOURCE);
        DestinationFactory targetDF = () -> ActiveMQJMSClient.createQueue((String)TARGET);
        TransactionManager tm = (TransactionManager)Mockito.mock(TransactionManager.class);
        JMSBridgeImpl bridge = new JMSBridgeImpl();
        bridge.setSourceConnectionFactoryFactory(sourceCFF);
        bridge.setSourceDestinationFactory(sourceDF);
        bridge.setTargetConnectionFactoryFactory(targetCFF);
        bridge.setTargetDestinationFactory(targetDF);
        bridge.setFailureRetryInterval(1L);
        bridge.setMaxRetries(0);
        bridge.setMaxBatchSize(1);
        bridge.setMaxBatchTime(-1L);
        bridge.setTransactionManager(tm);
        bridge.setQualityOfServiceMode(QualityOfServiceMode.AT_MOST_ONCE);
        Assertions.assertFalse((boolean)bridge.isStarted());
        bridge.start();
        Assertions.assertTrue((boolean)bridge.isStarted());
        Connection targetConn = JMSBridgeImplTest.createConnectionFactory().createConnection();
        Session targetSess = targetConn.createSession(false, 1);
        MessageConsumer consumer = targetSess.createConsumer(targetDF.createDestination());
        LinkedList messages = new LinkedList();
        MessageListener listener = message -> messages.add(message);
        consumer.setMessageListener(listener);
        targetConn.start();
        Session sourceSess = ((Connection)sourceConn.get()).createSession(false, 1);
        MessageProducer producer = sourceSess.createProducer(sourceDF.createDestination());
        producer.send((Message)sourceSess.createTextMessage());
        Wait.assertEquals((int)1, () -> messages.size(), (long)2000L, (long)100L);
        ((Connection)sourceConn.get()).getExceptionListener().onException(new JMSException("exception on the source"));
        Wait.assertTrue(() -> bridge.isFailed(), (long)2000L, (long)50L);
        targetConn.close();
        bridge.stop();
        Assertions.assertFalse((boolean)bridge.isStarted());
        bridge.start();
        Assertions.assertTrue((boolean)bridge.isStarted());
        targetConn = JMSBridgeImplTest.createConnectionFactory().createConnection();
        targetSess = targetConn.createSession(false, 1);
        consumer = targetSess.createConsumer(targetDF.createDestination());
        messages.clear();
        consumer.setMessageListener(listener);
        targetConn.start();
        sourceSess = ((Connection)sourceConn.get()).createSession(false, 1);
        producer = sourceSess.createProducer(sourceDF.createDestination());
        producer.send((Message)sourceSess.createTextMessage());
        Wait.assertEquals((int)1, () -> messages.size(), (long)2000L, (long)100L);
        targetConn.close();
        ((Connection)sourceConn.get()).close();
        bridge.stop();
        Assertions.assertFalse((boolean)bridge.isStarted());
    }
}

