/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.jms2client;

import jakarta.jms.BytesMessage;
import jakarta.jms.CompletionListener;
import jakarta.jms.Destination;
import jakarta.jms.IllegalStateException;
import jakarta.jms.IllegalStateRuntimeException;
import jakarta.jms.InvalidDestinationRuntimeException;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSException;
import jakarta.jms.JMSProducer;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.Message;
import jakarta.jms.MessageFormatRuntimeException;
import jakarta.jms.MessageListener;
import jakarta.jms.Queue;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.tests.integration.jms.jms2client.JmsProducerCompletionListenerTest;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class JmsContextTest
extends JMSTestBase {
    private JMSContext context;
    private final Random random = new Random();
    private Queue queue1;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.context = this.createContext();
        this.queue1 = this.createQueue(JmsContextTest.class.getSimpleName() + "Queue");
    }

    @Test
    public void testCreateContext() {
        Assertions.assertNotNull((Object)this.context);
    }

    @Test
    public void testRollbackTest() {
        JMSContext ctx = this.addContext(this.cf.createContext(0));
        JMSProducer producer = ctx.createProducer();
        JMSConsumer cons = ctx.createConsumer((Destination)this.queue1);
        producer.send((Destination)this.queue1, (Message)this.context.createTextMessage("hello"));
        ctx.rollback();
        Assertions.assertNull((Object)cons.receiveNoWait());
        producer.send((Destination)this.queue1, (Message)this.context.createTextMessage("hello"));
        ctx.commit();
        Assertions.assertNotNull((Object)cons.receiveNoWait());
        ctx.commit();
        ctx.rollback();
        Assertions.assertNull((Object)cons.receiveNoWait());
        cons.close();
    }

    @Test
    public void testDupsOK() {
        JMSContext ctx = this.addContext(this.cf.createContext(3));
        Assertions.assertEquals((int)3, (int)ctx.getSessionMode());
        ctx.close();
        ctx = this.addContext(this.cf.createContext(0));
        Assertions.assertEquals((int)0, (int)ctx.getSessionMode());
        ctx.close();
        ctx = this.addContext(this.cf.createContext(2));
        Assertions.assertEquals((int)2, (int)ctx.getSessionMode());
        ctx.close();
        ctx = this.addContext(this.cf.createContext(1));
        Assertions.assertEquals((int)1, (int)ctx.getSessionMode());
    }

    @Test
    public void testReceiveBytes() throws Exception {
        JMSProducer producer = this.context.createProducer();
        JMSConsumer consumer = this.context.createConsumer((Destination)this.queue1);
        BytesMessage bytesSend = this.context.createBytesMessage();
        bytesSend.writeByte((byte)1);
        bytesSend.writeLong(2L);
        producer.send((Destination)this.queue1, (Message)bytesSend);
        BytesMessage msgReceived = (BytesMessage)consumer.receiveNoWait();
        byte[] bytesArray = (byte[])msgReceived.getBody(byte[].class);
        Assertions.assertEquals((byte)1, (byte)msgReceived.readByte());
        Assertions.assertEquals((long)2L, (long)msgReceived.readLong());
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(bytesArray));
        Assertions.assertEquals((byte)1, (byte)dataInputStream.readByte());
        Assertions.assertEquals((long)2L, (long)dataInputStream.readLong());
    }

    @Test
    public void testReceiveText() throws Exception {
        JMSProducer producer = this.context.createProducer();
        JMSConsumer consumer = this.context.createConsumer((Destination)this.queue1);
        String randomStr = this.newXID().toString();
        TextMessage sendMsg = this.context.createTextMessage(randomStr);
        producer.send((Destination)this.queue1, (Message)sendMsg);
        TextMessage receiveMsg = (TextMessage)consumer.receiveNoWait();
        Assertions.assertEquals((Object)randomStr, (Object)receiveMsg.getText());
    }

    @Test
    public void testDelay() throws Exception {
        JMSProducer producer = this.context.createProducer();
        JMSConsumer consumer = this.context.createConsumer((Destination)this.queue1);
        producer.setDeliveryDelay(500L);
        long timeStart = System.currentTimeMillis();
        String strRandom = this.newXID().toString();
        producer.send((Destination)this.queue1, (Message)this.context.createTextMessage(strRandom));
        TextMessage msg = (TextMessage)consumer.receive(2500L);
        Assertions.assertNotNull((Object)msg);
        long actualDelay = System.currentTimeMillis() - timeStart;
        Assertions.assertTrue((actualDelay >= 500L && actualDelay < 2000L ? 1 : 0) != 0, (String)("delay is not working, actualDelay=" + actualDelay));
        Assertions.assertEquals((Object)strRandom, (Object)msg.getText());
    }

    @Test
    public void testExpire() throws Exception {
        JMSProducer producer = this.context.createProducer();
        producer.setTimeToLive(500L);
        String strRandom = this.newXID().toString();
        producer.send((Destination)this.queue1, (Message)this.context.createTextMessage(strRandom));
        Thread.sleep(700L);
        JMSConsumer consumer = this.context.createConsumer((Destination)this.queue1);
        TextMessage msg = (TextMessage)consumer.receiveNoWait();
        Assertions.assertNull((Object)msg);
        strRandom = this.newXID().toString();
        producer.send((Destination)this.queue1, (Message)this.context.createTextMessage(strRandom));
        Thread.sleep(700L);
        msg = (TextMessage)consumer.receiveNoWait();
        Assertions.assertNull((Object)msg);
        strRandom = this.newXID().toString();
        producer.send((Destination)this.queue1, (Message)this.context.createTextMessage(strRandom));
        msg = (TextMessage)consumer.receiveNoWait();
        Assertions.assertNotNull((Object)msg);
        Assertions.assertEquals((Object)strRandom, (Object)msg.getText());
    }

    @Test
    public void testDeliveryMode() throws Exception {
        JMSProducer producer = this.context.createProducer();
        JMSConsumer consumer = this.context.createConsumer((Destination)this.queue1);
        producer.setDeliveryMode(1);
        String strRandom = this.newXID().toString();
        producer.send((Destination)this.queue1, (Message)this.context.createTextMessage(strRandom));
        TextMessage msg = (TextMessage)consumer.receiveNoWait();
        Assertions.assertNotNull((Object)msg);
        Assertions.assertEquals((int)1, (int)msg.getJMSDeliveryMode());
    }

    @Test
    public void testInvalidMessage() {
        JMSProducer producer = this.context.createProducer();
        try {
            producer.send((Destination)this.queue1, (Message)null);
            Assertions.fail((String)"null msg");
        }
        catch (MessageFormatRuntimeException messageFormatRuntimeException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidDestination() {
        JMSProducer producer = this.context.createProducer();
        Message msg = this.context.createMessage();
        try {
            producer.send((Destination)null, msg);
            Assertions.fail((String)"null Destination");
        }
        catch (InvalidDestinationRuntimeException invalidDestinationRuntimeException) {
            // empty catch block
        }
    }

    @Test
    public void testSendStreamMessage() throws JMSException, InterruptedException {
        JmsProducerCompletionListenerTest.CountingCompletionListener cl = new JmsProducerCompletionListenerTest.CountingCompletionListener(1);
        JMSProducer producer = this.context.createProducer();
        producer.setAsync((CompletionListener)cl);
        StreamMessage msg = this.context.createStreamMessage();
        msg.setStringProperty("name", this.name);
        String bprop = "booleanProp";
        String iprop = "intProp";
        msg.setBooleanProperty(bprop, true);
        msg.setIntProperty(iprop, 42);
        msg.writeBoolean(true);
        msg.writeInt(67);
        producer.send((Destination)this.queue1, (Message)msg);
        JMSConsumer consumer = this.context.createConsumer((Destination)this.queue1);
        Message msg2 = consumer.receive(100L);
        Assertions.assertNotNull((Object)msg2);
        Assertions.assertTrue((boolean)cl.completionLatch.await(1L, TimeUnit.SECONDS));
        StreamMessage sm = (StreamMessage)cl.lastMessage;
        Assertions.assertTrue((boolean)sm.getBooleanProperty(bprop));
        Assertions.assertEquals((int)42, (int)sm.getIntProperty(iprop));
        Assertions.assertTrue((boolean)sm.readBoolean());
        Assertions.assertEquals((int)67, (int)sm.readInt());
    }

    @Test
    public void testSetClientIdLate() {
        JMSProducer producer = this.context.createProducer();
        Message msg = this.context.createMessage();
        producer.send((Destination)this.queue1, msg);
        try {
            this.context.setClientID("id");
            Assertions.fail((String)"expected exception");
        }
        catch (IllegalStateRuntimeException illegalStateRuntimeException) {
            // empty catch block
        }
    }

    @Test
    public void testCloseSecondContextConnectionRemainsOpen() throws JMSException {
        JMSContext localContext = this.context.createContext(2);
        Assertions.assertEquals((int)2, (int)localContext.getSessionMode(), (String)"client_ack");
        JMSProducer producer = localContext.createProducer();
        JMSConsumer consumer = localContext.createConsumer((Destination)this.queue1);
        boolean pass = true;
        for (int idx = 0; idx < 2; ++idx) {
            Message m = localContext.createMessage();
            int intProperty = this.random.nextInt();
            m.setIntProperty("random", intProperty);
            Assertions.assertNotNull((Object)m);
            producer.send((Destination)this.queue1, m);
            m = null;
            Message msg = consumer.receive(100L);
            Assertions.assertNotNull((Object)msg, (String)"must have a msg");
            Assertions.assertEquals((int)intProperty, (int)msg.getIntProperty("random"));
            if (idx == 1) {
                localContext.close();
            }
            try {
                msg.acknowledge();
                Assertions.assertEquals((int)0, (int)idx, (String)"connection should be open on pass 0. It is 1");
                continue;
            }
            catch (IllegalStateException expected) {
                Assertions.assertEquals((int)1, (int)idx, (String)"we only close the connection on pass 1");
            }
        }
    }

    @Test
    public void testInvalidSessionModesValueMinusOne() {
        Assertions.assertThrows(JMSRuntimeException.class, () -> this.context.createContext(-1));
    }

    @Test
    public void testInvalidSessionModesValue4() {
        Assertions.assertThrows(JMSRuntimeException.class, () -> this.context.createContext(4));
    }

    @Test
    public void testGetAnotherContextFromIt() {
        JMSContext c2 = this.context.createContext(3);
        Assertions.assertNotNull((Object)c2);
        Assertions.assertEquals((int)3, (int)c2.getSessionMode());
        Message m2 = c2.createMessage();
        Assertions.assertNotNull((Object)m2);
        c2.close();
        try {
            c2.createMessage();
            Assertions.fail((String)"session should be closed...");
        }
        catch (JMSRuntimeException jMSRuntimeException) {
            // empty catch block
        }
        Message m1 = this.context.createMessage();
        Assertions.assertNotNull((Object)m1, (String)"connection must be open");
    }

    @Test
    public void testSetGetClientIdNewContext() {
        String id = "123";
        JMSContext c = this.context;
        c.setClientID("123");
        JMSContext c2 = this.addContext(c.createContext(2));
        Assertions.assertEquals((Object)"123", (Object)c2.getClientID());
    }

    @Test
    public void testGetClientId() {
        JMSContext context2 = this.addContext(this.context.createContext(1));
        String id = "ID: " + this.random.nextInt();
        this.context.setClientID(id);
        Assertions.assertEquals((Object)id, (Object)context2.getClientID(), (String)"id's must match because the connection is shared");
    }

    @Test
    public void testCreateConsumerWithSelector() throws JMSException {
        String filterName = "magicIndexMessage";
        int total = 5;
        JMSProducer producer = this.context.createProducer();
        JMSConsumer consumerNoSelect = this.context.createConsumer((Destination)this.queue1);
        JMSConsumer consumer = this.context.createConsumer((Destination)this.queue1, "magicIndexMessage=TRUE");
        for (int i = 0; i < 5; ++i) {
            TextMessage msg = this.context.createTextMessage("message " + i);
            msg.setBooleanProperty("magicIndexMessage", i == 3);
            producer.send((Destination)this.queue1, (Message)msg);
        }
        Message msg0 = consumer.receive(500L);
        Assertions.assertNotNull((Object)msg0);
        msg0.acknowledge();
        Assertions.assertNull((Object)consumer.receiveNoWait(), (String)"no more messages");
        for (int i = 0; i < 4; ++i) {
            Message msg = consumerNoSelect.receive(100L);
            Assertions.assertNotNull((Object)msg);
            msg.acknowledge();
        }
        Assertions.assertNull((Object)consumerNoSelect.receiveNoWait(), (String)"no more messages");
    }

    @Test
    public void testContextStopAndCloseFromMessageListeners() throws Exception {
        JMSContext context1 = this.context.createContext(1);
        JMSConsumer consumer1 = context1.createConsumer((Destination)this.queue1);
        CountDownLatch latch1 = new CountDownLatch(1);
        InvalidMessageListener listener1 = new InvalidMessageListener(context1, latch1, 1);
        consumer1.setMessageListener((MessageListener)listener1);
        JMSProducer producer = context1.createProducer();
        TextMessage msg = context1.createTextMessage("first message");
        producer.send((Destination)this.queue1, (Message)msg);
        latch1.await();
        Throwable error1 = listener1.getError();
        Assertions.assertNotNull((Object)error1);
        Assertions.assertTrue((boolean)(error1 instanceof IllegalStateRuntimeException));
        context1.close();
        JMSContext context2 = this.context.createContext(1);
        JMSConsumer consumer2 = context2.createConsumer((Destination)this.queue1);
        CountDownLatch latch2 = new CountDownLatch(1);
        InvalidMessageListener listener2 = new InvalidMessageListener(context2, latch2, 2);
        consumer2.setMessageListener((MessageListener)listener2);
        JMSProducer producer2 = context2.createProducer();
        TextMessage msg2 = context2.createTextMessage("second message");
        producer2.send((Destination)this.queue1, (Message)msg2);
        latch2.await();
        Throwable error2 = listener2.getError();
        Assertions.assertNotNull((Object)error2);
        Assertions.assertTrue((boolean)(error2 instanceof IllegalStateRuntimeException));
        context2.close();
    }

    @Test
    public void recoverAckTest() throws Exception {
        try (JMSContext context = this.cf.createContext(2);){
            int i;
            int numMessages = 10;
            TextMessage textMessage = null;
            JMSConsumer consumer = context.createConsumer((Destination)this.queue1);
            JMSProducer producer = context.createProducer();
            for (i = 0; i < numMessages; ++i) {
                String message = "text message " + i;
                textMessage = context.createTextMessage(message);
                textMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "recoverAckTest" + i);
                producer.send((Destination)this.queue1, (Message)textMessage);
            }
            for (i = 0; i < numMessages; ++i) {
                textMessage = (TextMessage)consumer.receive(5000L);
                Assertions.assertNotNull((Object)textMessage);
            }
            context.recover();
            for (i = 0; i < numMessages; ++i) {
                textMessage = (TextMessage)consumer.receive(5000L);
                Assertions.assertNotNull((Object)textMessage);
            }
            context.acknowledge();
        }
        context = this.cf.createContext(2);
        try {
            JMSConsumer consumer = context.createConsumer((Destination)this.queue1);
            Assertions.assertNull((Object)consumer.receiveNoWait());
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    @Test
    public void receiveNullAckTest() throws Exception {
        try (JMSContext context = this.cf.createContext(2);){
            int i;
            int numMessages = 10;
            TextMessage textMessage = null;
            JMSConsumer consumer = context.createConsumer((Destination)this.queue1);
            JMSProducer producer = context.createProducer();
            for (i = 0; i < numMessages; ++i) {
                String message = "text message " + i;
                textMessage = context.createTextMessage(message);
                textMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "recoverAckTest" + i);
                producer.send((Destination)this.queue1, (Message)textMessage);
            }
            for (i = 0; i < numMessages; ++i) {
                textMessage = (TextMessage)consumer.receive(5000L);
                Assertions.assertNotNull((Object)textMessage);
            }
            Assertions.assertNull((Object)consumer.receiveNoWait());
            context.acknowledge();
        }
        context = this.cf.createContext(2);
        try {
            JMSConsumer consumer = context.createConsumer((Destination)this.queue1);
            Assertions.assertNull((Object)consumer.receiveNoWait());
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void bytesMessage() throws Exception {
        this.context = this.cf.createContext();
        try {
            JMSProducer producer = this.context.createProducer();
            BytesMessage bMsg = this.context.createBytesMessage();
            bMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgOfEachTypeCLTest");
            bMsg.writeByte((byte)1);
            bMsg.writeInt(22);
            CountDownLatch latch = new CountDownLatch(1);
            SimpleCompletionListener listener = new SimpleCompletionListener(latch);
            producer.setAsync((CompletionListener)listener);
            producer.send((Destination)this.queue1, (Message)bMsg);
            Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
            Assertions.assertEquals((byte)listener.message.readByte(), (byte)1);
            Assertions.assertEquals((int)listener.message.readInt(), (int)22);
        }
        finally {
            this.context.close();
        }
    }

    @Test
    public void illegalStateRuntimeExceptionTests() throws Exception {
        JMSProducer producer = this.context.createProducer();
        JMSConsumer consumer = this.context.createConsumer((Destination)this.queue1);
        TextMessage expTextMessage = this.context.createTextMessage("Call commit");
        CountDownLatch latch = new CountDownLatch(1);
        JMSCOntextStopCompletionListener listener = new JMSCOntextStopCompletionListener(this.context, latch);
        producer.setAsync((CompletionListener)listener);
        producer.send((Destination)this.queue1, (Message)expTextMessage);
        Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        Assertions.assertNull((Object)listener.ex);
    }

    private static class InvalidMessageListener
    implements MessageListener {
        private int id;
        private CountDownLatch latch;
        private JMSContext context;
        private volatile Throwable error;

        private InvalidMessageListener(JMSContext context, CountDownLatch latch, int id) {
            this.id = id;
            this.latch = latch;
            this.context = context;
        }

        public Throwable getError() {
            return this.error;
        }

        public void onMessage(Message arg0) {
            switch (this.id) {
                case 1: {
                    this.stopContext();
                    break;
                }
                case 2: {
                    this.closeContext();
                    break;
                }
            }
            this.latch.countDown();
        }

        private void stopContext() {
            try {
                this.context.stop();
            }
            catch (Throwable t) {
                this.error = t;
            }
        }

        private void closeContext() {
            try {
                this.context.close();
            }
            catch (Throwable t) {
                this.error = t;
            }
        }
    }

    private static class SimpleCompletionListener
    implements CompletionListener {
        private CountDownLatch latch;
        private BytesMessage message;

        private SimpleCompletionListener(CountDownLatch latch) {
            this.latch = latch;
        }

        public void onCompletion(Message message) {
            this.message = (BytesMessage)message;
            this.latch.countDown();
        }

        public void onException(Message message, Exception exception) {
        }
    }

    private class JMSCOntextStopCompletionListener
    implements CompletionListener {
        private JMSContext context;
        private CountDownLatch latch;
        private Exception ex;

        private JMSCOntextStopCompletionListener(JMSContext context, CountDownLatch latch) {
            this.context = context;
            this.latch = latch;
        }

        public void onCompletion(Message message) {
            try {
                this.context.stop();
            }
            catch (Exception e) {
                this.ex = e;
            }
            this.latch.countDown();
        }

        public void onException(Message message, Exception exception) {
        }
    }
}

