/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.journal;

import java.io.FileInputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.aio.AIOSequentialFileFactory;
import org.apache.activemq.artemis.nativo.jlibaio.LibaioContext;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncOpenCloseTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCloseOnSubmit() throws Exception {
        Assumptions.assumeTrue((boolean)LibaioContext.isLoaded());
        final AtomicInteger errors = new AtomicInteger(0);
        AIOSequentialFileFactory factory = new AIOSequentialFileFactory(this.temporaryFolder, (error, message, file) -> errors.incrementAndGet(), 4096);
        factory.start();
        SequentialFile file2 = factory.createSequentialFile("fileAIO.bin");
        file2.open(1024, true);
        int WRITES = 100;
        int RECORD_SIZE = 4096;
        int OPEN_TIMES = 25;
        file2.fill(409600);
        ByteBuffer buffer = factory.newBuffer(4096);
        ActiveMQBuffer buffer2 = ActiveMQBuffers.wrappedBuffer((ByteBuffer)buffer);
        try {
            file2.close(true, false);
            final AtomicInteger submit = new AtomicInteger(0);
            final ReusableLatch valve = new ReusableLatch(0);
            byte writtenByte = 97;
            for (int nclose = 0; nclose < 25; ++nclose) {
                logger.debug("************************************************** test {}", (Object)nclose);
                writtenByte = (byte)(writtenByte + 1);
                if (writtenByte >= 122) {
                    writtenByte = 97;
                }
                buffer2.setIndex(0, 0);
                for (int s = 0; s < 4096; ++s) {
                    buffer2.writeByte(writtenByte);
                }
                file2.open(1024, true);
                final CyclicBarrier blocked = new CyclicBarrier(2);
                for (int i = 0; i < 100; ++i) {
                    if (i == 10) {
                        valve.countUp();
                    }
                    file2.position((long)(i * 4096));
                    submit.incrementAndGet();
                    buffer2.setIndex(0, 4096);
                    file2.write(buffer2, true, new IOCallback(){

                        public void done() {
                            try {
                                if (!valve.await(1L, TimeUnit.MILLISECONDS)) {
                                    logger.debug("blocking");
                                    blocked.await();
                                    valve.await(10L, TimeUnit.SECONDS);
                                    logger.debug("unblocking");
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                errors.incrementAndGet();
                            }
                            submit.decrementAndGet();
                        }

                        public void onError(int errorCode, String errorMessage) {
                            errors.incrementAndGet();
                        }
                    });
                }
                blocked.await();
                logger.debug("Closing");
                file2.close(false, false);
                this.validateFile(file2, writtenByte);
                valve.countDown();
                Wait.assertEquals((int)0, submit::get, (long)5000L, (long)10L);
            }
            Wait.assertEquals((int)0, submit::get);
        }
        finally {
            factory.releaseBuffer(buffer);
            factory.stop();
        }
        Assertions.assertEquals((int)0, (int)errors.get());
    }

    private void validateFile(SequentialFile file, byte writtenByte) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file.getJavaFile());
        byte[] wholeFile = fileInputStream.readAllBytes();
        for (int i = 0; i < wholeFile.length; ++i) {
            Assertions.assertEquals((byte)writtenByte, (byte)wholeFile[i]);
        }
        fileInputStream.close();
    }
}

