/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.journal;

import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.nio.NIOSequentialFileFactory;
import org.apache.activemq.artemis.tests.unit.core.journal.impl.JournalImplTestBase;
import org.apache.activemq.artemis.tests.unit.core.journal.impl.fakes.SimpleEncoding;
import org.junit.jupiter.api.Test;

public class NIOImportExportTest
extends JournalImplTestBase {
    @Override
    protected SequentialFileFactory getFileFactory() throws Exception {
        return new NIOSequentialFileFactory(this.getTestDirfile(), true, 1);
    }

    @Test
    public void testExportImport() throws Exception {
        this.setup(10, 40960, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.add(1L, 2L);
        this.journal.forceMoveNextFile();
        this.delete(1L, 2L);
        this.add(3L, 4L);
        this.journal.forceMoveNextFile();
        this.addTx(5L, 6L, 7L, 8L);
        this.journal.forceMoveNextFile();
        this.addTx(5L, 9L);
        this.commit(5L);
        this.journal.forceMoveNextFile();
        this.deleteTx(10L, 6L, 7L, 8L, 9L);
        this.commit(10L);
        this.addTx(11L, 11L, 12L);
        this.updateTx(11L, 11L, 12L);
        this.commit(11L);
        this.journal.forceMoveNextFile();
        this.update(11L, 12L);
        this.stopJournal();
        this.exportImportJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testExportImport3() throws Exception {
        this.setup(10, 40960, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.add(1L, 2L);
        this.journal.forceMoveNextFile();
        this.delete(1L, 2L);
        this.add(3L, 4L);
        this.journal.forceMoveNextFile();
        this.addTx(5L, 6L, 7L, 8L);
        this.journal.forceMoveNextFile();
        this.addTx(5L, 9L);
        this.commit(5L);
        this.journal.forceMoveNextFile();
        this.deleteTx(10L, 6L, 7L, 8L, 9L);
        this.commit(10L);
        this.addTx(11L, 12L, 13L);
        SimpleEncoding xid = new SimpleEncoding(10, 0);
        this.prepare(11L, xid);
        this.stopJournal();
        this.exportImportJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
        this.commit(11L);
        this.stopJournal();
        this.exportImportJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testExportImport2() throws Exception {
        this.setup(10, 40960, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.add(1L);
        this.stopJournal();
        this.exportImportJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }
}

