/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.management;

import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.AcceptorControl;
import org.apache.activemq.artemis.api.core.management.ActiveMQServerControl;
import org.apache.activemq.artemis.api.core.management.AddressControl;
import org.apache.activemq.artemis.api.core.management.BridgeControl;
import org.apache.activemq.artemis.api.core.management.BroadcastGroupControl;
import org.apache.activemq.artemis.api.core.management.ClusterConnectionControl;
import org.apache.activemq.artemis.api.core.management.ConnectionRouterControl;
import org.apache.activemq.artemis.api.core.management.DivertControl;
import org.apache.activemq.artemis.api.core.management.JGroupsChannelBroadcastGroupControl;
import org.apache.activemq.artemis.api.core.management.JGroupsFileBroadcastGroupControl;
import org.apache.activemq.artemis.api.core.management.ObjectNameBuilder;
import org.apache.activemq.artemis.api.core.management.QueueControl;

public class ManagementControlHelper {
    public static AcceptorControl createAcceptorControl(String name, MBeanServer mbeanServer) throws Exception {
        return (AcceptorControl)ManagementControlHelper.createProxy(ObjectNameBuilder.DEFAULT.getAcceptorObjectName(name), AcceptorControl.class, mbeanServer);
    }

    public static BroadcastGroupControl createBroadcastGroupControl(String name, MBeanServer mbeanServer) throws Exception {
        return (BroadcastGroupControl)ManagementControlHelper.createProxy(ObjectNameBuilder.DEFAULT.getBroadcastGroupObjectName(name), BroadcastGroupControl.class, mbeanServer);
    }

    public static JGroupsFileBroadcastGroupControl createJgroupsFileBroadcastGroupControl(String name, MBeanServer mbeanServer) throws Exception {
        return (JGroupsFileBroadcastGroupControl)ManagementControlHelper.createProxy(ObjectNameBuilder.DEFAULT.getBroadcastGroupObjectName(name), JGroupsFileBroadcastGroupControl.class, mbeanServer);
    }

    public static JGroupsChannelBroadcastGroupControl createJgroupsChannelBroadcastGroupControl(String name, MBeanServer mbeanServer) throws Exception {
        return (JGroupsChannelBroadcastGroupControl)ManagementControlHelper.createProxy(ObjectNameBuilder.DEFAULT.getBroadcastGroupObjectName(name), JGroupsChannelBroadcastGroupControl.class, mbeanServer);
    }

    public static BridgeControl createBridgeControl(String name, MBeanServer mbeanServer) throws Exception {
        return (BridgeControl)ManagementControlHelper.createProxy(ObjectNameBuilder.DEFAULT.getBridgeObjectName(name), BridgeControl.class, mbeanServer);
    }

    public static DivertControl createDivertControl(String name, String address, MBeanServer mbeanServer) throws Exception {
        return (DivertControl)ManagementControlHelper.createProxy(ObjectNameBuilder.DEFAULT.getDivertObjectName(name, address), DivertControl.class, mbeanServer);
    }

    public static ClusterConnectionControl createClusterConnectionControl(String name, MBeanServer mbeanServer) throws Exception {
        return (ClusterConnectionControl)ManagementControlHelper.createProxy(ObjectNameBuilder.DEFAULT.getClusterConnectionObjectName(name), ClusterConnectionControl.class, mbeanServer);
    }

    public static ActiveMQServerControl createActiveMQServerControl(MBeanServer mbeanServer) throws Exception {
        return (ActiveMQServerControl)ManagementControlHelper.createProxy(ObjectNameBuilder.DEFAULT.getActiveMQServerObjectName(), ActiveMQServerControl.class, mbeanServer);
    }

    public static QueueControl createQueueControl(SimpleString address, SimpleString name, MBeanServer mbeanServer) throws Exception {
        return (QueueControl)ManagementControlHelper.createProxy(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, ActiveMQDefaultConfiguration.getDefaultRoutingType()), QueueControl.class, mbeanServer);
    }

    public static QueueControl createQueueControl(SimpleString address, SimpleString name, RoutingType routingType, MBeanServer mbeanServer) throws Exception {
        return (QueueControl)ManagementControlHelper.createProxy(ObjectNameBuilder.DEFAULT.getQueueObjectName(address, name, routingType), QueueControl.class, mbeanServer);
    }

    public static AddressControl createAddressControl(SimpleString address, MBeanServer mbeanServer) throws Exception {
        return (AddressControl)ManagementControlHelper.createProxy(ObjectNameBuilder.DEFAULT.getAddressObjectName(address), AddressControl.class, mbeanServer);
    }

    public static ConnectionRouterControl createConnectionRouterControl(String name, MBeanServer mbeanServer) throws Exception {
        return (ConnectionRouterControl)ManagementControlHelper.createProxy(ObjectNameBuilder.DEFAULT.getConnectionRouterObjectName(name), ConnectionRouterControl.class, mbeanServer);
    }

    public static Object createProxy(ObjectName objectName, Class mbeanInterface, MBeanServer mbeanServer) {
        return MBeanServerInvocationHandler.newProxyInstance(mbeanServer, objectName, mbeanInterface, false);
    }
}

