/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire;

import org.apache.activemq.artemis.core.protocol.openwire.OpenWireProtocolManager;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.cluster.ClusterManager;
import org.apache.activemq.artemis.core.server.impl.Activation;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.selector.impl.LRUCache;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OpenWireProtocolManagerTest
extends ActiveMQTestBase {
    OpenWireProtocolManager underTest;
    LRUCache lruCacheRef;

    @Test
    public void testVtAutoConversion() {
        this.underTest = new OpenWireProtocolManager(null, (ActiveMQServer)new DummyServer(), null, null){

            public ActiveMQDestination virtualTopicConsumerToFQQN(ActiveMQDestination destination) {
                if (OpenWireProtocolManagerTest.this.lruCacheRef == null) {
                    OpenWireProtocolManagerTest.this.lruCacheRef = this.vtDestMapCache;
                }
                return super.virtualTopicConsumerToFQQN(destination);
            }
        };
        int maxCacheSize = 10;
        this.underTest.setVirtualTopicConsumerLruCacheMax(10);
        this.underTest.setVirtualTopicConsumerWildcards("A.>;1;selectorAware=true,B.*.>;2,C.*.*.*.EE;3;selectorAware=false");
        ActiveMQQueue A = new ActiveMQQueue("A.SomeTopic");
        Assertions.assertEquals((Object)new ActiveMQQueue("SomeTopic::A.SomeTopic"), (Object)this.underTest.virtualTopicConsumerToFQQN((ActiveMQDestination)A));
        ActiveMQDestination checkOption = this.underTest.virtualTopicConsumerToFQQN((ActiveMQDestination)A);
        Assertions.assertNotNull((Object)checkOption.getOptions());
        Assertions.assertTrue((boolean)Boolean.parseBoolean((String)checkOption.getOptions().get("selectorAware")));
        ActiveMQQueue B = new ActiveMQQueue("B.b.SomeTopic.B");
        Assertions.assertEquals((Object)new ActiveMQQueue("SomeTopic.B::B.b.SomeTopic.B"), (Object)this.underTest.virtualTopicConsumerToFQQN((ActiveMQDestination)B));
        ActiveMQQueue C = new ActiveMQQueue("C.c.c.SomeTopic.EE");
        Assertions.assertEquals((Object)new ActiveMQQueue("SomeTopic.EE::C.c.c.SomeTopic.EE"), (Object)this.underTest.virtualTopicConsumerToFQQN((ActiveMQDestination)C));
        checkOption = this.underTest.virtualTopicConsumerToFQQN((ActiveMQDestination)C);
        Assertions.assertNull((Object)checkOption.getOptions());
        for (int i = 0; i < 10; ++i) {
            ActiveMQQueue identity = new ActiveMQQueue("Identity" + i);
            Assertions.assertEquals((Object)identity, (Object)this.underTest.virtualTopicConsumerToFQQN((ActiveMQDestination)identity));
        }
        Assertions.assertFalse((boolean)this.lruCacheRef.containsKey((Object)A));
    }

    static final class DummyServer
    extends ActiveMQServerImpl {
        DummyServer() {
        }

        public ClusterManager getClusterManager() {
            return new ClusterManager(this.getExecutorFactory(), (ActiveMQServer)this, null, null, null, null, null, false);
        }

        public ExecutorFactory getExecutorFactory() {
            return () -> null;
        }

        public Activation getActivation() {
            return new Activation(){

                public void close(boolean permanently, boolean restarting) throws Exception {
                }

                public void run() {
                }
            };
        }
    }
}

