/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.paging;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.core.paging.cursor.impl.PageSubscriptionCounterImpl;
import org.apache.activemq.artemis.core.paging.cursor.impl.PageSubscriptionCounterImplAccessor;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageCounterRebuildTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Test
    public void testUnitSize() throws Exception {
        int j;
        AtomicInteger errors = new AtomicInteger(0);
        StorageManager mockStorage = (StorageManager)Mockito.mock(StorageManager.class);
        PageSubscriptionCounterImpl nonPersistentPagingCounter = new PageSubscriptionCounterImpl(mockStorage, -1L);
        int THREADS = 33;
        int ADD_VALUE = 7;
        int SIZE_VALUE = 17;
        int REPEAT = 777;
        ExecutorService executorService = Executors.newFixedThreadPool(33);
        this.runAfter(executorService::shutdownNow);
        CyclicBarrier startFlag = new CyclicBarrier(33);
        ReusableLatch latch = new ReusableLatch(33);
        for (j = 0; j < 33; ++j) {
            executorService.execute(() -> {
                try {
                    startFlag.await(10L, TimeUnit.SECONDS);
                    for (int i = 0; i < 777; ++i) {
                        nonPersistentPagingCounter.increment(null, 7, 17L);
                    }
                }
                catch (Throwable e) {
                    logger.warn(e.getMessage(), e);
                    errors.incrementAndGet();
                }
                finally {
                    latch.countDown();
                }
            });
        }
        Assertions.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
        Assertions.assertEquals((long)179487L, (long)nonPersistentPagingCounter.getValue());
        Assertions.assertEquals((long)435897L, (long)nonPersistentPagingCounter.getPersistentSize());
        latch.setCount(33);
        for (j = 0; j < 33; ++j) {
            executorService.execute(() -> {
                try {
                    startFlag.await(10L, TimeUnit.SECONDS);
                    for (int i = 0; i < 777; ++i) {
                        nonPersistentPagingCounter.increment(null, -7, -17L);
                    }
                }
                catch (Throwable e) {
                    logger.warn(e.getMessage(), e);
                    errors.incrementAndGet();
                }
                finally {
                    latch.countDown();
                }
            });
        }
        Assertions.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
        Assertions.assertEquals((long)0L, (long)nonPersistentPagingCounter.getValue());
        Assertions.assertEquals((long)0L, (long)nonPersistentPagingCounter.getPersistentSize());
        Assertions.assertEquals((int)0, (int)errors.get());
    }

    @Test
    public void testResetSubscriptionCounter() throws Exception {
        StorageManager mockStorage = (StorageManager)Mockito.mock(StorageManager.class);
        PageSubscriptionCounterImpl nonPersistentPagingCounter = new PageSubscriptionCounterImpl(mockStorage, 33L);
        AtomicInteger called = new AtomicInteger(0);
        AtomicLong generate = new AtomicLong(1L);
        ((StorageManager)Mockito.doAnswer(invocationOnMock -> generate.incrementAndGet()).when((Object)mockStorage)).generateID();
        ((StorageManager)Mockito.doAnswer(invocationOnMock -> {
            called.incrementAndGet();
            return null;
        }).when((Object)mockStorage)).commit(Mockito.anyLong());
        PageSubscriptionCounterImplAccessor.reset(nonPersistentPagingCounter);
        Assertions.assertEquals((int)1, (int)called.get());
    }

    @Test
    public void testRebuildCounter() throws Exception {
        Message message;
        int i;
        MessageConsumer consumer;
        Session session;
        ActiveMQServer server = this.createServer(true, true);
        AddressSettings defaultSetting = new AddressSettings().setPageSizeBytes(102400).setMaxReadPageMessages(1);
        server.getAddressSettingsRepository().addMatch("#", (Object)defaultSetting);
        server.start();
        String queueName = this.getName();
        String nonConsumedQueueName = this.getName() + "_nonConsumed";
        server.addAddressInfo(new AddressInfo(queueName).addRoutingType(RoutingType.MULTICAST));
        server.createQueue(QueueConfiguration.of((String)nonConsumedQueueName).setAddress(queueName).setRoutingType(RoutingType.MULTICAST));
        server.createQueue(QueueConfiguration.of((String)queueName).setRoutingType(RoutingType.MULTICAST));
        Queue serverQueue = server.locateQueue(queueName);
        Queue serverNonConsumedQueue = server.locateQueue(nonConsumedQueueName);
        Assertions.assertNotNull((Object)serverQueue);
        Assertions.assertNotNull((Object)serverNonConsumedQueue);
        serverQueue.getPagingStore().startPaging();
        int THREADS = 4;
        int TX_SEND = 2000;
        int NON_TXT_SEND = 200;
        int CONSUME_MESSAGES = 200;
        AtomicInteger errors = new AtomicInteger(0);
        ExecutorService executorService = Executors.newFixedThreadPool(4);
        this.runAfter(executorService::shutdownNow);
        CyclicBarrier startFlag = new CyclicBarrier(4);
        ReusableLatch latch = new ReusableLatch(4);
        int i2 = 0;
        while (i2 < 4) {
            int threadNumber = i2++;
            executorService.execute(() -> {
                try {
                    startFlag.await(10L, TimeUnit.SECONDS);
                    ConnectionFactory factory = CFUtil.createConnectionFactory("core", "tcp://localhost:61616");
                    try (Connection connection = factory.createConnection();
                         Session session = connection.createSession(false, 1);
                         Session txSession = connection.createSession(true, 1);){
                        int message;
                        logger.info("sending thread {}", (Object)threadNumber);
                        Topic jmsQueue = session.createTopic(queueName);
                        MessageProducer producerNonTX = session.createProducer((Destination)jmsQueue);
                        MessageProducer producerTX = txSession.createProducer((Destination)jmsQueue);
                        for (message = 0; message < 200; ++message) {
                            TextMessage txtMessage = session.createTextMessage("hello" + message);
                            txtMessage.setBooleanProperty("first", false);
                            producerNonTX.send((Message)session.createTextMessage("hello" + message));
                        }
                        for (message = 0; message < 2000; ++message) {
                            producerTX.send((Message)session.createTextMessage("helloTX" + message));
                        }
                        txSession.commit();
                    }
                }
                catch (Throwable e) {
                    errors.incrementAndGet();
                }
                finally {
                    latch.countDown();
                }
            });
        }
        Assertions.assertTrue((boolean)latch.await(1L, TimeUnit.MINUTES));
        int numberOfMessages = 8800;
        Wait.assertEquals((long)8800L, () -> ((Queue)serverQueue).getMessageCount());
        ConnectionFactory factory = CFUtil.createConnectionFactory("core", "tcp://localhost:61616");
        try (Connection connection = factory.createConnection();){
            session = connection.createSession(false, 1);
            try {
                consumer = session.createConsumer((Destination)session.createQueue(queueName + "::" + queueName));
                connection.start();
                for (i = 0; i < 200; ++i) {
                    message = consumer.receive(5000L);
                    Assertions.assertNotNull((Object)message);
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        Wait.assertEquals((long)8600L, () -> ((Queue)serverQueue).getMessageCount());
        Wait.assertEquals((long)8800L, () -> ((Queue)serverNonConsumedQueue).getMessageCount());
        server.stop();
        server.start();
        serverQueue = server.locateQueue(queueName);
        serverNonConsumedQueue = server.locateQueue(nonConsumedQueueName);
        Wait.assertEquals((long)8600L, () -> ((Queue)serverQueue).getMessageCount());
        Wait.assertEquals((long)8800L, () -> ((Queue)serverNonConsumedQueue).getMessageCount());
        serverQueue.getPageSubscription().getCounter().markRebuilding();
        serverNonConsumedQueue.getPageSubscription().getCounter().markRebuilding();
        Assertions.assertEquals((long)8600L, (long)serverQueue.getMessageCount());
        Assertions.assertEquals((long)8800L, (long)serverNonConsumedQueue.getMessageCount());
        serverQueue.getPageSubscription().getCounter().finishRebuild();
        serverNonConsumedQueue.getPageSubscription().getCounter().finishRebuild();
        Assertions.assertEquals((long)0L, (long)serverQueue.getMessageCount());
        Assertions.assertEquals((long)0L, (long)serverNonConsumedQueue.getMessageCount());
        server.stop();
        server.start();
        serverQueue = server.locateQueue(queueName);
        serverNonConsumedQueue = server.locateQueue(nonConsumedQueueName);
        Wait.assertEquals((long)8600L, () -> ((Queue)serverQueue).getMessageCount());
        Wait.assertEquals((long)8800L, () -> ((Queue)serverNonConsumedQueue).getMessageCount());
        server.stop();
        server.start();
        serverQueue = server.locateQueue(queueName);
        serverNonConsumedQueue = server.locateQueue(nonConsumedQueueName);
        Assertions.assertNotNull((Object)serverQueue);
        Assertions.assertNotNull((Object)serverNonConsumedQueue);
        Wait.assertEquals((long)8600L, () -> ((Queue)serverQueue).getMessageCount());
        Wait.assertEquals((long)8800L, () -> ((Queue)serverNonConsumedQueue).getMessageCount());
        server.stop();
        server.start();
        logger.info("Consuming messages");
        factory = CFUtil.createConnectionFactory("core", "tcp://localhost:61616");
        connection = factory.createConnection();
        try {
            session = connection.createSession(false, 1);
            try {
                consumer = session.createConsumer((Destination)session.createQueue(queueName + "::" + queueName));
                connection.start();
                for (i = 0; i < 8600; ++i) {
                    message = consumer.receive(5000L);
                    Assertions.assertNotNull((Object)message);
                    if (i % 100 != 0) continue;
                    logger.info("Received {} messages", (Object)i);
                }
                Assertions.assertNull((Object)consumer.receiveNoWait());
                consumer.close();
                consumer = session.createConsumer((Destination)session.createQueue(queueName + "::" + nonConsumedQueueName));
                connection.start();
                for (i = 0; i < 8800; ++i) {
                    message = consumer.receive(5000L);
                    Assertions.assertNotNull((Object)message);
                }
                Assertions.assertNull((Object)consumer.receiveNoWait());
                consumer.close();
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        serverQueue = server.locateQueue(queueName);
        serverNonConsumedQueue = server.locateQueue(nonConsumedQueueName);
        Wait.assertEquals((Long)0L, () -> ((Queue)serverQueue).getMessageCount(), (long)1000L, (long)100L);
        Wait.assertEquals((Long)0L, () -> ((Queue)serverNonConsumedQueue).getMessageCount(), (long)1000L, (long)100L);
    }
}

