/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.replication;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorImpl;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.DistributedLockManagerConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicationBackupPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicationPrimaryPolicyConfiguration;
import org.apache.activemq.artemis.core.server.ActivateCallback;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.impl.FileLockNodeManager;
import org.apache.activemq.artemis.lockmanager.DistributedLock;
import org.apache.activemq.artemis.lockmanager.DistributedLockManager;
import org.apache.activemq.artemis.lockmanager.MutableLong;
import org.apache.activemq.artemis.lockmanager.file.FileBasedLockManager;
import org.apache.activemq.artemis.tests.integration.replication.SharedNothingReplicationTest;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class LockManagerReplicationTest
extends SharedNothingReplicationTest {
    private DistributedLockManagerConfiguration managerConfiguration;

    @BeforeEach
    public void init() throws IOException {
        this.managerConfiguration = new DistributedLockManagerConfiguration(FileBasedLockManager.class.getName(), Collections.singletonMap("locks-folder", LockManagerReplicationTest.newFolder(this.temporaryFolder, "manager").toString()));
    }

    @Override
    protected HAPolicyConfiguration createReplicationPrimaryConfiguration() {
        ReplicationPrimaryPolicyConfiguration haPolicy = ReplicationPrimaryPolicyConfiguration.withDefault();
        haPolicy.setDistributedManagerConfiguration(this.managerConfiguration);
        return haPolicy;
    }

    @Override
    protected HAPolicyConfiguration createReplicationBackupConfiguration() {
        ReplicationBackupPolicyConfiguration haPolicy = ReplicationBackupPolicyConfiguration.withDefault();
        haPolicy.setDistributedManagerConfiguration(this.managerConfiguration);
        haPolicy.setClusterName("cluster");
        return haPolicy;
    }

    @Test
    public void testUnReplicatedOrderedTransition() throws Exception {
        Configuration primaryConfiguration = this.createPrimaryConfiguration();
        ActiveMQServer primaryServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)primaryConfiguration));
        primaryServer.setIdentity("PRIMARY");
        primaryServer.start();
        org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)primaryServer).isStarted());
        ServerLocator locator = ServerLocatorImpl.newLocator((String)"(tcp://localhost:61616,tcp://localhost:61617)?ha=true");
        locator.setCallTimeout(60000L);
        locator.setConnectionTTL(60000L);
        ClientSessionFactory csf = locator.createSessionFactory();
        ClientSession clientSession = csf.createSession();
        clientSession.createQueue(QueueConfiguration.of((String)"slow").setRoutingType(RoutingType.ANYCAST));
        clientSession.close();
        Configuration backupConfiguration = this.createBackupConfiguration();
        ActiveMQServer backupServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)backupConfiguration));
        backupServer.setIdentity("BACKUP");
        backupServer.start();
        org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)backupServer).isStarted());
        LockManagerReplicationTest.waitForTopology(primaryServer, 1, 1, 30000L);
        LockManagerReplicationTest.waitForTopology(backupServer, 1, 1, 30000L);
        primaryServer.stop();
        csf = locator.createSessionFactory();
        clientSession = csf.createSession();
        clientSession.createQueue(QueueConfiguration.of((String)"slow_un_replicated").setRoutingType(RoutingType.ANYCAST));
        clientSession.close();
        LockManagerReplicationTest.waitForTopology(backupServer, 1, 0, 30000L);
        Assertions.assertTrue((boolean)org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> 2L == backupServer.getNodeManager().getNodeActivationSequence()));
        backupServer.stop(false);
        primaryServer.start();
        org.apache.activemq.artemis.tests.util.Wait.assertFalse(() -> ((ActiveMQServer)primaryServer).isActive());
        primaryServer.stop();
        backupServer.start();
        org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)backupServer).isStarted());
        Assertions.assertEquals((long)3L, (long)backupServer.getNodeManager().getNodeActivationSequence());
        csf = locator.createSessionFactory();
        clientSession = csf.createSession();
        clientSession.createQueue(QueueConfiguration.of((String)"backup_as_un_replicated").setRoutingType(RoutingType.ANYCAST));
        clientSession.close();
        primaryServer.start();
        csf = locator.createSessionFactory();
        clientSession = csf.createSession();
        clientSession.createQueue(QueueConfiguration.of((String)"backup_as_replicated").setRoutingType(RoutingType.ANYCAST));
        clientSession.close();
        Assertions.assertTrue((boolean)org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)primaryServer).isReplicaSync()));
        Assertions.assertTrue((boolean)org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> 3L == primaryServer.getNodeManager().getNodeActivationSequence()));
        backupServer.stop(true);
        LockManagerReplicationTest.waitForTopology(primaryServer, 1, 0, 30000L);
        Assertions.assertTrue((boolean)org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> 4L == primaryServer.getNodeManager().getNodeActivationSequence()));
        primaryServer.stop(true);
        clientSession.close();
        locator.close();
    }

    @Test
    public void testBackupFailoverAndPrimaryFailback() throws Exception {
        int timeout = (int)TimeUnit.SECONDS.toMillis(30L);
        Configuration primaryConfiguration = this.createPrimaryConfiguration();
        ActiveMQServer primaryInstance = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)primaryConfiguration));
        primaryInstance.setIdentity("PRIMARY");
        primaryInstance.start();
        Assertions.assertEquals((long)1L, (long)primaryInstance.getNodeManager().getNodeActivationSequence());
        Configuration backupConfiguration = this.createBackupConfiguration();
        ((ReplicationBackupPolicyConfiguration)backupConfiguration.getHAPolicyConfiguration()).setAllowFailBack(true);
        ActiveMQServer backupServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)backupConfiguration));
        backupServer.setIdentity("BACKUP");
        backupServer.start();
        org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)backupServer).isStarted());
        Wait.assertTrue(() -> backupServer.isReplicaSync(), (long)timeout);
        Assertions.assertEquals((long)1L, (long)primaryInstance.getNodeManager().getNodeActivationSequence());
        Assertions.assertEquals((long)1L, (long)backupServer.getNodeManager().getNodeActivationSequence());
        primaryInstance.stop();
        Wait.assertTrue(() -> 2L == backupServer.getNodeManager().getNodeActivationSequence(), (long)timeout);
        TimeUnit.MILLISECONDS.sleep(100L);
        ActiveMQServer restartedPrimaryForFailBack = primaryInstance;
        restartedPrimaryForFailBack.start();
        Wait.assertTrue(() -> backupServer.isReplicaSync(), (long)timeout);
        Wait.assertTrue(() -> {
            try {
                return 3L == restartedPrimaryForFailBack.getNodeManager().getNodeActivationSequence();
            }
            catch (NullPointerException ok) {
                return false;
            }
        }, (long)timeout);
        Wait.assertTrue(() -> restartedPrimaryForFailBack.isReplicaSync(), (long)timeout);
        Wait.assertTrue(() -> backupServer.isReplicaSync(), (long)timeout);
        Wait.assertTrue(() -> 3L == backupServer.getNodeManager().getNodeActivationSequence(), (long)timeout);
        TimeUnit.MILLISECONDS.sleep(100L);
        backupServer.stop();
        TimeUnit.MILLISECONDS.sleep(100L);
        Wait.assertTrue(() -> {
            try {
                return 4L == restartedPrimaryForFailBack.getNodeManager().getNodeActivationSequence();
            }
            catch (NullPointerException ok) {
                return false;
            }
        }, (long)timeout);
        restartedPrimaryForFailBack.stop();
    }

    @Test
    public void testPrimaryIncrementActivationSequenceOnUnReplicated() throws Exception {
        int timeout = (int)TimeUnit.SECONDS.toMillis(30L);
        Configuration primaryConfiguration = this.createPrimaryConfiguration();
        ActiveMQServer primaryInstance = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)primaryConfiguration));
        primaryInstance.setIdentity("PRIMARY");
        primaryInstance.start();
        Assertions.assertEquals((long)1L, (long)primaryInstance.getNodeManager().getNodeActivationSequence());
        Configuration backupConfiguration = this.createBackupConfiguration();
        ActiveMQServer backupServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)backupConfiguration));
        backupServer.setIdentity("BACKUP");
        backupServer.start();
        org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)backupServer).isStarted());
        Wait.assertTrue(() -> backupServer.isReplicaSync(), (long)timeout);
        Assertions.assertEquals((long)1L, (long)primaryInstance.getNodeManager().getNodeActivationSequence());
        Assertions.assertEquals((long)1L, (long)backupServer.getNodeManager().getNodeActivationSequence());
        backupServer.stop();
        Wait.assertTrue(() -> 2L == primaryInstance.getNodeManager().getNodeActivationSequence(), (long)timeout);
        primaryInstance.stop();
    }

    @Test
    public void testBackupStartsFirst() throws Exception {
        Configuration backupConfiguration = this.createBackupConfiguration();
        ActiveMQServer backupServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)backupConfiguration));
        backupServer.setIdentity("BACKUP");
        backupServer.start();
        Configuration primaryConfiguration = this.createPrimaryConfiguration();
        ActiveMQServer primaryServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)primaryConfiguration));
        primaryServer.setIdentity("PRIMARY");
        primaryServer.start();
        org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)primaryServer).isStarted());
        Assertions.assertTrue((boolean)org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)backupServer).isStarted()));
        Assertions.assertTrue((boolean)org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)backupServer).isReplicaSync()));
        Assertions.assertTrue((boolean)primaryServer.isReplicaSync());
    }

    @Test
    public void testBackupOutOfSequenceReleasesLock() throws Exception {
        Configuration backupConfiguration = this.createBackupConfiguration();
        ActiveMQServer backupServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)backupConfiguration));
        backupServer.setIdentity("BACKUP");
        backupServer.start();
        Configuration primaryConfiguration = this.createPrimaryConfiguration();
        ActiveMQServer primaryServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)primaryConfiguration));
        primaryServer.setIdentity("PRIMARY");
        primaryServer.start();
        org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)primaryServer).isStarted());
        Assertions.assertTrue((boolean)org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)backupServer).isStarted()));
        Assertions.assertTrue((boolean)org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)backupServer).isReplicaSync()));
        Assertions.assertTrue((boolean)primaryServer.isReplicaSync());
        backupServer.stop();
        TimeUnit.SECONDS.sleep(1L);
        primaryServer.stop();
        backupServer.start();
        primaryServer.start();
        org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)primaryServer).isStarted());
        Assertions.assertTrue((boolean)org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)backupServer).isStarted()));
        Assertions.assertTrue((boolean)org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)backupServer).isReplicaSync()));
        Assertions.assertTrue((boolean)primaryServer.isReplicaSync());
    }

    @Test
    public void testBackupOutOfSequenceCheckActivationSequence() throws Exception {
        Configuration backupConfiguration = this.createBackupConfiguration();
        ActiveMQServer backupServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)backupConfiguration));
        backupServer.setIdentity("BACKUP");
        backupServer.start();
        Configuration primaryConfiguration = this.createPrimaryConfiguration();
        ActiveMQServer primaryServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)primaryConfiguration));
        primaryServer.setIdentity("PRIMARY");
        primaryServer.start();
        org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)primaryServer).isStarted());
        Assertions.assertTrue((boolean)org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)backupServer).isStarted()));
        Assertions.assertTrue((boolean)org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)backupServer).isReplicaSync()));
        Assertions.assertTrue((boolean)primaryServer.isReplicaSync());
        backupServer.stop();
        TimeUnit.SECONDS.sleep(1L);
        String coordinatedId = primaryServer.getNodeID().toString();
        primaryServer.stop();
        DistributedLockManager distributedLockManager = DistributedLockManager.newInstanceOf((String)this.managerConfiguration.getClassName(), (Map)this.managerConfiguration.getProperties());
        distributedLockManager.start();
        DistributedLock lock = distributedLockManager.getDistributedLock(coordinatedId);
        Assertions.assertTrue((boolean)lock.tryLock());
        final CountDownLatch preActivate = new CountDownLatch(1);
        backupServer.registerActivateCallback(new ActivateCallback(){

            public void preActivate() {
                super.preActivate();
                preActivate.countDown();
            }
        });
        backupServer.start();
        Assertions.assertTrue((boolean)preActivate.await(1L, TimeUnit.SECONDS));
        distributedLockManager.stop();
        primaryServer.start();
        org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)primaryServer).isStarted());
        Assertions.assertTrue((boolean)org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)backupServer).isReplicaSync()));
        Assertions.assertTrue((boolean)primaryServer.isReplicaSync());
    }

    @Test
    public void testSelfRepairPrimary() throws Exception {
        Configuration primaryConfiguration = this.createPrimaryConfiguration();
        ActiveMQServer primaryServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)primaryConfiguration));
        primaryServer.setIdentity("PRIMARY");
        primaryServer.start();
        String coordinatedId = primaryServer.getNodeID().toString();
        org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)primaryServer).isStarted());
        primaryServer.stop();
        primaryServer.start();
        org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)primaryServer).isStarted());
        Assertions.assertEquals((long)2L, (long)primaryServer.getNodeManager().getNodeActivationSequence());
        primaryServer.stop();
        DistributedLockManager distributedLockManager = DistributedLockManager.newInstanceOf((String)this.managerConfiguration.getClassName(), (Map)this.managerConfiguration.getProperties());
        distributedLockManager.start();
        try (DistributedLock lock = distributedLockManager.getDistributedLock(coordinatedId);){
            Assertions.assertTrue((boolean)lock.tryLock());
            distributedLockManager.getMutableLong(coordinatedId).compareAndSet(2L, -2L);
        }
        primaryServer.start();
        org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)primaryServer).isStarted());
        Assertions.assertEquals((long)3L, (long)primaryServer.getNodeManager().getNodeActivationSequence());
        Assertions.assertEquals((long)3L, (long)distributedLockManager.getMutableLong(coordinatedId).get());
        distributedLockManager.stop();
        Configuration backupConfiguration = this.createBackupConfiguration();
        ActiveMQServer backupServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)backupConfiguration));
        backupServer.setIdentity("BACKUP");
        backupServer.start();
        org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)backupServer).isReplicaSync());
        Assertions.assertEquals((long)3L, (long)backupServer.getNodeManager().getNodeActivationSequence());
        backupServer.stop();
    }

    @Test
    public void testPrimaryPeers() throws Exception {
        String PEER_NODE_ID = "some-shared-id-001";
        Configuration primaryConfiguration = this.createPrimaryConfiguration();
        ((ReplicationPrimaryPolicyConfiguration)primaryConfiguration.getHAPolicyConfiguration()).setCoordinationId("some-shared-id-001");
        ActiveMQServer primaryServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)primaryConfiguration));
        primaryServer.setIdentity("PRIMARY");
        primaryServer.start();
        org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)primaryServer).isStarted());
        ServerLocator locator = ServerLocatorImpl.newLocator((String)"(tcp://localhost:61616,tcp://localhost:61617)?ha=true");
        locator.setCallTimeout(60000L);
        locator.setConnectionTTL(60000L);
        ClientSessionFactory keepLocatorAliveSLF = locator.createSessionFactory();
        ClientSessionFactory csf = locator.createSessionFactory();
        this.sendTo(csf, "primary_un_replicated");
        csf.close();
        Configuration primaryPeerConfiguration = this.createBackupConfiguration();
        primaryPeerConfiguration.setHAPolicyConfiguration(this.createReplicationPrimaryConfiguration());
        ((ReplicationPrimaryPolicyConfiguration)primaryPeerConfiguration.getHAPolicyConfiguration()).setCoordinationId("some-shared-id-001");
        primaryPeerConfiguration.setName("localhost::primary-peer");
        ActiveMQServer primaryPeerServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)primaryPeerConfiguration));
        primaryPeerServer.setIdentity("PRIMARY-PEER");
        primaryPeerServer.start();
        org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)primaryPeerServer).isStarted());
        LockManagerReplicationTest.waitForTopology(primaryServer, 1, 1, 30000L);
        LockManagerReplicationTest.waitForTopology(primaryPeerServer, 1, 1, 30000L);
        primaryServer.stop();
        csf = locator.createSessionFactory();
        this.receiveFrom(csf, "primary_un_replicated");
        this.sendTo(csf, "peer_un_replicated");
        csf.close();
        LockManagerReplicationTest.waitForTopology(primaryPeerServer, 1, 0, 30000L);
        Assertions.assertTrue((boolean)org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> 2L == primaryPeerServer.getNodeManager().getNodeActivationSequence()));
        primaryPeerServer.stop(false);
        primaryServer.start();
        org.apache.activemq.artemis.tests.util.Wait.assertTrue(() -> !primaryServer.isActive());
        primaryPeerServer.start();
        org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)primaryPeerServer).isStarted());
        Assertions.assertEquals((long)3L, (long)primaryPeerServer.getNodeManager().getNodeActivationSequence());
        csf = locator.createSessionFactory();
        this.receiveFrom(csf, "peer_un_replicated");
        this.sendTo(csf, "backup_as_un_replicated");
        csf.close();
        primaryServer.start();
        csf = locator.createSessionFactory();
        this.receiveFrom(csf, "backup_as_un_replicated");
        this.sendTo(csf, "backup_as_replicated");
        csf.close();
        Assertions.assertTrue((boolean)org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)primaryServer).isReplicaSync()));
        Assertions.assertTrue((boolean)org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> 3L == primaryServer.getNodeManager().getNodeActivationSequence()));
        LockManagerReplicationTest.waitForTopology(primaryServer, 1, 1, 30000L);
        LockManagerReplicationTest.waitForTopology(primaryPeerServer, 1, 1, 30000L);
        primaryPeerServer.stop(true);
        Assertions.assertTrue((boolean)org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> 4L == primaryServer.getNodeManager().getNodeActivationSequence()));
        csf = locator.createSessionFactory();
        this.receiveFrom(csf, "backup_as_replicated");
        csf.close();
        LockManagerReplicationTest.waitForTopology(primaryServer, 1, 0, 30000L);
        primaryServer.stop(true);
        keepLocatorAliveSLF.close();
        locator.close();
    }

    @Test
    public void testUnavailableSelfHeal() throws Exception {
        Configuration backupConfiguration = this.createBackupConfiguration();
        ActiveMQServer backupServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)backupConfiguration));
        backupServer.setIdentity("BACKUP");
        backupServer.start();
        Configuration primaryConfiguration = this.createPrimaryConfiguration();
        ActiveMQServer primaryServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)primaryConfiguration));
        primaryServer.setIdentity("PRIMARY");
        primaryServer.start();
        org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)primaryServer).isStarted());
        Assertions.assertTrue((boolean)org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)backupServer).isStarted()));
        Assertions.assertTrue((boolean)org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)backupServer).isReplicaSync()));
        Assertions.assertTrue((boolean)primaryServer.isReplicaSync());
        String coordinatedId = primaryServer.getNodeID().toString();
        backupServer.stop();
        TimeUnit.MILLISECONDS.sleep(500L);
        primaryServer.stop();
        DistributedLockManager distributedLockManager = DistributedLockManager.newInstanceOf((String)this.managerConfiguration.getClassName(), (Map)this.managerConfiguration.getProperties());
        distributedLockManager.start();
        MutableLong activationSequence = distributedLockManager.getMutableLong(coordinatedId);
        Assertions.assertTrue((boolean)activationSequence.compareAndSet(2L, -2L));
        primaryServer.start();
        org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)primaryServer).isStarted());
        Assertions.assertEquals((long)3L, (long)primaryServer.getNodeManager().getNodeActivationSequence());
        Assertions.assertEquals((long)3L, (long)activationSequence.get());
    }

    @Test
    public void testUnavailableAutoRepair() throws Exception {
        Configuration backupConfiguration = this.createBackupConfiguration();
        ActiveMQServer backupServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)backupConfiguration));
        backupServer.setIdentity("BACKUP");
        backupServer.start();
        Configuration primaryConfiguration = this.createPrimaryConfiguration();
        ActiveMQServer primaryServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)primaryConfiguration));
        primaryServer.setIdentity("PRIMARY");
        primaryServer.start();
        org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)primaryServer).isStarted());
        Assertions.assertTrue((boolean)org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)backupServer).isStarted()));
        Assertions.assertTrue((boolean)org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)backupServer).isReplicaSync()));
        Assertions.assertTrue((boolean)primaryServer.isReplicaSync());
        String coordinatedId = primaryServer.getNodeID().toString();
        backupServer.stop();
        TimeUnit.MILLISECONDS.sleep(500L);
        primaryServer.stop();
        DistributedLockManager distributedLockManager = DistributedLockManager.newInstanceOf((String)this.managerConfiguration.getClassName(), (Map)this.managerConfiguration.getProperties());
        distributedLockManager.start();
        MutableLong coordinatedActivationSequence = distributedLockManager.getMutableLong(coordinatedId);
        Assertions.assertTrue((boolean)coordinatedActivationSequence.compareAndSet(2L, -2L));
        FileLockNodeManager fileLockNodeManager = new FileLockNodeManager(primaryConfiguration.getNodeManagerLockLocation().getAbsoluteFile(), true);
        fileLockNodeManager.start();
        Assertions.assertEquals((long)2L, (long)fileLockNodeManager.readNodeActivationSequence());
        fileLockNodeManager.writeNodeActivationSequence(1L);
        fileLockNodeManager.stop();
        backupServer.start();
        CountDownLatch primaryStarting = new CountDownLatch(1);
        Thread primaryServerStarterThread = new Thread(() -> {
            primaryStarting.countDown();
            try {
                primaryServer.start();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        });
        primaryServerStarterThread.start();
        primaryStarting.await();
        TimeUnit.MILLISECONDS.sleep(500L);
        org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> primaryServer.isStarted() || backupServer.isStarted());
        Assertions.assertTrue((boolean)org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)backupServer).isReplicaSync()));
        Assertions.assertTrue((boolean)primaryServer.isReplicaSync());
        Assertions.assertEquals((long)3L, (long)backupServer.getNodeManager().getNodeActivationSequence());
        Assertions.assertEquals((long)3L, (long)primaryServer.getNodeManager().getNodeActivationSequence());
    }

    private void sendTo(ClientSessionFactory clientSessionFactory, String addr) throws Exception {
        ClientSession clientSession = clientSessionFactory.createSession(true, true);
        clientSession.createQueue(QueueConfiguration.of((String)addr).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(true)));
        ClientProducer producer = clientSession.createProducer(addr);
        ClientMessage message = clientSession.createMessage(true);
        message.putStringProperty("K", addr);
        message.putLongProperty("delay", 0L);
        producer.send((Message)message);
        producer.close();
        clientSession.close();
    }

    private void receiveFrom(ClientSessionFactory clientSessionFactory, String addr) throws Exception {
        ClientSession clientSession = clientSessionFactory.createSession(true, true);
        clientSession.start();
        ClientConsumer consumer = clientSession.createConsumer(addr);
        ClientMessage message = consumer.receive(4000L);
        Assertions.assertNotNull((Object)message);
        Assertions.assertTrue((boolean)message.getStringProperty("K").equals(addr));
        consumer.close();
        clientSession.close();
    }

    private static File newFolder(File root, String ... subDirs) throws IOException {
        String subFolder = String.join((CharSequence)"/", subDirs);
        File result = new File(root, subFolder);
        if (!result.mkdirs()) {
            throw new IOException("Couldn't create folders " + root);
        }
        return result;
    }
}

