/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.security;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSSecurityException;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import java.util.Set;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.RoleSet;
import org.apache.activemq.artemis.core.config.impl.SecurityConfiguration;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.spi.core.security.jaas.InVMLoginModule;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.apache.activemq.artemis.utils.CompositeAddress;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FQQNSendSecurityTest
extends ActiveMQTestBase {
    private final String ALLOWED_USER = "allowedUser";
    private final String ALLOWED_ROLE = "allowedRole";
    private final String DENIED_USER = "deniedUser";
    private final String DENIED_ROLE = "deniedRole";
    private final String PASS = RandomUtil.randomString();
    private final String ADDRESS = "myAddress";
    private final String QUEUE = "myQueue";

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        Configuration configuration = this.createDefaultInVMConfig().setSecurityEnabled(true);
        RoleSet roles = new RoleSet();
        roles.add((Object)new Role("allowedRole", true, false, false, false, false, false, false, false, false, false, false, false));
        roles.add((Object)new Role("deniedRole", false, false, false, false, false, false, false, false, false, false, false, false));
        configuration.putSecurityRoles(CompositeAddress.toFullyQualified((String)"myAddress", (String)"myQueue"), (Set)roles);
        ActiveMQServer server = this.createServer(false, configuration);
        ActiveMQJAASSecurityManager securityManager = new ActiveMQJAASSecurityManager(InVMLoginModule.class.getName());
        SecurityConfiguration securityConfiguration = new SecurityConfiguration();
        securityConfiguration.addUser("allowedUser", this.PASS);
        securityConfiguration.addRole("allowedUser", "allowedRole");
        securityConfiguration.addUser("deniedUser", this.PASS);
        securityConfiguration.addRole("deniedUser", "deniedRole");
        securityManager.setConfiguration(securityConfiguration);
        server.setSecurityManager((ActiveMQSecurityManager)securityManager);
        configuration.addQueueConfiguration(QueueConfiguration.of((String)"myQueue").setAddress("myAddress").setRoutingType(RoutingType.ANYCAST));
        server.start();
    }

    @Test
    public void sendMessageToFQQN() throws Exception {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("vm://0");
        try (Connection connection = connectionFactory.createConnection("allowedUser", this.PASS);){
            Session session = connection.createSession(false, 1);
            Queue destination = session.createQueue(CompositeAddress.toFullyQualified((String)"myAddress", (String)"myQueue"));
            MessageProducer messageProducer = session.createProducer((Destination)destination);
            messageProducer.send(session.createMessage());
        }
    }

    @Test
    public void sendMessageToFQQNNegative() throws Exception {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("vm://0");
        try (Connection connection = connectionFactory.createConnection("deniedUser", this.PASS);){
            Session session = connection.createSession(false, 1);
            Queue destination = session.createQueue(CompositeAddress.toFullyQualified((String)"myAddress", (String)"myQueue"));
            MessageProducer messageProducer = session.createProducer((Destination)destination);
            try {
                messageProducer.send(session.createMessage());
                Assertions.fail();
            }
            catch (JMSSecurityException jMSSecurityException) {
                // empty catch block
            }
        }
    }
}

