/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.security;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.JMSException;
import java.lang.invoke.MethodHandles;
import java.lang.management.ManagementFactory;
import java.security.Principal;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.security.auth.Subject;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnection;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager5;
import org.apache.activemq.artemis.spi.core.security.jaas.NoCacheLoginException;
import org.apache.activemq.artemis.spi.core.security.jaas.UserPrincipal;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecursiveNettySecurityTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String addressA = "addressA";
    private static final String queueA = "queueA";

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
    }

    @Test
    public void testRecursiveSecurity() throws Exception {
        RecursiveNettySecurityManager securityManager = new RecursiveNettySecurityManager();
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultNettyConfig().setSecurityEnabled(true), (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)securityManager, (boolean)false));
        server.start();
        ConnectionFactory connectionFactory = CFUtil.createConnectionFactory("CORE", "tcp://localhost:61616");
        try {
            Connection connection = connectionFactory.createConnection("first", "secret");
            connection.close();
        }
        catch (JMSException e) {
            e.printStackTrace();
            Assertions.fail((String)"should not throw exception");
        }
    }

    class RecursiveNettySecurityManager
    implements ActiveMQSecurityManager5 {
        RecursiveNettySecurityManager() {
        }

        public boolean validateUser(String user, String password) {
            return false;
        }

        public boolean validateUserAndRole(String user, String password, Set<Role> roles, CheckType checkType) {
            return false;
        }

        public Subject authenticate(String user, String password, RemotingConnection remotingConnection, String securityDomain) throws NoCacheLoginException {
            NettyConnection nettyConnection = (NettyConnection)remotingConnection.getTransportConnection();
            CountDownLatch latch = new CountDownLatch(1);
            nettyConnection.getChannel().eventLoop().execute(latch::countDown);
            try {
                if (!latch.await(10L, TimeUnit.SECONDS)) {
                    logger.warn("Cannot complete oepration in time", (Throwable)new Exception("timeout"));
                    throw new NoCacheLoginException("Can't complete operation in time");
                }
            }
            catch (InterruptedException e) {
                logger.warn(e.getMessage(), (Throwable)e);
                throw new NoCacheLoginException(e.getMessage());
            }
            Subject authenticatedSubject = new Subject();
            authenticatedSubject.getPrincipals().add((Principal)new UserPrincipal(user));
            return authenticatedSubject;
        }

        public boolean authorize(Subject subject, Set<Role> roles, CheckType checkType, String address) {
            return true;
        }
    }
}

