/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.server;

import java.lang.invoke.MethodHandles;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.ScaleDownConfiguration;
import org.apache.activemq.artemis.core.config.ha.PrimaryOnlyPolicyConfiguration;
import org.apache.activemq.artemis.core.postoffice.impl.LocalQueueBinding;
import org.apache.activemq.artemis.core.server.cluster.impl.ClusterConnectionImpl;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScaleDownRemoveSFTest
extends ClusterTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        ScaleDownConfiguration scaleDownConfiguration = new ScaleDownConfiguration();
        this.setupPrimaryServer(0, this.isFileStorage(), this.isNetty(), true);
        this.setupPrimaryServer(1, this.isFileStorage(), this.isNetty(), true);
        PrimaryOnlyPolicyConfiguration haPolicyConfiguration0 = (PrimaryOnlyPolicyConfiguration)this.servers[0].getConfiguration().getHAPolicyConfiguration();
        haPolicyConfiguration0.setScaleDownConfiguration(scaleDownConfiguration);
        PrimaryOnlyPolicyConfiguration haPolicyConfiguration1 = (PrimaryOnlyPolicyConfiguration)this.servers[1].getConfiguration().getHAPolicyConfiguration();
        haPolicyConfiguration1.setScaleDownConfiguration(new ScaleDownConfiguration());
        this.setupClusterConnection("cluster0", "testAddress", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1);
        this.setupClusterConnection("cluster0", "testAddress", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0);
        haPolicyConfiguration0.getScaleDownConfiguration().getConnectors().addAll(((ClusterConnectionConfiguration)this.servers[0].getConfiguration().getClusterConfigurations().iterator().next()).getStaticConnectors());
        haPolicyConfiguration1.getScaleDownConfiguration().getConnectors().addAll(((ClusterConnectionConfiguration)this.servers[1].getConfiguration().getClusterConfigurations().iterator().next()).getStaticConnectors());
        this.servers[0].getConfiguration().getAddressSettings().put("#", new AddressSettings().setRedistributionDelay(0L));
        this.servers[1].getConfiguration().getAddressSettings().put("#", new AddressSettings().setRedistributionDelay(0L));
        this.startServers(0, 1);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
    }

    protected boolean isNetty() {
        return true;
    }

    @Test
    public void testScaleDownCheckSF() throws Exception {
        int TEST_SIZE = 2;
        String addressName = "testAddress";
        String queueName1 = "testQueue1";
        this.createQueue(0, "testAddress", "testQueue1", null, true);
        this.createQueue(1, "testAddress", "testQueue1", null, true);
        this.send(0, "testAddress", 2, true, null);
        this.addConsumer(1, 0, "testQueue1", null, false);
        ClientMessage clientMessage = this.consumers[1].getConsumer().receive(5000L);
        Assertions.assertNotNull((Object)clientMessage);
        clientMessage.acknowledge();
        this.consumers[1].getSession().commit();
        Assertions.assertEquals((int)1, (int)this.getMessageCount(((LocalQueueBinding)this.servers[0].getPostOffice().getBinding(SimpleString.of((String)"testQueue1"))).getQueue()));
        ClusterConnectionImpl clusterconn1 = (ClusterConnectionImpl)this.servers[1].getClusterManager().getClusterConnection("cluster0");
        SimpleString sfQueueName = clusterconn1.getSfQueueName(this.servers[0].getNodeID().toString());
        logger.debug("[sf queue on server 1]: {}", (Object)sfQueueName);
        Assertions.assertTrue((boolean)this.servers[1].queueQuery(sfQueueName).isExists());
        this.servers[0].stop();
        this.addConsumer(0, 1, "testQueue1", null);
        clientMessage = this.consumers[0].getConsumer().receive(10000L);
        Assertions.assertNotNull((Object)clientMessage);
        clientMessage.acknowledge();
        clientMessage = this.consumers[0].getConsumer().receiveImmediate();
        Assertions.assertNull((Object)clientMessage);
        this.removeConsumer(0);
        Assertions.assertFalse((boolean)this.servers[1].queueQuery(sfQueueName).isExists());
        Assertions.assertFalse((boolean)this.servers[1].addressQuery(sfQueueName).isExists());
    }
}

