/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.stomp;

import jakarta.jms.Destination;
import jakarta.jms.MessageConsumer;
import jakarta.jms.TextMessage;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.integration.stomp.StompTestBase;
import org.apache.activemq.artemis.tests.integration.stomp.util.ClientStompFrame;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnection;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnectionFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class StompWithSecurityTest
extends StompTestBase {
    @Override
    public boolean isSecurityEnabled() {
        return true;
    }

    @TestTemplate
    public void testJMSXUserID() throws Exception {
        this.server.getConfiguration().setPopulateValidatedUser(true);
        MessageConsumer consumer = this.session.createConsumer((Destination)this.queue);
        StompClientConnection conn = StompClientConnectionFactory.createClientConnection(this.uri);
        conn.connect(this.defUser, this.defPass);
        ClientStompFrame frame = conn.createFrame("SEND");
        frame.addHeader("destination", StompWithSecurityTest.getQueuePrefix() + StompWithSecurityTest.getQueueName());
        frame.setBody("Hello World");
        conn.sendFrame(frame);
        conn.disconnect();
        TextMessage message = (TextMessage)consumer.receive(1000L);
        Assertions.assertNotNull((Object)message);
        Assertions.assertEquals((Object)"Hello World", (Object)message.getText());
        Assertions.assertEquals((int)4, (int)message.getJMSPriority(), (String)"getJMSPriority");
        Assertions.assertEquals((Object)"brianm", (Object)message.getStringProperty("JMSXUserID"), (String)"JMSXUserID");
        long tnow = System.currentTimeMillis();
        long tmsg = message.getJMSTimestamp();
        Assertions.assertTrue((Math.abs(tnow - tmsg) < 1000L ? (byte)1 : 0) != 0);
    }
}

