/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.journal.impl;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.aio.AIOSequentialFileFactory;
import org.apache.activemq.artemis.core.io.mapped.MappedSequentialFileFactory;
import org.apache.activemq.artemis.core.io.nio.NIOSequentialFileFactory;
import org.apache.activemq.artemis.core.journal.IOCompletion;
import org.apache.activemq.artemis.core.journal.Journal;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.impl.JournalImpl;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.nativo.jlibaio.LibaioContext;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.SimpleIDGenerator;
import org.apache.activemq.artemis.utils.actors.OrderedExecutorFactory;
import org.apache.activemq.artemis.utils.collections.ConcurrentHashSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchCommitTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int FILE_SIZE = 0xA00000;
    private static final int MIN_FILES = 10;
    private static final int POOL_SIZE = 10;
    private static final String FILE_PREFIX = "journal-test";
    private static final String FILE_EXTENSION = "amq";
    private static final int BUFFER_SIZE = 102400;
    private static final int BUFFER_TIMEOUT = 10240;
    private static final int MAX_AIO = 255;
    private static final int OK = 100;
    private static final int ERROR = 101;
    private static final int RECORDS = 10000;
    JournalImpl journal;
    SequentialFileFactory journalFF;
    SimpleIDGenerator idGenerator = new SimpleIDGenerator(1L);

    public Journal testRunNIO(String testFolder, boolean sync) throws Throwable {
        return this.testRun(testFolder, JournalType.NIO, sync);
    }

    public Journal testRunMapped(String testFolder, boolean sync) throws Throwable {
        return this.testRun(testFolder, JournalType.MAPPED, sync);
    }

    public Journal testRunAIO(String testFolder, boolean sync) throws Throwable {
        return this.testRun(testFolder, JournalType.ASYNCIO, sync);
    }

    public Journal testRun(String testFolder, JournalType journalType, boolean sync) throws Throwable {
        OrderedExecutorFactory orderedExecutorFactory = this.getExecutorFactory();
        this.setupJournal(journalType, testFolder, (ExecutorFactory)orderedExecutorFactory);
        this.journal.start();
        this.runAfter(() -> ((JournalImpl)this.journal).stop());
        this.journal.loadInternalOnly();
        final CountDownLatch latch = new CountDownLatch(10000);
        final ConcurrentHashSet existingRecords = new ConcurrentHashSet();
        final AtomicInteger errors = new AtomicInteger(0);
        for (int i = 0; i < 10000; ++i) {
            final long tx = this.idGenerator.generateID();
            long id = this.idGenerator.generateID();
            long upid = this.idGenerator.generateID();
            existingRecords.add((Object)tx);
            IOCompletion completion = new IOCompletion(){

                public void storeLineUp() {
                }

                public void done() {
                    if (!existingRecords.remove((Object)tx)) {
                        errors.incrementAndGet();
                        logger.warn("Id {} was removed before", (Object)tx);
                    }
                    latch.countDown();
                }

                public void onError(int errorCode, String errorMessage) {
                }
            };
            this.journal.appendAddRecordTransactional(tx, id, (byte)1, ("add " + id).getBytes());
            this.journal.appendUpdateRecordTransactional(tx, upid, (byte)1, ("up " + upid).getBytes());
            this.journal.appendCommitRecord(tx, sync, completion, true);
        }
        if (!latch.await(10L, TimeUnit.SECONDS)) {
            logger.warn("latch didn't finish, count={}", (Object)latch.getCount());
            errors.incrementAndGet();
        }
        existingRecords.forEach(l -> logger.warn("id {} still in the list", l));
        Assertions.assertEquals((int)0, (int)errors.get());
        Assertions.assertEquals((int)0, (int)existingRecords.size());
        return this.journal;
    }

    private OrderedExecutorFactory getExecutorFactory() {
        ExecutorService service = Executors.newFixedThreadPool(10, new ThreadFactory(){
            int counter = 0;

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("AsyncCommitTest" + this.counter++);
                return t;
            }
        });
        OrderedExecutorFactory orderedExecutorFactory = new OrderedExecutorFactory((Executor)service);
        this.runAfter(service::shutdownNow);
        return orderedExecutorFactory;
    }

    @Test
    public void testNIO() throws Exception {
        this.internalTest(JournalType.NIO, "testRunNIO", true);
    }

    @Test
    public void testNIONoSync() throws Exception {
        this.internalTest(JournalType.NIO, "testRunNIO", false);
    }

    @Disabled
    public void testMapped() throws Exception {
        this.internalTest(JournalType.MAPPED, "testRunMapped", true);
    }

    @Test
    public void testMappedNoSync() throws Exception {
        this.internalTest(JournalType.MAPPED, "testRunMapped", false);
    }

    @Test
    public void testAIO() throws Exception {
        Assumptions.assumeTrue((boolean)LibaioContext.isLoaded());
        this.internalTest(JournalType.ASYNCIO, "testRunAIO", true);
    }

    @Test
    public void testAIONoSync() throws Exception {
        Assumptions.assumeTrue((boolean)LibaioContext.isLoaded());
        this.internalTest(JournalType.ASYNCIO, "testRunAIO", false);
    }

    private void proceedCall(String testName, String testFolder, boolean sync) throws Exception {
        Method method = ((Object)((Object)this)).getClass().getMethod(testName, String.class, Boolean.TYPE);
        Journal journal = (Journal)method.invoke((Object)this, testFolder, sync);
        journal.stop();
    }

    private void internalTest(JournalType journalType, String testRunName, boolean sync) throws Exception {
        this.proceedCall(testRunName, this.getTestDir(), sync);
        OrderedExecutorFactory orderedExecutorFactory = this.getExecutorFactory();
        this.setupJournal(journalType, this.getTestDir(), (ExecutorFactory)orderedExecutorFactory);
        ArrayList<RecordInfo> commited = new ArrayList<RecordInfo>();
        ArrayList prepared = new ArrayList();
        AtomicInteger failedTX = new AtomicInteger(0);
        this.journal.start();
        this.journal.load(commited, prepared, (id, records, toDelete) -> failedTX.incrementAndGet(), false);
        this.runAfter(() -> ((JournalImpl)this.journal).stop());
        commited.forEach(r -> {
            String dataAsString = new String(r.data);
            logger.debug("data={}, isUpdate={}, id={}", new Object[]{dataAsString, r.isUpdate, r.id});
            if (r.isUpdate) {
                Assertions.assertEquals((Object)("up " + r.id), (Object)dataAsString);
            } else {
                Assertions.assertEquals((Object)("add " + r.id), (Object)dataAsString);
            }
        });
        Assertions.assertEquals((int)20000, (int)commited.size());
        Assertions.assertEquals((int)0, (int)failedTX.get());
    }

    public void setupJournal(JournalType journalType, String location, ExecutorFactory executorFactory) {
        File locationFile = new File(location);
        switch (journalType) {
            case NIO: {
                this.journalFF = new NIOSequentialFileFactory(locationFile, true, 102400, 10240, 1, true, null, null);
                break;
            }
            case ASYNCIO: {
                this.journalFF = new AIOSequentialFileFactory(locationFile, 102400, 10240, 255, true, null, null);
                break;
            }
            case MAPPED: {
                this.journalFF = new MappedSequentialFileFactory(locationFile, 0xA00000, true, 102400, 10240, null);
                break;
            }
            default: {
                throw new IllegalStateException("invalid journal type " + journalType);
            }
        }
        this.journal = new JournalImpl(executorFactory, 0xA00000, 10, 10, 0, 0, 30000, this.journalFF, FILE_PREFIX, FILE_EXTENSION, 255, 1, null, 10);
    }
}

