/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.journal.impl;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.core.io.DummyCallback;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.buffer.TimedBuffer;
import org.apache.activemq.artemis.core.io.buffer.TimedBufferObserver;
import org.apache.activemq.artemis.core.io.nio.NIOSequentialFile;
import org.apache.activemq.artemis.core.io.nio.NIOSequentialFileFactory;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.Env;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimedBufferTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int ONE_SECOND_IN_NANOS = 1000000000;
    IOCallback dummyCallback = new IOCallback(){

        public void done() {
        }

        public void onError(int errorCode, String errorMessage) {
        }
    };
    private static final EncodingSupport LONG_ENCODER = new EncodingSupport(){

        public int getEncodeSize() {
            return 8;
        }

        public void encode(ActiveMQBuffer buffer) {
            buffer.writeLong(1L);
        }

        public void decode(ActiveMQBuffer buffer) {
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFillBuffer() {
        final ArrayList buffers = new ArrayList();
        final AtomicInteger flushTimes = new AtomicInteger(0);
        TimedBuffer timedBuffer = new TimedBuffer(null, 100, 1000000000, false);
        timedBuffer.start();
        try {
            class TestObserver
            implements TimedBufferObserver {
                TestObserver() {
                }

                public void flushBuffer(ByteBuf byteBuf, boolean sync, List<IOCallback> callbacks) {
                    ByteBuffer buffer = ByteBuffer.allocate(byteBuf.readableBytes());
                    buffer.limit(byteBuf.readableBytes());
                    byteBuf.getBytes(byteBuf.readerIndex(), buffer);
                    buffer.flip();
                    buffers.add(buffer);
                    flushTimes.incrementAndGet();
                }

                public int getRemainingBytes() {
                    return 0x100000;
                }
            }
            timedBuffer.setObserver((TimedBufferObserver)new TestObserver());
            int x = 0;
            for (int i = 0; i < 10; ++i) {
                byte[] bytes = new byte[10];
                for (int j = 0; j < 10; ++j) {
                    bytes[j] = ActiveMQTestBase.getSamplebyte(x++);
                }
                ActiveMQBuffer buff = ActiveMQBuffers.wrappedBuffer((byte[])bytes);
                timedBuffer.checkSize(10);
                timedBuffer.addBytes(buff, false, this.dummyCallback);
            }
            timedBuffer.checkSize(1);
            Assertions.assertEquals((int)1, (int)flushTimes.get());
            ByteBuffer flushedBuffer = (ByteBuffer)buffers.get(0);
            Assertions.assertEquals((int)100, (int)flushedBuffer.limit());
            Assertions.assertEquals((int)100, (int)flushedBuffer.capacity());
            flushedBuffer.rewind();
            for (int i = 0; i < 100; ++i) {
                Assertions.assertEquals((byte)ActiveMQTestBase.getSamplebyte(i), (byte)flushedBuffer.get());
            }
        }
        finally {
            timedBuffer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimeOnTimedBuffer() throws Exception {
        final ReusableLatch latchFlushed = new ReusableLatch(0);
        AtomicInteger flushes = new AtomicInteger(0);
        TimedBuffer timedBuffer = new TimedBuffer(null, 100, 500000000, false);
        timedBuffer.start();
        class TestObserver
        implements TimedBufferObserver {
            TestObserver() {
            }

            public void flushBuffer(ByteBuf byteBuf, boolean sync, List<IOCallback> callbacks) {
                ByteBuffer buffer = ByteBuffer.allocate(byteBuf.readableBytes());
                buffer.limit(byteBuf.readableBytes());
                byteBuf.getBytes(byteBuf.readerIndex(), buffer);
                for (IOCallback callback : callbacks) {
                    callback.done();
                }
            }

            public int getRemainingBytes() {
                return 0x100000;
            }
        }
        TestObserver observer = new TestObserver();
        timedBuffer.setObserver((TimedBufferObserver)observer);
        int x = 0;
        byte[] bytes = new byte[10];
        for (int j = 0; j < 10; ++j) {
            bytes[j] = ActiveMQTestBase.getSamplebyte(x++);
        }
        ActiveMQBuffer buff = ActiveMQBuffers.wrappedBuffer((byte[])bytes);
        IOCallback callback = new IOCallback(){

            public void done() {
                logger.debug("done");
                latchFlushed.countDown();
            }

            public void onError(int errorCode, String errorMessage) {
            }
        };
        try {
            latchFlushed.setCount(2);
            timedBuffer.addBytes(buff, true, callback);
            Thread.sleep(100L);
            timedBuffer.addBytes(buff, true, callback);
            Assertions.assertTrue((boolean)latchFlushed.await(5L, TimeUnit.SECONDS));
            latchFlushed.setCount(5);
            flushes.set(0);
            long time = System.currentTimeMillis();
            for (int i = 0; i < 5; ++i) {
                timedBuffer.addBytes(buff, true, callback);
                Thread.sleep(1L);
            }
            Assertions.assertTrue((boolean)latchFlushed.await(5L, TimeUnit.SECONDS));
            Assertions.assertTrue((System.currentTimeMillis() - time >= 450L ? (byte)1 : 0) != 0, (String)("Timed Buffer is not batching accordingly, it was expected to take at least 500 seconds batching multiple writes while it took " + (System.currentTimeMillis() - time) + " milliseconds"));
            Assertions.assertTrue((flushes.get() <= 3 ? (byte)1 : 0) != 0, (String)"Too many writes were called");
        }
        finally {
            timedBuffer.stop();
        }
    }

    @Test
    public void testSyncOnNIOClosed() throws Exception {
        TimedBuffer timedBuffer = new TimedBuffer(null, 100, 1, false);
        timedBuffer.start();
        this.runAfterEx(() -> ((TimedBuffer)timedBuffer).stop());
        NIOSequentialFileFactory factory = new NIOSequentialFileFactory(this.getTestDirfile(), 1){

            public SequentialFile createSequentialFile(String fileName) {
                return new NIOSequentialFile((SequentialFileFactory)this, this.journalDir, fileName, this.maxIO, this.writeExecutor){

                    protected void syncChannel(FileChannel channel) throws IOException {
                        try {
                            this.close(true, true);
                        }
                        catch (Throwable e) {
                            logger.warn(e.getMessage(), e);
                        }
                        super.syncChannel(channel);
                    }
                };
            }
        };
        Assertions.assertTrue((boolean)factory.isDatasync());
        final AtomicInteger errors = new AtomicInteger(0);
        int x = 0;
        byte[] bytes = new byte[10];
        for (int j = 0; j < 10; ++j) {
            bytes[j] = ActiveMQTestBase.getSamplebyte(x++);
        }
        ActiveMQBuffer buff = ActiveMQBuffers.wrappedBuffer((byte[])bytes);
        final ReusableLatch done = new ReusableLatch(1);
        IOCallback callback = new IOCallback(){

            public void done() {
                done.countDown();
            }

            public void onError(int errorCode, String errorMessage) {
                logger.warn("error= {} / {}", (Object)errorCode, (Object)errorMessage);
                errors.incrementAndGet();
            }
        };
        try {
            for (int i = 0; i < 100; ++i) {
                if (i % 10 == 0) {
                    logger.info("i {}", (Object)i);
                }
                done.setCount(1);
                SequentialFile closeOnSyncFile = factory.createSequentialFile("test.txt", 1);
                closeOnSyncFile.open(100, false);
                closeOnSyncFile.position(0L);
                closeOnSyncFile.setTimedBuffer(timedBuffer);
                timedBuffer.addBytes(buff, true, callback);
                Assertions.assertTrue((boolean)done.await(1L, TimeUnit.MINUTES));
                Assertions.assertEquals((int)0, (int)errors.get());
                closeOnSyncFile.close(true, true);
            }
        }
        catch (Throwable e) {
            logger.warn(e.getMessage(), e);
            throw e;
        }
    }

    private static void spinSleep(long timeout) {
        if (timeout > 0L) {
            long deadline = System.nanoTime() + timeout;
            while (System.nanoTime() - deadline < 0L) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void timeoutShouldMatchFlushIOPSWithNotBlockingFlush() {
        long timeout = TimeUnit.MILLISECONDS.toNanos(100L);
        Assertions.assertTrue((timeout > 0L ? (byte)1 : 0) != 0);
        long deviceTime = timeout;
        int bufferSize = Env.osPageSize();
        TimedBuffer timedBuffer = new TimedBuffer(null, bufferSize, (int)timeout, false);
        timedBuffer.start();
        try (NonBlockingObserver observer = new NonBlockingObserver(bufferSize, deviceTime);){
            timedBuffer.setObserver((TimedBufferObserver)observer);
            timedBuffer.addBytes(LONG_ENCODER, true, (IOCallback)DummyCallback.getInstance());
            observer.waitUntilFlushIsDone(1L);
            Assertions.assertEquals((long)1L, (long)observer.flushesDone());
            timedBuffer.addBytes(LONG_ENCODER, true, (IOCallback)DummyCallback.getInstance());
            long endOfWriteRequest = System.nanoTime();
            observer.waitUntilFlushIsDone(2L);
            long flushDone = System.nanoTime();
            long elapsedTime = flushDone - endOfWriteRequest;
            Assertions.assertEquals((long)2L, (long)observer.flushesDone());
            logger.debug("elapsed time: {} with timeout: {}", (Object)elapsedTime, (Object)timeout);
            long maxExpected = timeout + deviceTime;
            Assertions.assertTrue((elapsedTime <= maxExpected ? (byte)1 : 0) != 0, (String)("elapsed = " + elapsedTime + " max expected = " + maxExpected));
        }
        finally {
            timedBuffer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void timeoutShouldMatchFlushIOPSWithBlockingFlush() {
        long timeout = TimeUnit.MILLISECONDS.toNanos(100L);
        Assertions.assertTrue((timeout > 0L ? (byte)1 : 0) != 0);
        long deviceTime = timeout;
        int bufferSize = Env.osPageSize();
        TimedBuffer timedBuffer = new TimedBuffer(null, bufferSize, (int)timeout, false);
        timedBuffer.start();
        try (BlockingObserver observer = new BlockingObserver(bufferSize, deviceTime);){
            timedBuffer.setObserver((TimedBufferObserver)observer);
            timedBuffer.addBytes(LONG_ENCODER, true, (IOCallback)DummyCallback.getInstance());
            observer.waitUntilFlushIsDone(1L);
            Assertions.assertEquals((long)1L, (long)observer.flushesDone());
            timedBuffer.addBytes(LONG_ENCODER, true, (IOCallback)DummyCallback.getInstance());
            long endOfWriteRequest = System.nanoTime();
            observer.waitUntilFlushIsDone(2L);
            long flushDone = System.nanoTime();
            long elapsedTime = flushDone - endOfWriteRequest;
            Assertions.assertEquals((long)2L, (long)observer.flushesDone());
            logger.debug("elapsed time: {} with timeout: {}", (Object)elapsedTime, (Object)timeout);
            long maxExpected = timeout + deviceTime;
            Assertions.assertTrue((elapsedTime <= maxExpected ? (byte)1 : 0) != 0, (String)("elapsed = " + elapsedTime + " max expected = " + maxExpected));
        }
        finally {
            timedBuffer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimingAndFlush() throws Exception {
        final ArrayList buffers = new ArrayList();
        final AtomicInteger flushTimes = new AtomicInteger(0);
        TimedBuffer timedBuffer = new TimedBuffer(null, 100, 100000000, false);
        timedBuffer.start();
        try {
            ActiveMQBuffer buff;
            int j;
            byte[] bytes;
            class TestObserver
            implements TimedBufferObserver {
                TestObserver() {
                }

                public void flushBuffer(ByteBuf byteBuf, boolean sync, List<IOCallback> callbacks) {
                    ByteBuffer buffer = ByteBuffer.allocate(byteBuf.readableBytes());
                    buffer.limit(byteBuf.readableBytes());
                    byteBuf.getBytes(byteBuf.readerIndex(), buffer);
                    buffer.flip();
                    buffers.add(buffer);
                    flushTimes.incrementAndGet();
                }

                public int getRemainingBytes() {
                    return 0x100000;
                }
            }
            timedBuffer.setObserver((TimedBufferObserver)new TestObserver());
            int x = 0;
            for (int i = 0; i < 3; ++i) {
                bytes = new byte[10];
                for (j = 0; j < 10; ++j) {
                    bytes[j] = ActiveMQTestBase.getSamplebyte(x++);
                }
                buff = ActiveMQBuffers.wrappedBuffer((byte[])bytes);
                timedBuffer.checkSize(10);
                timedBuffer.addBytes(buff, false, this.dummyCallback);
            }
            Thread.sleep(200L);
            int count = flushTimes.get();
            Assertions.assertTrue((count < 3 ? (byte)1 : 0) != 0);
            bytes = new byte[10];
            for (j = 0; j < 10; ++j) {
                bytes[j] = ActiveMQTestBase.getSamplebyte(x++);
            }
            buff = ActiveMQBuffers.wrappedBuffer((byte[])bytes);
            timedBuffer.checkSize(10);
            timedBuffer.addBytes(buff, false, this.dummyCallback);
            Wait.assertEquals((int)(count + 1), () -> flushTimes.get(), (long)2000L);
            bytes = new byte[10];
            for (j = 0; j < 10; ++j) {
                bytes[j] = ActiveMQTestBase.getSamplebyte(x++);
            }
            buff = ActiveMQBuffers.wrappedBuffer((byte[])bytes);
            timedBuffer.checkSize(10);
            timedBuffer.addBytes(buff, true, this.dummyCallback);
            Thread.sleep(500L);
            Assertions.assertEquals((int)(count + 2), (int)flushTimes.get());
            ByteBuffer flushedBuffer = (ByteBuffer)buffers.get(0);
            Assertions.assertEquals((int)30, (int)flushedBuffer.limit());
            Assertions.assertEquals((int)30, (int)flushedBuffer.capacity());
            flushedBuffer.rewind();
            for (int i = 0; i < 30; ++i) {
                Assertions.assertEquals((byte)ActiveMQTestBase.getSamplebyte(i), (byte)flushedBuffer.get());
            }
        }
        finally {
            timedBuffer.stop();
        }
    }

    private static final class NonBlockingObserver
    implements TimedBufferObserver,
    AutoCloseable {
        private long flushes = 0L;
        private final ByteBuffer dummyBuffer;
        private final Thread asyncIOWriter;
        private final AtomicLong flushRequest = new AtomicLong(0L);
        private final AtomicLong flushesDone = new AtomicLong(0L);

        private NonBlockingObserver(int bufferSize, long deviceTime) {
            this.asyncIOWriter = new Thread(() -> {
                long flushes = 0L;
                while (!Thread.interrupted()) {
                    if (this.flushRequest.get() <= flushes) continue;
                    long flushesToBePerformed = this.flushRequest.get() - flushes;
                    int i = 0;
                    while ((long)i < flushesToBePerformed) {
                        TimedBufferTest.spinSleep(deviceTime);
                        this.flushesDone.lazySet(++flushes);
                        ++i;
                    }
                }
            });
            this.dummyBuffer = ByteBuffer.allocate(bufferSize);
            this.asyncIOWriter.start();
        }

        public void flushBuffer(ByteBuf byteBuf, boolean sync, List<IOCallback> callbacks) {
            assert (sync);
            this.dummyBuffer.limit(byteBuf.readableBytes());
            byteBuf.getBytes(byteBuf.readerIndex(), this.dummyBuffer);
            if (this.dummyBuffer.position() > 0) {
                this.dummyBuffer.clear();
                ++this.flushes;
                this.flushRequest.lazySet(this.flushes);
            }
        }

        public int getRemainingBytes() {
            return Integer.MAX_VALUE;
        }

        @Override
        public void close() {
            this.asyncIOWriter.interrupt();
        }

        public void waitUntilFlushIsDone(long flush) {
            while (this.flushesDone.get() < flush) {
            }
        }

        public long flushesDone() {
            return this.flushesDone.get();
        }
    }

    private static final class BlockingObserver
    implements TimedBufferObserver,
    AutoCloseable {
        private long flushes = 0L;
        private final ByteBuffer dummyBuffer;
        private final long deviceTime;
        private final AtomicLong flushesDone = new AtomicLong(0L);

        private BlockingObserver(int bufferSize, long deviceTime) {
            this.dummyBuffer = ByteBuffer.allocate(bufferSize);
            this.deviceTime = deviceTime;
        }

        public void flushBuffer(ByteBuf byteBuf, boolean sync, List<IOCallback> callbacks) {
            assert (sync);
            this.dummyBuffer.limit(byteBuf.readableBytes());
            byteBuf.getBytes(byteBuf.readerIndex(), this.dummyBuffer);
            if (this.dummyBuffer.position() > 0) {
                this.dummyBuffer.clear();
                TimedBufferTest.spinSleep(this.deviceTime);
                ++this.flushes;
                this.flushesDone.lazySet(this.flushes);
            }
        }

        public int getRemainingBytes() {
            return Integer.MAX_VALUE;
        }

        @Override
        public void close() {
        }

        public void waitUntilFlushIsDone(long flush) {
            while (this.flushesDone.get() < flush) {
            }
        }

        public long flushesDone() {
            return this.flushesDone.get();
        }
    }
}

