/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.remoting.impl.netty;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyAcceptor;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManager;
import org.apache.activemq.artemis.spi.core.remoting.BufferHandler;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.spi.core.remoting.ServerConnectionLifeCycleListener;
import org.apache.activemq.artemis.tests.extensions.PortCheckExtension;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class NettyAcceptorTest
extends ActiveMQTestBase {
    private ScheduledExecutorService pool2;
    private ExecutorService pool3;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        if (this.pool3 != null) {
            this.pool3.shutdown();
        }
        if (this.pool2 != null) {
            this.pool2.shutdownNow();
        }
        super.tearDown();
    }

    @Test
    public void testStartStop() throws Exception {
        BufferHandler handler = (connectionID, buffer) -> {};
        HashMap params = new HashMap();
        ServerConnectionLifeCycleListener listener = new ServerConnectionLifeCycleListener(){

            public void connectionException(Object connectionID, ActiveMQException me) {
            }

            public void connectionDestroyed(Object connectionID, boolean failed) {
            }

            public void connectionCreated(ActiveMQComponent component, Connection connection, ProtocolManager protocol) {
            }

            public void connectionReadyForWrites(Object connectionID, boolean ready) {
            }
        };
        this.pool2 = Executors.newScheduledThreadPool(ActiveMQDefaultConfiguration.getDefaultScheduledThreadPoolMaxSize(), (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName()));
        this.pool3 = Executors.newSingleThreadExecutor((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName()));
        NettyAcceptor acceptor = new NettyAcceptor("netty", null, params, handler, listener, this.pool2, (Executor)this.pool3, new HashMap());
        this.addActiveMQComponent((ActiveMQComponent)acceptor);
        acceptor.start();
        Assertions.assertTrue((boolean)acceptor.isStarted());
        acceptor.stop();
        Assertions.assertFalse((boolean)acceptor.isStarted());
        Assertions.assertTrue((boolean)PortCheckExtension.checkAvailable((int)61616));
        acceptor.start();
        Assertions.assertTrue((boolean)acceptor.isStarted());
        acceptor.stop();
        Assertions.assertFalse((boolean)acceptor.isStarted());
        Assertions.assertTrue((boolean)PortCheckExtension.checkAvailable((int)61616));
    }

    @Test
    public void testAutoStart() throws Exception {
        ActiveMQServer server = this.createServer(false, this.createDefaultInVMConfig());
        server.getConfiguration().addAcceptorConfiguration("default", "tcp://127.0.0.1:61617");
        server.getConfiguration().addAcceptorConfiguration("start", "tcp://127.0.0.1:61618?autoStart=true");
        server.getConfiguration().addAcceptorConfiguration("noStart", "tcp://127.0.0.1:61619?autoStart=false");
        server.start();
        Assertions.assertTrue((boolean)server.getRemotingService().getAcceptor("default").isStarted());
        Assertions.assertTrue((boolean)server.getRemotingService().getAcceptor("start").isStarted());
        Assertions.assertFalse((boolean)server.getRemotingService().getAcceptor("noStart").isStarted());
    }

    @Test
    public void testActualPort() throws Exception {
        String firstPort0 = RandomUtil.randomString();
        String secondPort0 = RandomUtil.randomString();
        String normal = RandomUtil.randomString();
        String invm = RandomUtil.randomString();
        ActiveMQServer server = this.createServer(false, this.createDefaultInVMConfig());
        server.getConfiguration().addAcceptorConfiguration(firstPort0, "tcp://127.0.0.1:0");
        server.getConfiguration().addAcceptorConfiguration(secondPort0, "tcp://127.0.0.1:0");
        server.getConfiguration().addAcceptorConfiguration(normal, "tcp://127.0.0.1:61616");
        server.getConfiguration().addAcceptorConfiguration(invm, "vm://1");
        server.start();
        Wait.assertTrue(() -> server.getRemotingService().getAcceptor(firstPort0).getActualPort() > 0);
        Wait.assertTrue(() -> server.getRemotingService().getAcceptor(secondPort0).getActualPort() > 0);
        Wait.assertTrue(() -> server.getRemotingService().getAcceptor(firstPort0).getActualPort() != server.getRemotingService().getAcceptor(secondPort0).getActualPort());
        Wait.assertEquals((int)61616, () -> server.getRemotingService().getAcceptor(normal).getActualPort());
        Wait.assertEquals((int)-1, () -> server.getRemotingService().getAcceptor(invm).getActualPort());
    }

    @Test
    public void testInvalidSSLConfig() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sslEnabled", "true");
        try {
            new NettyAcceptor("netty", null, params, null, null, null, null, Map.of());
            Assertions.fail((String)"This should have failed with an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testValidSSLConfig1() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sslEnabled", "true");
        params.put("keyStoreProvider", RandomUtil.randomString());
        new NettyAcceptor("netty", null, params, null, null, null, null, Map.of());
    }

    @Test
    public void testValidSSLConfig2() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sslEnabled", "true");
        params.put("sslContext", RandomUtil.randomString());
        new NettyAcceptor("netty", null, params, null, null, null, null, Map.of());
    }
}

