/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.apache.activemq.artemis.tests.unit.util.deserialization.pkg1.EnclosingClass;
import org.apache.activemq.artemis.tests.unit.util.deserialization.pkg1.TestClass1;
import org.apache.activemq.artemis.tests.unit.util.deserialization.pkg1.TestClass2;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.ArtemisTestCase;
import org.apache.activemq.artemis.utils.ObjectInputStreamWithClassLoader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ObjectInputStreamWithClassLoaderTest
extends ActiveMQTestBase {
    public static ClassLoader newClassLoader(Class ... userClasses) throws Exception {
        HashSet<URL> userClassUrls = new HashSet<URL>();
        for (Class anyUserClass : userClasses) {
            ProtectionDomain protectionDomain = anyUserClass.getProtectionDomain();
            CodeSource codeSource = protectionDomain.getCodeSource();
            URL classLocation = codeSource.getLocation();
            userClassUrls.add(classLocation);
        }
        StringTokenizer tokenString = new StringTokenizer(System.getProperty("java.class.path"), File.pathSeparator);
        String pathIgnore = System.getProperty("java.home");
        if (pathIgnore == null) {
            pathIgnore = ((URL)userClassUrls.iterator().next()).toString();
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        while (tokenString.hasMoreElements()) {
            String value = tokenString.nextToken();
            URL itemLocation = new File(value).toURI().toURL();
            if (userClassUrls.contains(itemLocation) || itemLocation.toString().indexOf(pathIgnore) < 0) continue;
            urls.add(itemLocation);
        }
        URL[] urlArray = urls.toArray(new URL[urls.size()]);
        URLClassLoader mainClassLoader = URLClassLoader.newInstance(urlArray, null);
        URLClassLoader appClassLoader = URLClassLoader.newInstance(userClassUrls.toArray(new URL[0]), mainClassLoader);
        return appClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClassLoaderIsolation() throws Exception {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            AnObjectImpl obj = new AnObjectImpl();
            byte[] bytes = ObjectInputStreamWithClassLoaderTest.toBytes(obj);
            ClassLoader testClassLoader = ObjectInputStreamWithClassLoaderTest.newClassLoader(obj.getClass(), ActiveMQTestBase.class, ArtemisTestCase.class);
            Thread.currentThread().setContextClassLoader(testClassLoader);
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ObjectInputStreamWithClassLoader ois = new ObjectInputStreamWithClassLoader((InputStream)bais);
            Object deserializedObj = ois.readObject();
            Assertions.assertNotSame((Object)obj, (Object)deserializedObj);
            Assertions.assertNotSame(obj.getClass(), deserializedObj.getClass());
            Assertions.assertNotSame((Object)obj.getClass().getClassLoader(), (Object)deserializedObj.getClass().getClassLoader());
            Assertions.assertSame((Object)testClassLoader, (Object)deserializedObj.getClass().getClassLoader());
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClassLoaderIsolationWithProxy() throws Exception {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            AnObject originalProxy = (AnObject)Proxy.newProxyInstance(AnObject.class.getClassLoader(), new Class[]{AnObject.class}, (InvocationHandler)new AnObjectInvocationHandler());
            originalProxy.setMyInt(100);
            byte[] bytes = ObjectInputStreamWithClassLoaderTest.toBytes(originalProxy);
            ClassLoader testClassLoader = ObjectInputStreamWithClassLoaderTest.newClassLoader(((Object)((Object)this)).getClass(), ActiveMQTestBase.class, ArtemisTestCase.class);
            Thread.currentThread().setContextClassLoader(testClassLoader);
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ObjectInputStreamWithClassLoader ois = new ObjectInputStreamWithClassLoader((InputStream)bais);
            Runnable toRun = (Runnable)testClassLoader.loadClass(ProxyReader.class.getName()).newInstance();
            toRun.getClass().getField("ois").set(toRun, ois);
            toRun.getClass().getField("testClassLoader").set(toRun, testClassLoader);
            toRun.getClass().getField("originalProxy").set(toRun, originalProxy);
            toRun.run();
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    @Test
    public void testAllowDenyList() throws Exception {
        File serailizeFile = new File(this.temporaryFolder, "testclass.bin");
        try (ObjectOutputStream outputStream = new ObjectOutputStream(new FileOutputStream(serailizeFile));){
            outputStream.writeObject(new TestClass1());
            outputStream.flush();
        }
        Assertions.assertNull((Object)this.readSerializedObject(null, null, serailizeFile));
        String allowList = "org.apache.activemq.artemis.tests.unit.util.deserialization";
        Assertions.assertNull((Object)this.readSerializedObject(allowList, null, serailizeFile));
        allowList = "org.apache.activemq.artemis.tests.unit.util.deserialization.pkg1";
        Assertions.assertNull((Object)this.readSerializedObject(allowList, null, serailizeFile));
        allowList = "some.other.package";
        Exception result = this.readSerializedObject(allowList, null, serailizeFile);
        Assertions.assertTrue((boolean)(result instanceof ClassNotFoundException));
        String denyList = "org.apache.activemq.artemis.tests.unit.util";
        result = this.readSerializedObject(null, denyList, serailizeFile);
        Assertions.assertTrue((boolean)(result instanceof ClassNotFoundException));
        denyList = "org.apache.activemq.artemis.tests.unit.util.deserialization.pkg1";
        result = this.readSerializedObject(null, denyList, serailizeFile);
        Assertions.assertTrue((boolean)(result instanceof ClassNotFoundException));
        denyList = "org.apache.activemq.artemis.tests.unit.util.deserialization.pkg2";
        result = this.readSerializedObject(null, denyList, serailizeFile);
        Assertions.assertNull((Object)result);
        denyList = "some.other.package";
        allowList = "some.other.package1";
        result = this.readSerializedObject(allowList, denyList, serailizeFile);
        Assertions.assertTrue((boolean)(result instanceof ClassNotFoundException));
        denyList = "org.apache.activemq.artemis.tests.unit.util.deserialization.pkg1, some.other.package";
        allowList = "org.apache.activemq.artemis.tests.unit.util.deserialization.pkg1";
        result = this.readSerializedObject(allowList, denyList, serailizeFile);
        Assertions.assertTrue((boolean)(result instanceof ClassNotFoundException));
        denyList = "org.apache.activemq.artemis.tests.unit, some.other.package";
        allowList = "org.apache.activemq.artemis.tests.unit.util.deserialization.pkg1";
        result = this.readSerializedObject(allowList, denyList, serailizeFile);
        Assertions.assertTrue((boolean)(result instanceof ClassNotFoundException));
        denyList = "org.apache.activemq.artemis.tests.unit.util.deserialization.pkg1.pkg2, some.other.package";
        allowList = "org.apache.activemq.artemis.tests.unit.util.deserialization.pkg1";
        result = this.readSerializedObject(allowList, denyList, serailizeFile);
        Assertions.assertNull((Object)result);
        denyList = "some.other.package, org.apache.activemq.artemis.tests.unit.util.deserialization.pkg2";
        allowList = "org.apache.activemq.artemis.tests.unit.util.deserialization.pkg1";
        result = this.readSerializedObject(allowList, denyList, serailizeFile);
        Assertions.assertNull((Object)result);
        denyList = "*";
        allowList = "org.apache.activemq.artemis.tests.unit.util.deserialization.pkg1";
        result = this.readSerializedObject(allowList, denyList, serailizeFile);
        Assertions.assertTrue((boolean)(result instanceof ClassNotFoundException));
        denyList = "*";
        allowList = "*";
        result = this.readSerializedObject(allowList, denyList, serailizeFile);
        Assertions.assertTrue((boolean)(result instanceof ClassNotFoundException));
        result = this.readSerializedObject(allowList, null, serailizeFile);
        Assertions.assertNull((Object)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAllowDenyListAgainstArrayObject() throws Exception {
        File serailizeFile = new File(this.temporaryFolder, "testclass.bin");
        TestClass1[] sourceObject = new TestClass1[]{new TestClass1()};
        try (ObjectOutputStream outputStream = new ObjectOutputStream(new FileOutputStream(serailizeFile));){
            outputStream.writeObject(sourceObject);
            outputStream.flush();
        }
        String denyList = null;
        String allowList = null;
        Exception result = this.readSerializedObject(allowList, denyList, serailizeFile);
        Assertions.assertNull((Object)result);
        denyList = "org.apache.activemq.artemis.tests.unit.util.deserialization.pkg1.TestClass1";
        allowList = null;
        result = this.readSerializedObject(allowList, denyList, serailizeFile);
        Assertions.assertTrue((boolean)(result instanceof ClassNotFoundException));
        denyList = null;
        allowList = "org.apache.activemq.artemis.tests.unit.util.deserialization.pkg1.TestClass1";
        result = this.readSerializedObject(allowList, denyList, serailizeFile);
        Assertions.assertNull((Object)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAllowDenyListAgainstListObject() throws Exception {
        File serailizeFile = new File(this.temporaryFolder, "testclass.bin");
        ArrayList<TestClass1> sourceObject = new ArrayList<TestClass1>();
        sourceObject.add(new TestClass1());
        try (ObjectOutputStream outputStream = new ObjectOutputStream(new FileOutputStream(serailizeFile));){
            outputStream.writeObject(sourceObject);
            outputStream.flush();
        }
        String denyList = null;
        String allowList = null;
        Exception result = this.readSerializedObject(allowList, denyList, serailizeFile);
        Assertions.assertNull((Object)result);
        denyList = "org.apache.activemq.artemis.tests.unit.util.deserialization.pkg1.TestClass1";
        allowList = null;
        result = this.readSerializedObject(allowList, denyList, serailizeFile);
        Assertions.assertTrue((boolean)(result instanceof ClassNotFoundException));
        denyList = null;
        allowList = "org.apache.activemq.artemis.tests.unit.util.deserialization.pkg1.TestClass1";
        result = this.readSerializedObject(allowList, denyList, serailizeFile);
        Assertions.assertTrue((boolean)(result instanceof ClassNotFoundException));
        denyList = null;
        allowList = "org.apache.activemq.artemis.tests.unit.util.deserialization.pkg1.TestClass1,java.util.ArrayList";
        result = this.readSerializedObject(allowList, denyList, serailizeFile);
        Assertions.assertNull((Object)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAllowDenyListAgainstListMapObject() throws Exception {
        File serailizeFile = new File(this.temporaryFolder, "testclass.bin");
        HashMap<TestClass1, TestClass2> sourceObject = new HashMap<TestClass1, TestClass2>();
        sourceObject.put(new TestClass1(), new TestClass2());
        try (ObjectOutputStream outputStream = new ObjectOutputStream(new FileOutputStream(serailizeFile));){
            outputStream.writeObject(sourceObject);
            outputStream.flush();
        }
        String denyList = null;
        String allowList = null;
        Exception result = this.readSerializedObject(allowList, denyList, serailizeFile);
        Assertions.assertNull((Object)result);
        denyList = "org.apache.activemq.artemis.tests.unit.util.deserialization.pkg1.TestClass1";
        allowList = null;
        result = this.readSerializedObject(allowList, denyList, serailizeFile);
        Assertions.assertTrue((boolean)(result instanceof ClassNotFoundException));
        denyList = "org.apache.activemq.artemis.tests.unit.util.deserialization.pkg1.TestClass2";
        allowList = null;
        result = this.readSerializedObject(allowList, denyList, serailizeFile);
        Assertions.assertTrue((boolean)(result instanceof ClassNotFoundException));
        denyList = null;
        allowList = "org.apache.activemq.artemis.tests.unit.util.deserialization.pkg1.TestClass1";
        result = this.readSerializedObject(allowList, denyList, serailizeFile);
        Assertions.assertTrue((boolean)(result instanceof ClassNotFoundException));
        denyList = null;
        allowList = "org.apache.activemq.artemis.tests.unit.util.deserialization.pkg1.TestClass2";
        result = this.readSerializedObject(allowList, denyList, serailizeFile);
        Assertions.assertTrue((boolean)(result instanceof ClassNotFoundException));
        denyList = null;
        allowList = "org.apache.activemq.artemis.tests.unit.util.deserialization.pkg1.TestClass1,org.apache.activemq.artemis.tests.unit.util.deserialization.pkg1.TestClass2";
        result = this.readSerializedObject(allowList, denyList, serailizeFile);
        Assertions.assertTrue((boolean)(result instanceof ClassNotFoundException));
        denyList = null;
        allowList = "org.apache.activemq.artemis.tests.unit.util.deserialization.pkg1.TestClass1,org.apache.activemq.artemis.tests.unit.util.deserialization.pkg1.TestClass2,java.util.HashMap";
        result = this.readSerializedObject(allowList, denyList, serailizeFile);
        Assertions.assertNull((Object)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAllowDenyListAnonymousObject() throws Exception {
        File serailizeFile = new File(this.temporaryFolder, "testclass.bin");
        try (ObjectOutputStream outputStream = new ObjectOutputStream(new FileOutputStream(serailizeFile));){
            Serializable object = EnclosingClass.anonymousObject;
            Assertions.assertTrue((boolean)object.getClass().isAnonymousClass());
            outputStream.writeObject(object);
            outputStream.flush();
        }
        String denyList = null;
        String allowList = null;
        Assertions.assertNull((Object)this.readSerializedObject(allowList, denyList, serailizeFile));
        denyList = "org.apache.activemq.artemis.tests.unit.util.deserialization.pkg1.EnclosingClass";
        Exception result = this.readSerializedObject(allowList, denyList, serailizeFile);
        Assertions.assertTrue((boolean)(result instanceof ClassNotFoundException));
        denyList = null;
        allowList = "org.apache.activemq.artemis.tests.unit.util.deserialization.pkg1.EnclosingClass";
        result = this.readSerializedObject(allowList, denyList, serailizeFile);
        Assertions.assertNull((Object)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAllowDenyListLocalObject() throws Exception {
        File serailizeFile = new File(this.temporaryFolder, "testclass.bin");
        try (ObjectOutputStream outputStream = new ObjectOutputStream(new FileOutputStream(serailizeFile));){
            Object object = EnclosingClass.getLocalObject();
            Assertions.assertTrue((boolean)object.getClass().isLocalClass());
            outputStream.writeObject(object);
            outputStream.flush();
        }
        String denyList = null;
        String allowList = null;
        Assertions.assertNull((Object)this.readSerializedObject(allowList, denyList, serailizeFile));
        denyList = "org.apache.activemq.artemis.tests.unit.util.deserialization.pkg1.EnclosingClass";
        Exception result = this.readSerializedObject(allowList, denyList, serailizeFile);
        Assertions.assertTrue((boolean)(result instanceof ClassNotFoundException));
        denyList = null;
        allowList = "org.apache.activemq.artemis.tests.unit.util.deserialization.pkg1.EnclosingClass";
        result = this.readSerializedObject(allowList, denyList, serailizeFile);
        Assertions.assertNull((Object)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeprecatedWhiteBlackListSystemProperty() throws Exception {
        File serailizeFile = new File(this.temporaryFolder, "testclass.bin");
        try (ObjectOutputStream outputStream = new ObjectOutputStream(new FileOutputStream(serailizeFile));){
            outputStream.writeObject(new TestClass1());
            outputStream.flush();
        }
        System.setProperty("org.apache.activemq.artemis.jms.deserialization.blacklist", "system.defined.black.list");
        System.setProperty("org.apache.activemq.artemis.jms.deserialization.whitelist", "system.defined.white.list");
        try {
            ObjectInputStreamWithClassLoader ois = new ObjectInputStreamWithClassLoader((InputStream)new FileInputStream(serailizeFile));
            String bList = ois.getDenyList();
            String wList = ois.getAllowList();
            Assertions.assertEquals((Object)"system.defined.black.list", (Object)bList, (String)("wrong black list: " + bList));
            Assertions.assertEquals((Object)"system.defined.white.list", (Object)wList, (String)("wrong white list: " + wList));
            ois.close();
        }
        finally {
            System.clearProperty("org.apache.activemq.artemis.jms.deserialization.blacklist");
            System.clearProperty("org.apache.activemq.artemis.jms.deserialization.whitelist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAllowDenyListSystemProperty() throws Exception {
        File serailizeFile = new File(this.temporaryFolder, "testclass.bin");
        try (ObjectOutputStream outputStream = new ObjectOutputStream(new FileOutputStream(serailizeFile));){
            outputStream.writeObject(new TestClass1());
            outputStream.flush();
        }
        System.setProperty("org.apache.activemq.artemis.jms.deserialization.denylist", "system.defined.deny.list");
        System.setProperty("org.apache.activemq.artemis.jms.deserialization.allowlist", "system.defined.allow.list");
        try {
            ObjectInputStreamWithClassLoader ois = new ObjectInputStreamWithClassLoader((InputStream)new FileInputStream(serailizeFile));
            String bList = ois.getDenyList();
            String wList = ois.getAllowList();
            Assertions.assertEquals((Object)"system.defined.deny.list", (Object)bList, (String)("wrong deny list: " + bList));
            Assertions.assertEquals((Object)"system.defined.allow.list", (Object)wList, (String)("wrong allow list: " + wList));
            ois.close();
        }
        finally {
            System.clearProperty("org.apache.activemq.artemis.jms.deserialization.denylist");
            System.clearProperty("org.apache.activemq.artemis.jms.deserialization.allowlist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Exception readSerializedObject(String allowList, String denyList, File serailizeFile) {
        Exception result = null;
        ObjectInputStreamWithClassLoader ois = null;
        try {
            ois = new ObjectInputStreamWithClassLoader((InputStream)new FileInputStream(serailizeFile));
            ois.setAllowList(allowList);
            ois.setDenyList(denyList);
            ois.readObject();
        }
        catch (Exception e) {
            result = e;
        }
        finally {
            try {
                ois.close();
            }
            catch (IOException e) {
                result = e;
            }
        }
        return result;
    }

    private static byte[] toBytes(Object obj) throws IOException {
        Assertions.assertTrue((boolean)(obj instanceof Serializable));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(obj);
        oos.flush();
        return baos.toByteArray();
    }

    private static class AnObjectImpl
    implements AnObject {
        private static final long serialVersionUID = -5172742084489525256L;
        int myInt = 0;
        long myLong = 0L;

        private AnObjectImpl() {
        }

        @Override
        public int getMyInt() {
            return this.myInt;
        }

        @Override
        public void setMyInt(int value) {
            this.myInt = value;
        }

        @Override
        public long getMyLong() {
            return this.myLong;
        }

        @Override
        public void setMyLong(long value) {
            this.myLong = value;
        }
    }

    private static interface AnObject
    extends Serializable {
        public int getMyInt();

        public void setMyInt(int var1);

        public long getMyLong();

        public void setMyLong(long var1);
    }

    private static class AnObjectInvocationHandler
    implements InvocationHandler,
    Serializable {
        private static final long serialVersionUID = -3875973764178767452L;
        private final AnObject anObject = new AnObjectImpl();

        private AnObjectInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object obj = method.invoke((Object)this.anObject, args);
            if (obj instanceof Integer) {
                return (Integer)obj * 2;
            }
            return obj;
        }
    }

    public static class ProxyReader
    implements Runnable {
        public ObjectInputStream ois;
        public Object originalProxy;
        public ClassLoader testClassLoader;

        void myAssertNotSame(Object obj, Object obj2) {
            if (obj == obj2) {
                throw new RuntimeException("Expected to be different objects");
            }
        }

        void myAssertSame(Object obj, Object obj2) {
            if (obj != obj2) {
                throw new RuntimeException("Expected to be the same objects");
            }
        }

        @Override
        public void run() {
            try {
                Object deserializedObj = this.ois.readObject();
                System.out.println("Deserialized Object " + deserializedObj);
                this.myAssertNotSame(this.originalProxy, deserializedObj);
                this.myAssertNotSame(this.originalProxy.getClass(), deserializedObj.getClass());
                this.myAssertNotSame(this.originalProxy.getClass().getClassLoader(), deserializedObj.getClass().getClassLoader());
                this.myAssertSame(this.testClassLoader, deserializedObj.getClass().getClassLoader());
                AnObject myInterface = (AnObject)deserializedObj;
                if (myInterface.getMyInt() != 200) {
                    throw new RuntimeException("invalid result");
                }
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }
}

