/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.network;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.core.server.NetworkHealthCheck;
import org.apache.activemq.artemis.utils.ExecuteUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;

public class NetUtil
extends ExecuteUtil {
    public static AtomicInteger nextDevice = new AtomicInteger(0);
    public static Map<String, String> networks = new ConcurrentHashMap<String, String>();
    static final OS osUsed;
    static final String user;

    public static boolean checkIP(String ip) throws Exception {
        InetAddress ipAddress = null;
        try {
            ipAddress = InetAddress.getByName(ip);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        NetworkHealthCheck healthCheck = new NetworkHealthCheck(null, 100L, 100);
        return healthCheck.check(ipAddress);
    }

    public static void skipIfNotSudo() {
        NetUtil.skipIfNotSupportedOS();
        boolean canSudo = NetUtil.canSudo();
        if (!canSudo) {
            StringWriter writer = new StringWriter();
            PrintWriter out = new PrintWriter(writer);
            out.println("In order to run this test you must be able to sudo ifconfig.");
            out.println("E.g add the following at the end of your /etc/sudoers (use the visudo command)");
            out.println("# ------------------------------------------------------- ");
            out.println(user + " ALL = NOPASSWD: /sbin/ifconfig");
            out.println("# ------------------------------------------------------- ");
            System.out.println(writer.toString());
            Assumptions.assumeTrue((boolean)canSudo, (String)"Not able to sudo ifconfig");
        }
    }

    public static void skipIfNotSupportedOS() {
        Assumptions.assumeTrue((osUsed != OS.NON_SUPORTED ? (byte)1 : 0) != 0, (String)"non supported OS");
    }

    public static void cleanup() {
        nextDevice.set(0);
        Set<Map.Entry<String, String>> entrySet = networks.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            try {
                NetUtil.netDown(entry.getKey(), entry.getValue(), true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void netUp(String ip) throws Exception {
        String deviceID = "lo:" + nextDevice.incrementAndGet();
        NetUtil.netUp(ip, deviceID);
    }

    public static void netUp(String ip, String deviceID) throws Exception {
        if (osUsed == OS.MAC) {
            if (NetUtil.runCommand(false, "sudo", "-n", "ifconfig", "lo0", "alias", ip) != 0) {
                Assertions.fail((String)("Cannot sudo ifconfig for ip " + ip));
            }
            networks.put(ip, "lo0");
        } else if (osUsed == OS.LINUX) {
            if (NetUtil.runCommand(false, "sudo", "-n", "ifconfig", deviceID, ip, "netmask", "255.0.0.0") != 0) {
                Assertions.fail((String)("Cannot sudo ifconfig for ip " + ip));
            }
            networks.put(ip, deviceID);
        } else {
            Assertions.fail((String)"OS not supported");
        }
    }

    public static void netDown(String ip) throws Exception {
        NetUtil.netDown(ip, false);
    }

    public static void netDown(String ip, boolean force) throws Exception {
        String device = networks.remove(ip);
        if (!force) {
            Assertions.assertNotNull((Object)device, (String)("ip " + ip + "wasn't set up before"));
        }
        NetUtil.netDown(ip, device, force);
    }

    public static void netDown(String ip, String device, boolean force) throws Exception {
        networks.remove(ip);
        if (osUsed == OS.MAC) {
            if (NetUtil.runCommand(false, "sudo", "-n", "ifconfig", "lo0", "-alias", ip) != 0 && !force) {
                Assertions.fail((String)("Cannot sudo ifconfig for ip " + ip));
            }
        } else if (osUsed == OS.LINUX) {
            if (NetUtil.runCommand(false, "sudo", "-n", "ifconfig", device, "down") != 0 && !force) {
                Assertions.fail((String)("Cannot sudo ifconfig for ip " + ip));
            }
        } else {
            Assertions.fail((String)"OS not supported");
        }
    }

    public static boolean canSudo() {
        try {
            return NetUtil.runCommand(false, "sudo", "-n", "ifconfig") == 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Test
    public void testCanSudo() throws Exception {
        Assertions.assertTrue((boolean)NetUtil.canSudo());
    }

    static {
        user = System.getProperty("user.name");
        String propOS = System.getProperty("os.name").toUpperCase();
        OS osTmp = propOS.contains("MAC") ? OS.MAC : (propOS.contains("LINUX") ? OS.LINUX : OS.NON_SUPORTED);
        osUsed = osTmp;
    }

    private static enum OS {
        MAC,
        LINUX,
        NON_SUPORTED;

    }
}

