/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.service;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.wildfly.common.function.Functions;

public interface Dependency<B extends ServiceBuilder<?>, V>
extends Consumer<B>,
Supplier<V> {
    default public Dependency<B, V> andThen(final Consumer<? super B> after) {
        Objects.requireNonNull(after);
        return new Dependency<B, V>(){

            @Override
            public void accept(B builder) {
                Dependency.this.accept(builder);
                after.accept(builder);
            }

            @Override
            public V get() {
                return Dependency.this.get();
            }
        };
    }

    default public <R> Dependency<B, R> map(final Function<V, R> mapper) {
        Objects.requireNonNull(mapper);
        return new Dependency<B, R>(){

            @Override
            public void accept(B builder) {
                Dependency.this.accept(builder);
            }

            @Override
            public R get() {
                return mapper.apply(Dependency.this.get());
            }
        };
    }

    default public <T, R> Dependency<B, R> combine(final Dependency<B, T> dependency, final BiFunction<V, T, R> mapper) {
        Objects.requireNonNull(dependency);
        Objects.requireNonNull(mapper);
        return new Dependency<B, R>(){

            @Override
            public void accept(B builder) {
                Dependency.this.accept(builder);
                dependency.accept(builder);
            }

            @Override
            public R get() {
                return mapper.apply(Dependency.this.get(), dependency.get());
            }
        };
    }

    default public boolean isEmpty() {
        return false;
    }

    default public boolean isPresent() {
        return !this.isEmpty();
    }

    public static class DefaultDependency<B extends ServiceBuilder<?>, V>
    extends AbstractDependency<B, V> {
        private final ServiceName name;

        protected DefaultDependency(ServiceName name) {
            this.name = name;
        }

        @Override
        public Supplier<V> apply(B builder) {
            return builder.requires(this.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof DefaultDependency)) {
                return false;
            }
            return this.name.equals(((DefaultDependency)object).name);
        }

        public String toString() {
            return this.name.toString();
        }
    }

    public static abstract class AbstractDependency<B extends ServiceBuilder<?>, V>
    implements Dependency<B, V>,
    Function<B, Supplier<V>> {
        private volatile Supplier<V> supplier = Functions.constantSupplier(null);

        @Override
        public V get() {
            return this.supplier.get();
        }

        @Override
        public void accept(B builder) {
            this.supplier = (Supplier)this.apply(builder);
        }
    }

    public static class SuppliedDependency<B extends ServiceBuilder<?>, V>
    implements Dependency<B, V> {
        private final Supplier<V> supplier;

        protected SuppliedDependency(Supplier<V> supplier) {
            this.supplier = supplier;
        }

        @Override
        public V get() {
            return this.supplier.get();
        }

        @Override
        public void accept(B builder) {
        }
    }

    public static class SimpleDependency<B extends ServiceBuilder<?>, V>
    implements Dependency<B, V> {
        private final V value;

        protected SimpleDependency(V value) {
            this.value = value;
        }

        @Override
        public V get() {
            return this.value;
        }

        @Override
        public boolean isEmpty() {
            return this.value == null;
        }

        @Override
        public void accept(B builder) {
        }
    }
}

