/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.module;

import java.util.HashSet;
import java.util.List;
import java.util.jar.Manifest;
import org.jboss.as.controller.ModuleIdentifierUtil;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.ManifestHelper;
import org.jboss.as.server.deployment.SubDeploymentMarker;
import org.jboss.as.server.deployment.module.AdditionalModuleSpecification;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.modules.Module;
import org.jboss.modules.filter.PathFilters;

public final class ManifestDependencyProcessor
implements DeploymentUnitProcessor {
    private static final String DEPENDENCIES_ATTR = "Dependencies";
    private static final String EXPORT_PARAM = "export";
    private static final String OPTIONAL_PARAM = "optional";
    private static final String SERVICES_PARAM = "services";
    private static final String ANNOTATIONS_PARAM = "annotations";
    private static final String META_INF = "meta-inf";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ServiceModuleLoader deploymentModuleLoader = deploymentUnit.getAttachment(Attachments.SERVICE_MODULE_LOADER);
        List<ResourceRoot> allResourceRoots = DeploymentUtils.allResourceRoots(deploymentUnit);
        DeploymentUnit top = deploymentUnit.getParent() == null ? deploymentUnit : deploymentUnit.getParent();
        HashSet<String> additionalModules = new HashSet<String>();
        List<AdditionalModuleSpecification> additionalModuleList = top.getAttachmentList(Attachments.ADDITIONAL_MODULES);
        List<AdditionalModuleSpecification> list = additionalModuleList;
        synchronized (list) {
            for (AdditionalModuleSpecification i : additionalModuleList) {
                additionalModules.add(i.getModuleName());
            }
        }
        for (ResourceRoot resourceRoot : allResourceRoots) {
            String[] dependencyDefs;
            String dependencyString;
            Manifest manifest = resourceRoot.getAttachment(Attachments.MANIFEST);
            if (manifest == null || (dependencyString = ManifestHelper.getMainAttributeValue(manifest, DEPENDENCIES_ATTR)) == null || deploymentUnit.getParent() == null && SubDeploymentMarker.isSubDeployment(resourceRoot)) continue;
            for (String dependencyDef : dependencyDefs = dependencyString.split(",")) {
                String trimmed = dependencyDef.trim();
                if (trimmed.isEmpty()) continue;
                String[] dependencyParts = trimmed.split(" ");
                String dependencyId = ModuleIdentifierUtil.canonicalModuleIdentifier((String)dependencyParts[0]);
                boolean export = this.containsParam(dependencyParts, EXPORT_PARAM);
                boolean optional = this.containsParam(dependencyParts, OPTIONAL_PARAM);
                boolean services = this.containsParam(dependencyParts, SERVICES_PARAM);
                boolean annotations = this.containsParam(dependencyParts, ANNOTATIONS_PARAM);
                boolean metaInf = this.containsParam(dependencyParts, META_INF);
                ServiceModuleLoader dependencyLoader = dependencyId.startsWith("deployment.") ? deploymentModuleLoader : Module.getBootModuleLoader();
                if (annotations) {
                    deploymentUnit.addToAttachmentList(Attachments.ADDITIONAL_INDEX_MODULES, dependencyId);
                    if (dependencyLoader == deploymentModuleLoader && !additionalModules.contains(dependencyId)) {
                        phaseContext.addToAttachmentList(Attachments.NEXT_PHASE_DEPS, ServiceModuleLoader.moduleServiceName(dependencyId));
                    }
                }
                ModuleDependency dependency = ModuleDependency.Builder.of(dependencyLoader, dependencyId.toString()).setOptional(optional).setExport(export).setImportServices(services).setUserSpecified(true).build();
                if (metaInf) {
                    dependency.addImportFilter(PathFilters.getMetaInfSubdirectoriesFilter(), true);
                    dependency.addImportFilter(PathFilters.getMetaInfFilter(), true);
                }
                deploymentUnit.addToAttachmentList(Attachments.MANIFEST_DEPENDENCIES, dependency);
            }
        }
    }

    private boolean containsParam(String[] parts, String expected) {
        if (parts.length > 1) {
            for (int i = 1; i < parts.length; ++i) {
                if (!expected.equals(parts[i])) continue;
                return true;
            }
        }
        return false;
    }
}

