/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.module;

import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.vfs.VirtualFile;

public class ModuleIdentifierProcessor
implements DeploymentUnitProcessor {
    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ResourceRoot deploymentRoot = deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        DeploymentUnit parent = deploymentUnit.getParent();
        DeploymentUnit topLevelDeployment = parent == null ? deploymentUnit : parent;
        VirtualFile toplevelRoot = topLevelDeployment.getAttachment(Attachments.DEPLOYMENT_ROOT).getRoot();
        String moduleIdentifier = ModuleIdentifierProcessor.createModuleIdentifierAsString(deploymentUnit.getName(), deploymentRoot, topLevelDeployment, toplevelRoot, deploymentUnit.getParent() == null);
        deploymentUnit.putAttachment(Attachments.MODULE_NAME, moduleIdentifier);
    }

    @Deprecated(forRemoval=true, since="28.0.0")
    public static ModuleIdentifier createModuleIdentifier(String deploymentUnitName, ResourceRoot deploymentRoot, DeploymentUnit topLevelDeployment, VirtualFile toplevelRoot, boolean topLevel) {
        return ModuleIdentifier.create((String)ModuleIdentifierProcessor.createModuleIdentifierAsString(deploymentUnitName, deploymentRoot, topLevelDeployment, toplevelRoot, topLevel));
    }

    public static String createModuleIdentifierAsString(String deploymentUnitName, ResourceRoot deploymentRoot, DeploymentUnit topLevelDeployment, VirtualFile toplevelRoot, boolean topLevel) {
        String moduleIdentifier;
        if (topLevel) {
            moduleIdentifier = "deployment." + deploymentUnitName;
        } else {
            String relativePath = deploymentRoot.getRoot().getPathNameRelativeTo(toplevelRoot);
            moduleIdentifier = "deployment." + topLevelDeployment.getName() + "." + relativePath.replace('/', '.');
        }
        return moduleIdentifier;
    }
}

