/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.module.descriptor;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.server.DeployerChainAddHandler;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.SubDeploymentMarker;
import org.jboss.as.server.deployment.annotation.ResourceRootIndexer;
import org.jboss.as.server.deployment.jbossallxml.JBossAllXmlParserRegisteringProcessor;
import org.jboss.as.server.deployment.module.AdditionalModuleSpecification;
import org.jboss.as.server.deployment.module.ModuleAliasChecker;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleRootMarker;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.deployment.module.descriptor.JBossDeploymentStructureParser10;
import org.jboss.as.server.deployment.module.descriptor.JBossDeploymentStructureParser11;
import org.jboss.as.server.deployment.module.descriptor.JBossDeploymentStructureParser12;
import org.jboss.as.server.deployment.module.descriptor.JBossDeploymentStructureParser13;
import org.jboss.as.server.deployment.module.descriptor.ModuleStructureSpec;
import org.jboss.as.server.deployment.module.descriptor.ParseResult;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.modules.ModuleLoader;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLMapper;
import org.jboss.vfs.VirtualFile;

public class DeploymentStructureDescriptorParser
implements DeploymentUnitProcessor {
    public static final String[] DEPLOYMENT_STRUCTURE_DESCRIPTOR_LOCATIONS = new String[]{"META-INF/jboss-deployment-structure.xml", "WEB-INF/jboss-deployment-structure.xml"};
    private static final AttachmentKey<ParseResult> RESULT_ATTACHMENT_KEY = AttachmentKey.create(ParseResult.class);
    private static final QName ROOT_1_0 = new QName("urn:jboss:deployment-structure:1.0", "jboss-deployment-structure");
    private static final QName ROOT_1_1 = new QName("urn:jboss:deployment-structure:1.1", "jboss-deployment-structure");
    private static final QName ROOT_1_2 = new QName("urn:jboss:deployment-structure:1.2", "jboss-deployment-structure");
    private static final QName ROOT_1_3 = new QName("urn:jboss:deployment-structure:1.3", "jboss-deployment-structure");
    private static final QName ROOT_NO_NAMESPACE = new QName("jboss-deployment-structure");
    private static final XMLInputFactory INPUT_FACTORY = XMLInputFactory.newInstance();
    private final AttachmentKey<ModuleStructureSpec> SUB_DEPLOYMENT_STRUCTURE = AttachmentKey.create(ModuleStructureSpec.class);
    private final XMLMapper mapper = XMLMapper.Factory.create();

    public static void registerJBossXMLParsers() {
        DeployerChainAddHandler.addDeploymentProcessor("server", Phase.STRUCTURE, 2582, new JBossAllXmlParserRegisteringProcessor<ParseResult>(ROOT_1_0, RESULT_ATTACHMENT_KEY, JBossDeploymentStructureParser10.JBOSS_ALL_XML_PARSER));
        DeployerChainAddHandler.addDeploymentProcessor("server", Phase.STRUCTURE, 2583, new JBossAllXmlParserRegisteringProcessor<ParseResult>(ROOT_1_1, RESULT_ATTACHMENT_KEY, JBossDeploymentStructureParser11.JBOSS_ALL_XML_PARSER));
        DeployerChainAddHandler.addDeploymentProcessor("server", Phase.STRUCTURE, 2584, new JBossAllXmlParserRegisteringProcessor<ParseResult>(ROOT_1_2, RESULT_ATTACHMENT_KEY, JBossDeploymentStructureParser12.JBOSS_ALL_XML_PARSER));
        DeployerChainAddHandler.addDeploymentProcessor("server", Phase.STRUCTURE, 2592, new JBossAllXmlParserRegisteringProcessor<ParseResult>(ROOT_1_3, RESULT_ATTACHMENT_KEY, JBossDeploymentStructureParser13.JBOSS_ALL_XML_PARSER));
    }

    public DeploymentStructureDescriptorParser() {
        this.mapper.registerRootElement(ROOT_1_0, (XMLElementReader)JBossDeploymentStructureParser10.INSTANCE);
        this.mapper.registerRootElement(ROOT_1_1, (XMLElementReader)JBossDeploymentStructureParser11.INSTANCE);
        this.mapper.registerRootElement(ROOT_1_2, (XMLElementReader)JBossDeploymentStructureParser12.INSTANCE);
        this.mapper.registerRootElement(ROOT_1_3, (XMLElementReader)JBossDeploymentStructureParser13.INSTANCE);
        this.mapper.registerRootElement(ROOT_NO_NAMESPACE, (XMLElementReader)JBossDeploymentStructureParser13.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ResourceRoot deploymentRoot = deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        ServiceModuleLoader moduleLoader = deploymentUnit.getAttachment(Attachments.SERVICE_MODULE_LOADER);
        if (deploymentUnit.getParent() != null && deploymentRoot.hasAttachment(this.SUB_DEPLOYMENT_STRUCTURE)) {
            List<AdditionalModuleSpecification> additionalModuleList;
            ModuleSpecification subModuleSpec = deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
            HashMap additionalModules = new HashMap();
            List<AdditionalModuleSpecification> list = additionalModuleList = deploymentUnit.getParent().getAttachmentList(Attachments.ADDITIONAL_MODULES);
            synchronized (list) {
                for (AdditionalModuleSpecification i : additionalModuleList) {
                    additionalModules.put(i.getModuleName(), i);
                }
            }
            this.handleDeployment(phaseContext, deploymentUnit, subModuleSpec, deploymentRoot.getAttachment(this.SUB_DEPLOYMENT_STRUCTURE), additionalModules);
        }
        VirtualFile deploymentFile = null;
        for (String loc : DEPLOYMENT_STRUCTURE_DESCRIPTOR_LOCATIONS) {
            VirtualFile file = deploymentRoot.getRoot().getChild(loc);
            if (!file.exists()) continue;
            deploymentFile = file;
            break;
        }
        ParseResult result = deploymentUnit.getAttachment(RESULT_ATTACHMENT_KEY);
        if (deploymentFile == null && result == null) {
            return;
        }
        if (deploymentUnit.getParent() != null) {
            if (deploymentFile != null) {
                ServerLogger.DEPLOYMENT_LOGGER.jbossDeploymentStructureIgnored(deploymentFile.getPathName());
            }
            if (result != null) {
                ServerLogger.DEPLOYMENT_LOGGER.jbossDeploymentStructureNamespaceIgnored(deploymentUnit.getName());
            }
            return;
        }
        try {
            ModuleStructureSpec rootDeploymentSpecification;
            if (deploymentFile != null) {
                result = this.parse(deploymentFile.getPhysicalFile(), deploymentUnit, moduleLoader);
            }
            HashMap<String, AdditionalModuleSpecification> additionalModules = new HashMap<String, AdditionalModuleSpecification>();
            for (ModuleStructureSpec additionalModule : result.getAdditionalModules()) {
                for (String identifier : additionalModule.getAnnotationModules()) {
                    ServerLogger.DEPLOYMENT_LOGGER.annotationImportIgnored(identifier, additionalModule.getModuleName());
                }
                ArrayList<ResourceRoot> additionalModuleResourceRoots = new ArrayList<ResourceRoot>(additionalModule.getResourceRoots());
                ListIterator itr = additionalModuleResourceRoots.listIterator();
                while (itr.hasNext()) {
                    ResourceRoot resourceRoot = (ResourceRoot)itr.next();
                    if (resourceRoot.getRoot().exists()) continue;
                    ServerLogger.DEPLOYMENT_LOGGER.additionalResourceRootDoesNotExist(resourceRoot.getRoot().getPathName());
                    itr.remove();
                }
                AdditionalModuleSpecification additional = new AdditionalModuleSpecification(additionalModule.getModuleName(), additionalModuleResourceRoots);
                for (String alias : additionalModule.getAliasesList()) {
                    additional.addModuleAlias(alias);
                }
                additional.addSystemDependencies(additionalModule.getModuleDependencies());
                additionalModules.put(additional.getModuleName(), additional);
                deploymentUnit.addToAttachmentList(Attachments.ADDITIONAL_MODULES, additional);
                for (ResourceRoot root : additionalModuleResourceRoots) {
                    ResourceRootIndexer.indexResourceRoot(root);
                }
            }
            ModuleSpecification moduleSpec = deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
            if (result.getEarSubDeploymentsIsolated() != null) {
                moduleSpec.setSubDeploymentModulesIsolated(result.getEarSubDeploymentsIsolated());
            }
            if (result.getEarExclusionsCascadedToSubDeployments() != null) {
                moduleSpec.setExclusionsCascadedToSubDeployments(result.getEarExclusionsCascadedToSubDeployments());
            }
            if ((rootDeploymentSpecification = result.getRootDeploymentSpecification()) != null) {
                this.handleDeployment(phaseContext, deploymentUnit, moduleSpec, rootDeploymentSpecification, additionalModules);
            }
            HashMap<String, ResourceRoot> subDeploymentMap = new HashMap<String, ResourceRoot>();
            List<ResourceRoot> resourceRoots = deploymentUnit.getAttachmentList(Attachments.RESOURCE_ROOTS);
            for (ResourceRoot resourceRoot : resourceRoots) {
                if (!SubDeploymentMarker.isSubDeployment(resourceRoot)) continue;
                subDeploymentMap.put(resourceRoot.getRoot().getPathNameRelativeTo(deploymentRoot.getRoot()), resourceRoot);
            }
            for (Map.Entry entry : result.getSubDeploymentSpecifications().entrySet()) {
                String path = (String)entry.getKey();
                ModuleStructureSpec spec = (ModuleStructureSpec)entry.getValue();
                if (!subDeploymentMap.containsKey(path)) {
                    throw this.subDeploymentNotFound(path, subDeploymentMap.keySet());
                }
                ResourceRoot subDeployment = (ResourceRoot)subDeploymentMap.get(path);
                subDeployment.putAttachment(this.SUB_DEPLOYMENT_STRUCTURE, spec);
                if (!moduleSpec.isExclusionsCascadedToSubDeployments() || rootDeploymentSpecification == null) continue;
                for (String exclusion : rootDeploymentSpecification.getExclusionsList()) {
                    spec.addExclusion(exclusion);
                }
            }
        }
        catch (IOException e) {
            throw new DeploymentUnitProcessingException(e);
        }
    }

    private void handleDeployment(DeploymentPhaseContext phaseContext, DeploymentUnit deploymentUnit, ModuleSpecification moduleSpec, ModuleStructureSpec rootDeploymentSpecification, Map<String, AdditionalModuleSpecification> additionalModules) throws DeploymentUnitProcessingException {
        Map<VirtualFile, ResourceRoot> resourceRoots = this.resourceRoots(deploymentUnit);
        List<ModuleDependency> moduleDependencies = rootDeploymentSpecification.getModuleDependencies();
        ArrayList<ModuleDependency> aliasDependencies = new ArrayList<ModuleDependency>();
        HashMap<String, AdditionalModuleSpecification> index = new HashMap<String, AdditionalModuleSpecification>();
        for (AdditionalModuleSpecification additionalModuleSpecification : additionalModules.values()) {
            for (String alias : additionalModuleSpecification.getModuleAliases()) {
                index.put(alias, additionalModuleSpecification);
            }
        }
        for (ModuleDependency dependency : moduleDependencies) {
            String identifier = dependency.getDependencyModule();
            if (!index.containsKey(identifier)) continue;
            ModuleDependency moduleDependency = ModuleDependency.Builder.of(dependency.getModuleLoader(), ((AdditionalModuleSpecification)index.get(identifier)).getModuleName()).setOptional(dependency.isOptional()).setExport(dependency.isExport()).setImportServices(dependency.isImportServices()).setUserSpecified(dependency.isUserSpecified()).build();
            aliasDependencies.add(moduleDependency);
        }
        ModuleAliasChecker.checkModuleAliasesForDependencies(moduleDependencies, ModuleAliasChecker.MessageContext.JBOSS_DEPLOYMENT_STRUCTURE_CONTEXT, deploymentUnit.getName());
        moduleSpec.addUserDependencies(moduleDependencies);
        List<String> list = rootDeploymentSpecification.getExclusionsList();
        for (String exclusion : list) {
            ModuleAliasChecker.checkModuleAliasesForExclusion(exclusion, ModuleAliasChecker.MessageContext.JBOSS_DEPLOYMENT_STRUCTURE_CONTEXT, deploymentUnit.getName());
            moduleSpec.addModuleExclusion(exclusion);
        }
        for (String alias : rootDeploymentSpecification.getAliasesList()) {
            moduleSpec.addModuleAlias(alias);
        }
        moduleSpec.addModuleSystemDependencies(rootDeploymentSpecification.getSystemDependencies());
        for (ResourceRoot additionalResourceRoot : rootDeploymentSpecification.getResourceRoots()) {
            ResourceRoot existingRoot = resourceRoots.get(additionalResourceRoot.getRoot());
            if (existingRoot != null) {
                existingRoot.merge(additionalResourceRoot);
                continue;
            }
            if (!additionalResourceRoot.getRoot().exists()) {
                ServerLogger.DEPLOYMENT_LOGGER.additionalResourceRootDoesNotExist(additionalResourceRoot.getRoot().getPathName());
                continue;
            }
            deploymentUnit.addToAttachmentList(Attachments.RESOURCE_ROOTS, additionalResourceRoot);
            ResourceRootIndexer.indexResourceRoot(additionalResourceRoot);
            ModuleRootMarker.mark(additionalResourceRoot);
        }
        for (String classTransformer : rootDeploymentSpecification.getClassTransformers()) {
            moduleSpec.addClassTransformer(classTransformer);
        }
        Iterator<Object> iterator = rootDeploymentSpecification.getAnnotationModules().iterator();
        while (iterator.hasNext()) {
            String dependency;
            String identifier = dependency = (String)iterator.next();
            for (AdditionalModuleSpecification module : additionalModules.values()) {
                if (!module.getModuleAliases().contains(identifier)) continue;
                identifier = module.getModuleName();
                break;
            }
            deploymentUnit.addToAttachmentList(Attachments.ADDITIONAL_INDEX_MODULES, identifier);
            if (!identifier.startsWith("deployment.") || additionalModules.containsKey(identifier) || this.isSubdeployment(identifier, deploymentUnit)) continue;
            phaseContext.addToAttachmentList(Attachments.NEXT_PHASE_DEPS, ServiceModuleLoader.moduleServiceName(identifier));
        }
        moduleSpec.setLocalLast(rootDeploymentSpecification.isLocalLast());
        if (rootDeploymentSpecification.getExcludedSubsystems() != null) {
            deploymentUnit.putAttachment(Attachments.EXCLUDED_SUBSYSTEMS, rootDeploymentSpecification.getExcludedSubsystems());
        }
    }

    private boolean isSubdeployment(String dependency, DeploymentUnit deploymentUnit) {
        DeploymentUnit top = deploymentUnit.getParent() == null ? deploymentUnit : deploymentUnit.getParent();
        return dependency.startsWith("deployment.".concat(top.getName()));
    }

    private Map<VirtualFile, ResourceRoot> resourceRoots(DeploymentUnit deploymentUnit) {
        HashMap<VirtualFile, ResourceRoot> resourceRoots = new HashMap<VirtualFile, ResourceRoot>();
        for (ResourceRoot root : DeploymentUtils.allResourceRoots(deploymentUnit)) {
            resourceRoots.put(root.getRoot(), root);
        }
        return resourceRoots;
    }

    private DeploymentUnitProcessingException subDeploymentNotFound(String path, Collection<String> subDeployments) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String dep : subDeployments) {
            if (!first) {
                builder.append(", ");
            } else {
                first = false;
            }
            builder.append(dep);
        }
        return ServerLogger.ROOT_LOGGER.subdeploymentNotFound(path, builder);
    }

    @Override
    public void undeploy(DeploymentUnit context) {
        context.removeAttachment(Attachments.EXCLUDED_SUBSYSTEMS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParseResult parse(File file, DeploymentUnit deploymentUnit, ModuleLoader moduleLoader) throws DeploymentUnitProcessingException {
        FileInputStream fis;
        try {
            fis = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw ServerLogger.ROOT_LOGGER.deploymentStructureFileNotFound(file);
        }
        try {
            ParseResult parseResult = this.parse(fis, file, deploymentUnit, moduleLoader);
            return parseResult;
        }
        finally {
            DeploymentStructureDescriptorParser.safeClose(fis);
        }
    }

    private void setIfSupported(XMLInputFactory inputFactory, String property, Object value) {
        if (inputFactory.isPropertySupported(property)) {
            inputFactory.setProperty(property, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParseResult parse(InputStream source, File file, DeploymentUnit deploymentUnit, ModuleLoader moduleLoader) throws DeploymentUnitProcessingException {
        ParseResult parseResult;
        XMLInputFactory inputFactory = INPUT_FACTORY;
        this.setIfSupported(inputFactory, "javax.xml.stream.isValidating", Boolean.FALSE);
        this.setIfSupported(inputFactory, "javax.xml.stream.supportDTD", Boolean.FALSE);
        XMLStreamReader streamReader = inputFactory.createXMLStreamReader(source);
        try {
            ParseResult result = new ParseResult(moduleLoader, deploymentUnit);
            this.mapper.parseDocument((Object)result, streamReader);
            parseResult = result;
        }
        catch (Throwable throwable) {
            try {
                DeploymentStructureDescriptorParser.safeClose(streamReader);
                throw throwable;
            }
            catch (XMLStreamException e) {
                throw ServerLogger.ROOT_LOGGER.errorLoadingDeploymentStructureFile(file.getPath(), e);
            }
        }
        DeploymentStructureDescriptorParser.safeClose(streamReader);
        return parseResult;
    }

    private static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void safeClose(XMLStreamReader streamReader) {
        if (streamReader != null) {
            try {
                streamReader.close();
            }
            catch (XMLStreamException xMLStreamException) {
                // empty catch block
            }
        }
    }
}

