/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem.remote;

import java.util.function.ToLongFunction;
import org.infinispan.client.hotrod.jmx.RemoteCacheClientStatisticsMXBean;
import org.jboss.as.clustering.controller.Metric;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum RemoteCacheMetric implements Metric<RemoteCacheClientStatisticsMXBean>,
ToLongFunction<RemoteCacheClientStatisticsMXBean>
{
    AVERAGE_READ_TIME("average-read-time", MeasurementUnit.MILLISECONDS){

        @Override
        public long applyAsLong(RemoteCacheClientStatisticsMXBean statistics) {
            return statistics.getAverageRemoteReadTime();
        }
    }
    ,
    AVERAGE_REMOVE_TIME("average-remove-time", MeasurementUnit.MILLISECONDS){

        @Override
        public long applyAsLong(RemoteCacheClientStatisticsMXBean statistics) {
            return statistics.getAverageRemoteRemovesTime();
        }
    }
    ,
    AVERAGE_WRITE_TIME("average-write-time", MeasurementUnit.MILLISECONDS){

        @Override
        public long applyAsLong(RemoteCacheClientStatisticsMXBean statistics) {
            return statistics.getAverageRemoteStoreTime();
        }
    }
    ,
    NEAR_CACHE_HITS("near-cache-hits", AttributeAccess.Flag.COUNTER_METRIC){

        @Override
        public long applyAsLong(RemoteCacheClientStatisticsMXBean statistics) {
            return statistics.getNearCacheHits();
        }
    }
    ,
    NEAR_CACHE_INVALIDATIONS("near-cache-invalidations", AttributeAccess.Flag.COUNTER_METRIC){

        @Override
        public long applyAsLong(RemoteCacheClientStatisticsMXBean statistics) {
            return statistics.getNearCacheInvalidations();
        }
    }
    ,
    NEAR_CACHE_MISSES("near-cache-misses", AttributeAccess.Flag.COUNTER_METRIC){

        @Override
        public long applyAsLong(RemoteCacheClientStatisticsMXBean statistics) {
            return statistics.getNearCacheMisses();
        }
    }
    ,
    NEAR_CACHE_SIZE("near-cache-size", AttributeAccess.Flag.GAUGE_METRIC){

        @Override
        public long applyAsLong(RemoteCacheClientStatisticsMXBean statistics) {
            return statistics.getNearCacheSize();
        }
    }
    ,
    HITS("hits", AttributeAccess.Flag.COUNTER_METRIC){

        @Override
        public long applyAsLong(RemoteCacheClientStatisticsMXBean statistics) {
            return statistics.getRemoteHits();
        }
    }
    ,
    MISSES("misses", AttributeAccess.Flag.COUNTER_METRIC){

        @Override
        public long applyAsLong(RemoteCacheClientStatisticsMXBean statistics) {
            return statistics.getRemoteMisses();
        }
    }
    ,
    REMOVES("removes", AttributeAccess.Flag.COUNTER_METRIC){

        @Override
        public long applyAsLong(RemoteCacheClientStatisticsMXBean statistics) {
            return statistics.getRemoteRemoves();
        }
    }
    ,
    WRITES("writes", AttributeAccess.Flag.COUNTER_METRIC){

        @Override
        public long applyAsLong(RemoteCacheClientStatisticsMXBean statistics) {
            return statistics.getRemoteStores();
        }
    }
    ,
    TIME_SINCE_RESET("time-since-reset", MeasurementUnit.SECONDS){

        @Override
        public long applyAsLong(RemoteCacheClientStatisticsMXBean statistics) {
            return statistics.getTimeSinceReset();
        }
    };

    private final AttributeDefinition definition;

    private RemoteCacheMetric(String name, AttributeAccess.Flag metricType) {
        this(name, metricType, null);
    }

    private RemoteCacheMetric(String name, MeasurementUnit unit) {
        this(name, AttributeAccess.Flag.GAUGE_METRIC, unit);
    }

    private RemoteCacheMetric(String name, AttributeAccess.Flag metricType, MeasurementUnit unit) {
        this.definition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, ModelType.LONG).setFlags(new AttributeAccess.Flag[]{metricType})).setMeasurementUnit(unit)).setStorageRuntime()).build();
    }

    public AttributeDefinition getDefinition() {
        return this.definition;
    }

    public ModelNode execute(RemoteCacheClientStatisticsMXBean statistics) {
        return new ModelNode(this.applyAsLong(statistics));
    }
}

