/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.pojo.descriptor;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.ModuleIdentifierUtil;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.pojo.BeanState;
import org.jboss.as.pojo.ParseResult;
import org.jboss.as.pojo.descriptor.BeanDeploymentSchema;
import org.jboss.as.pojo.descriptor.BeanFactoryMetaDataConfig;
import org.jboss.as.pojo.descriptor.BeanMetaDataConfig;
import org.jboss.as.pojo.descriptor.CallbackConfig;
import org.jboss.as.pojo.descriptor.CollectionConfig;
import org.jboss.as.pojo.descriptor.ConstructorConfig;
import org.jboss.as.pojo.descriptor.DependsConfig;
import org.jboss.as.pojo.descriptor.FactoryConfig;
import org.jboss.as.pojo.descriptor.InjectedValueConfig;
import org.jboss.as.pojo.descriptor.InstallConfig;
import org.jboss.as.pojo.descriptor.KernelDeploymentXmlDescriptor;
import org.jboss.as.pojo.descriptor.LifecycleConfig;
import org.jboss.as.pojo.descriptor.ListConfig;
import org.jboss.as.pojo.descriptor.MapConfig;
import org.jboss.as.pojo.descriptor.ModeConfig;
import org.jboss.as.pojo.descriptor.ModuleConfig;
import org.jboss.as.pojo.descriptor.PropertyConfig;
import org.jboss.as.pojo.descriptor.SetConfig;
import org.jboss.as.pojo.descriptor.StringValueConfig;
import org.jboss.as.pojo.descriptor.ValueConfig;
import org.jboss.as.pojo.descriptor.ValueFactoryConfig;
import org.jboss.as.pojo.logging.PojoLogger;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class KernelDeploymentXmlDescriptorParser
implements XMLElementReader<ParseResult<KernelDeploymentXmlDescriptor>>,
XMLStreamConstants {
    private final BeanDeploymentSchema schema;

    public KernelDeploymentXmlDescriptorParser(BeanDeploymentSchema schema) {
        this.schema = schema;
    }

    public void readElement(XMLExtendedStreamReader reader, ParseResult<KernelDeploymentXmlDescriptor> value) throws XMLStreamException {
        KernelDeploymentXmlDescriptor kernelDeploymentXmlDescriptor = new KernelDeploymentXmlDescriptor();
        ArrayList<BeanMetaDataConfig> beansConfigs = new ArrayList<BeanMetaDataConfig>();
        kernelDeploymentXmlDescriptor.setBeans(beansConfigs);
        value.setResult(kernelDeploymentXmlDescriptor);
        int count = reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            String attributeName = reader.getAttributeLocalName(i);
            Attribute attribute = Attribute.of(attributeName);
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case MODE: {
                    kernelDeploymentXmlDescriptor.setMode(ModeConfig.of(attributeValue));
                }
            }
        }
        while (reader.hasNext()) {
            block3 : switch (reader.nextTag()) {
                case 5: {
                    break;
                }
                case 2: {
                    return;
                }
                case 1: {
                    switch (Element.of(reader.getLocalName())) {
                        case BEAN: {
                            beansConfigs.add(this.parseBean(reader));
                            break block3;
                        }
                        case BEAN_FACTORY: {
                            BeanMetaDataConfig bean = this.parseBean(reader);
                            beansConfigs.add(this.toBeanFactory(bean));
                            kernelDeploymentXmlDescriptor.incrementBeanFactoryCount();
                            break block3;
                        }
                        case UNKNOWN: {
                            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                        }
                    }
                }
            }
        }
    }

    private BeanMetaDataConfig toBeanFactory(BeanMetaDataConfig bean) {
        return new BeanFactoryMetaDataConfig(bean);
    }

    private BeanMetaDataConfig parseBean(XMLExtendedStreamReader reader) throws XMLStreamException {
        BeanMetaDataConfig beanConfig = new BeanMetaDataConfig();
        int count = reader.getAttributeCount();
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        block26: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case NAME: {
                    beanConfig.setName(attributeValue);
                    continue block26;
                }
                case CLASS: {
                    beanConfig.setBeanClass(attributeValue);
                    continue block26;
                }
                case MODE: {
                    beanConfig.setMode(ModeConfig.of(attributeValue));
                    continue block26;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        while (reader.hasNext()) {
            block5 : switch (reader.nextTag()) {
                case 5: {
                    break;
                }
                case 2: {
                    return beanConfig;
                }
                case 1: {
                    switch (Element.of(reader.getLocalName())) {
                        case ALIAS: {
                            Set<String> aliases = beanConfig.getAliases();
                            if (aliases == null) {
                                aliases = new HashSet<String>();
                                beanConfig.setAliases(aliases);
                            }
                            aliases.add(this.parseAlias(reader));
                            break block5;
                        }
                        case CLASSLOADER: {
                            beanConfig.setModule(this.parseModuleConfig(reader));
                            break block5;
                        }
                        case CONSTRUCTOR: {
                            beanConfig.setConstructor(this.parseConstructor(reader));
                            break block5;
                        }
                        case PROPERTY: {
                            Set<PropertyConfig> properties = beanConfig.getProperties();
                            if (properties == null) {
                                properties = new HashSet<PropertyConfig>();
                                beanConfig.setProperties(properties);
                            }
                            properties.add(this.parseProperty(reader));
                            break block5;
                        }
                        case INSTALL: {
                            List<InstallConfig> installs = beanConfig.getInstalls();
                            if (installs == null) {
                                installs = new ArrayList<InstallConfig>();
                                beanConfig.setInstalls(installs);
                            }
                            installs.add(this.parseInstall(reader));
                            break block5;
                        }
                        case UNINSTALL: {
                            List<InstallConfig> uninstalls = beanConfig.getUninstalls();
                            if (uninstalls == null) {
                                uninstalls = new ArrayList<InstallConfig>();
                                beanConfig.setUninstalls(uninstalls);
                            }
                            uninstalls.add(this.parseInstall(reader));
                            break block5;
                        }
                        case INCALLBACK: {
                            List<CallbackConfig> incallbacks = beanConfig.getIncallbacks();
                            if (incallbacks == null) {
                                incallbacks = new ArrayList<CallbackConfig>();
                                beanConfig.setIncallbacks(incallbacks);
                            }
                            incallbacks.add(this.parseCallback(reader));
                            break block5;
                        }
                        case UNCALLBACK: {
                            List<CallbackConfig> uncallbacks = beanConfig.getUncallbacks();
                            if (uncallbacks == null) {
                                uncallbacks = new ArrayList<CallbackConfig>();
                                beanConfig.setUncallbacks(uncallbacks);
                            }
                            uncallbacks.add(this.parseCallback(reader));
                            break block5;
                        }
                        case DEPENDS: {
                            Set<DependsConfig> depends = beanConfig.getDepends();
                            if (depends == null) {
                                depends = new HashSet<DependsConfig>();
                                beanConfig.setDepends(depends);
                            }
                            depends.add(this.parseDepends(reader));
                            break block5;
                        }
                        case CREATE: {
                            beanConfig.setCreate(this.parseLifecycle(reader, "create"));
                            break block5;
                        }
                        case START: {
                            beanConfig.setStart(this.parseLifecycle(reader, "start"));
                            break block5;
                        }
                        case STOP: {
                            beanConfig.setStop(this.parseLifecycle(reader, "stop"));
                            break block5;
                        }
                        case DESTROY: {
                            beanConfig.setDestroy(this.parseLifecycle(reader, "destroy"));
                            break block5;
                        }
                        case UNKNOWN: {
                            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                        }
                    }
                }
            }
        }
        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
    }

    private String parseAlias(XMLExtendedStreamReader reader) throws XMLStreamException {
        String alias = this.parseTextElement(reader);
        if (alias == null || alias.trim().length() == 0) {
            throw PojoLogger.ROOT_LOGGER.nullOrEmptyAlias();
        }
        return alias;
    }

    private ConstructorConfig parseConstructor(XMLExtendedStreamReader reader) throws XMLStreamException {
        ConstructorConfig ctorConfig = new ConstructorConfig();
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeLocalName(i));
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case FACTORY_CLASS: 
                case FACTORY_CLASS_LEGACY: {
                    ctorConfig.setFactoryClass(attributeValue);
                    continue block12;
                }
                case FACTORY_METHOD: 
                case FACTORY_METHOD_LEGACY: {
                    ctorConfig.setFactoryMethod(attributeValue);
                    continue block12;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ArrayList<ValueConfig> parameters = new ArrayList<ValueConfig>();
        while (reader.hasNext()) {
            block4 : switch (reader.next()) {
                case 2: {
                    ctorConfig.setParameters(parameters.toArray(new ValueConfig[parameters.size()]));
                    return ctorConfig;
                }
                case 1: {
                    switch (Element.of(reader.getLocalName())) {
                        case FACTORY: {
                            ctorConfig.setFactory(this.parseFactory(reader));
                            break block4;
                        }
                        case PARAMETER: {
                            ValueConfig p = this.parseParameter(reader);
                            p.setIndex(parameters.size());
                            parameters.add(p);
                            break block4;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
    }

    private ModuleConfig parseModuleConfig(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModuleConfig moduleConfig = new ModuleConfig();
        int count = reader.getAttributeCount();
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        block3: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case NAME: {
                    moduleConfig.setModuleName(ModuleIdentifierUtil.canonicalModuleIdentifier((String)attributeValue));
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        return moduleConfig;
    }

    private PropertyConfig parseProperty(XMLExtendedStreamReader reader) throws XMLStreamException {
        PropertyConfig property = new PropertyConfig();
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block16: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case NAME: {
                    property.setPropertyName(attributeValue);
                    continue block16;
                }
                case CLASS: {
                    property.setType(attributeValue);
                    continue block16;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        while (reader.hasNext()) {
            block4 : switch (reader.next()) {
                case 2: {
                    return property;
                }
                case 1: {
                    switch (Element.of(reader.getLocalName())) {
                        case VALUE: {
                            property.setValue(this.parseValue(reader));
                            break block4;
                        }
                        case INJECT: {
                            property.setValue(this.parseInject(reader));
                            break block4;
                        }
                        case VALUE_FACTORY: {
                            property.setValue(this.parseValueFactory(reader));
                            break block4;
                        }
                        case LIST: {
                            property.setValue(this.parseList(reader));
                            break block4;
                        }
                        case SET: {
                            property.setValue(this.parseSet(reader));
                            break block4;
                        }
                        case MAP: {
                            property.setValue(this.parseMap(reader));
                            break block4;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
    }

    private InstallConfig parseInstall(XMLExtendedStreamReader reader) throws XMLStreamException {
        InstallConfig installConfig = new InstallConfig();
        EnumSet<Attribute> required = EnumSet.of(Attribute.METHOD);
        int count = reader.getAttributeCount();
        block13: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case STATE: {
                    installConfig.setWhenRequired(BeanState.valueOf(attributeValue.toUpperCase(Locale.ENGLISH)));
                    continue block13;
                }
                case TARGET_STATE: {
                    installConfig.setDependencyState(BeanState.valueOf(attributeValue.toUpperCase(Locale.ENGLISH)));
                    continue block13;
                }
                case BEAN: {
                    installConfig.setDependency(attributeValue);
                    continue block13;
                }
                case METHOD: {
                    installConfig.setMethodName(attributeValue);
                    continue block13;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ArrayList<ValueConfig> parameters = new ArrayList<ValueConfig>();
        while (reader.hasNext()) {
            block6 : switch (reader.next()) {
                case 2: {
                    installConfig.setParameters(parameters.toArray(new ValueConfig[parameters.size()]));
                    return installConfig;
                }
                case 1: {
                    switch (Element.of(reader.getLocalName())) {
                        case PARAMETER: {
                            ValueConfig p = this.parseParameter(reader);
                            p.setIndex(parameters.size());
                            parameters.add(p);
                            break block6;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
    }

    private CallbackConfig parseCallback(XMLExtendedStreamReader reader) throws XMLStreamException {
        CallbackConfig callbackConfig = new CallbackConfig();
        EnumSet<Attribute> required = EnumSet.of(Attribute.METHOD);
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case STATE: {
                    callbackConfig.setWhenRequired(BeanState.valueOf(attributeValue.toUpperCase(Locale.ENGLISH)));
                    continue block9;
                }
                case TARGET_STATE: {
                    callbackConfig.setState(BeanState.valueOf(attributeValue.toUpperCase(Locale.ENGLISH)));
                    continue block9;
                }
                case METHOD: {
                    callbackConfig.setMethodName(attributeValue);
                    continue block9;
                }
                case SIGNATURE: {
                    callbackConfig.setSignature(attributeValue);
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        while (reader.hasNext()) {
            switch (reader.next()) {
                case 2: {
                    return callbackConfig;
                }
            }
        }
        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
    }

    private DependsConfig parseDepends(XMLExtendedStreamReader reader) throws XMLStreamException {
        DependsConfig dependsConfig = new DependsConfig();
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeLocalName(i));
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case STATE: {
                    dependsConfig.setWhenRequired(BeanState.valueOf(attributeValue.toUpperCase(Locale.ENGLISH)));
                    continue block5;
                }
                case TARGET_STATE: {
                    dependsConfig.setDependencyState(BeanState.valueOf(attributeValue.toUpperCase(Locale.ENGLISH)));
                    continue block5;
                }
                case SERVICE: {
                    dependsConfig.setService(Boolean.parseBoolean(attributeValue));
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        String dependency = this.parseTextElement(reader);
        if (dependency == null || dependency.trim().length() == 0) {
            throw PojoLogger.ROOT_LOGGER.nullOrEmptyDependency();
        }
        dependsConfig.setDependency(dependency);
        return dependsConfig;
    }

    private LifecycleConfig parseLifecycle(XMLExtendedStreamReader reader, String defaultMethodName) throws XMLStreamException {
        LifecycleConfig lifecycleConfig = new LifecycleConfig();
        lifecycleConfig.setMethodName(defaultMethodName);
        int count = reader.getAttributeCount();
        block11: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeLocalName(i));
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case METHOD: {
                    lifecycleConfig.setMethodName(attributeValue);
                    continue block11;
                }
                case IGNORED: {
                    lifecycleConfig.setIgnored(Boolean.parseBoolean(attributeValue));
                    continue block11;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ArrayList<ValueConfig> parameters = new ArrayList<ValueConfig>();
        while (reader.hasNext()) {
            block4 : switch (reader.next()) {
                case 2: {
                    lifecycleConfig.setParameters(parameters.toArray(new ValueConfig[parameters.size()]));
                    return lifecycleConfig;
                }
                case 1: {
                    switch (Element.of(reader.getLocalName())) {
                        case PARAMETER: {
                            ValueConfig p = this.parseParameter(reader);
                            p.setIndex(parameters.size());
                            parameters.add(p);
                            break block4;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
    }

    private ValueConfig parseParameter(XMLExtendedStreamReader reader) throws XMLStreamException {
        ValueConfig valueConfig = null;
        String type = null;
        int count = reader.getAttributeCount();
        block16: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeLocalName(i));
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case CLASS: {
                    type = attributeValue;
                    continue block16;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        while (reader.hasNext()) {
            block3 : switch (reader.next()) {
                case 4: {
                    StringValueConfig svc = new StringValueConfig();
                    svc.setValue(reader.getText());
                    valueConfig = svc;
                    break;
                }
                case 2: {
                    if (valueConfig == null) {
                        throw new XMLStreamException(PojoLogger.ROOT_LOGGER.missingValue(), reader.getLocation());
                    }
                    if (valueConfig.getType() == null) {
                        valueConfig.setType(type);
                    }
                    return valueConfig;
                }
                case 1: {
                    switch (Element.of(reader.getLocalName())) {
                        case VALUE: {
                            valueConfig = this.parseValue(reader);
                            break block3;
                        }
                        case INJECT: {
                            valueConfig = this.parseInject(reader);
                            break block3;
                        }
                        case VALUE_FACTORY: {
                            valueConfig = this.parseValueFactory(reader);
                            break block3;
                        }
                        case LIST: {
                            valueConfig = this.parseList(reader);
                            break block3;
                        }
                        case SET: {
                            valueConfig = this.parseSet(reader);
                            break block3;
                        }
                        case MAP: {
                            valueConfig = this.parseMap(reader);
                            break block3;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
    }

    private InjectedValueConfig parseInject(XMLExtendedStreamReader reader) throws XMLStreamException {
        InjectedValueConfig injectedValueConfig = new InjectedValueConfig();
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeLocalName(i));
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case BEAN: {
                    injectedValueConfig.setBean(attributeValue);
                    continue block9;
                }
                case STATE: {
                    injectedValueConfig.setState(BeanState.valueOf(attributeValue.toUpperCase(Locale.ENGLISH)));
                    continue block9;
                }
                case SERVICE: {
                    injectedValueConfig.setService(attributeValue);
                    continue block9;
                }
                case PROPERTY: {
                    injectedValueConfig.setProperty(attributeValue);
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        while (reader.hasNext()) {
            switch (reader.next()) {
                case 2: {
                    return injectedValueConfig;
                }
            }
        }
        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
    }

    private FactoryConfig parseFactory(XMLExtendedStreamReader reader) throws XMLStreamException {
        FactoryConfig factoryConfig = new FactoryConfig();
        EnumSet<Attribute> required = EnumSet.of(Attribute.BEAN);
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case BEAN: {
                    factoryConfig.setBean(attributeValue);
                    continue block7;
                }
                case STATE: {
                    factoryConfig.setState(BeanState.valueOf(attributeValue.toUpperCase(Locale.ENGLISH)));
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        while (reader.hasNext()) {
            switch (reader.next()) {
                case 2: {
                    return factoryConfig;
                }
            }
        }
        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
    }

    private ValueConfig parseList(XMLExtendedStreamReader reader) throws XMLStreamException {
        return this.parseCollection(reader, new ListConfig());
    }

    private ValueConfig parseSet(XMLExtendedStreamReader reader) throws XMLStreamException {
        return this.parseCollection(reader, new SetConfig());
    }

    private ValueConfig parseCollection(XMLExtendedStreamReader reader, CollectionConfig config) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block16: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeLocalName(i));
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case CLASS: {
                    config.setType(attributeValue);
                    continue block16;
                }
                case ELEMENT: {
                    config.setElementType(attributeValue);
                    continue block16;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        while (reader.hasNext()) {
            block4 : switch (reader.next()) {
                case 2: {
                    return config;
                }
                case 1: {
                    switch (Element.of(reader.getLocalName())) {
                        case VALUE: {
                            config.addValue(this.parseValue(reader));
                            break block4;
                        }
                        case INJECT: {
                            config.addValue(this.parseInject(reader));
                            break block4;
                        }
                        case VALUE_FACTORY: {
                            config.addValue(this.parseValueFactory(reader));
                            break block4;
                        }
                        case LIST: {
                            config.addValue(this.parseList(reader));
                            break block4;
                        }
                        case SET: {
                            config.addValue(this.parseSet(reader));
                            break block4;
                        }
                        case MAP: {
                            config.addValue(this.parseMap(reader));
                            break block4;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
    }

    private ValueConfig parseMap(XMLExtendedStreamReader reader) throws XMLStreamException {
        MapConfig mapConfig = new MapConfig();
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeLocalName(i));
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case CLASS: {
                    mapConfig.setType(attributeValue);
                    continue block12;
                }
                case KEY_ELEMENT: {
                    mapConfig.setKeyType(attributeValue);
                    continue block12;
                }
                case VALUE_ELEMENT: {
                    mapConfig.setValueType(attributeValue);
                    continue block12;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        while (reader.hasNext()) {
            block5 : switch (reader.next()) {
                case 2: {
                    return mapConfig;
                }
                case 1: {
                    switch (Element.of(reader.getLocalName())) {
                        case ENTRY: {
                            ValueConfig[] entry = this.parseEntry(reader);
                            mapConfig.put(entry[0], entry[1]);
                            break block5;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
    }

    private ValueConfig[] parseEntry(XMLExtendedStreamReader reader) throws XMLStreamException {
        ValueConfig[] entry = new ValueConfig[2];
        while (reader.hasNext()) {
            block0 : switch (reader.next()) {
                case 2: {
                    return entry;
                }
                case 1: {
                    switch (Element.of(reader.getLocalName())) {
                        case KEY: {
                            entry[0] = this.parseValueValue(reader);
                            break block0;
                        }
                        case VALUE: {
                            entry[1] = this.parseValueValue(reader);
                            break block0;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
    }

    private ValueConfig parseValueValue(XMLExtendedStreamReader reader) throws XMLStreamException {
        ValueConfig value = null;
        while (reader.hasNext()) {
            block0 : switch (reader.next()) {
                case 2: {
                    if (value == null) {
                        throw new XMLStreamException(PojoLogger.ROOT_LOGGER.missingValue(), reader.getLocation());
                    }
                    return value;
                }
                case 1: {
                    switch (Element.of(reader.getLocalName())) {
                        case VALUE: {
                            value = this.parseValue(reader);
                            break block0;
                        }
                        case INJECT: {
                            value = this.parseInject(reader);
                            break block0;
                        }
                        case VALUE_FACTORY: {
                            value = this.parseValueFactory(reader);
                            break block0;
                        }
                        case LIST: {
                            value = this.parseList(reader);
                            break block0;
                        }
                        case SET: {
                            value = this.parseSet(reader);
                            break block0;
                        }
                        case MAP: {
                            value = this.parseMap(reader);
                            break block0;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                case 4: {
                    StringValueConfig svc = new StringValueConfig();
                    svc.setValue(reader.getText());
                    value = svc;
                }
            }
        }
        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
    }

    private ValueFactoryConfig parseValueFactory(XMLExtendedStreamReader reader) throws XMLStreamException {
        ValueFactoryConfig valueFactoryConfig = new ValueFactoryConfig();
        EnumSet<Attribute> required = EnumSet.of(Attribute.BEAN, Attribute.METHOD);
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case BEAN: {
                    valueFactoryConfig.setBean(attributeValue);
                    continue block12;
                }
                case METHOD: {
                    valueFactoryConfig.setMethod(attributeValue);
                    continue block12;
                }
                case STATE: {
                    valueFactoryConfig.setState(BeanState.valueOf(attributeValue.toUpperCase(Locale.ENGLISH)));
                    continue block12;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ArrayList<ValueConfig> parameters = new ArrayList<ValueConfig>();
        while (reader.hasNext()) {
            block5 : switch (reader.next()) {
                case 2: {
                    valueFactoryConfig.setParameters(parameters.toArray(new ValueConfig[parameters.size()]));
                    return valueFactoryConfig;
                }
                case 1: {
                    switch (Element.of(reader.getLocalName())) {
                        case PARAMETER: {
                            ValueConfig p = this.parseParameter(reader);
                            p.setIndex(parameters.size());
                            parameters.add(p);
                            break block5;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
    }

    private ValueConfig parseValue(XMLExtendedStreamReader reader) throws XMLStreamException {
        StringValueConfig valueConfig = new StringValueConfig();
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeLocalName(i));
            String attributeValue = reader.getAttributeValue(i);
            switch (attribute) {
                case CLASS: {
                    valueConfig.setType(attributeValue);
                    continue block5;
                }
                case REPLACE: {
                    valueConfig.setReplaceProperties(Boolean.parseBoolean(attributeValue));
                    continue block5;
                }
                case TRIM: {
                    valueConfig.setTrim(Boolean.parseBoolean(attributeValue));
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        valueConfig.setValue(this.parseTextElement(reader));
        return valueConfig;
    }

    private String parseTextElement(XMLExtendedStreamReader reader) throws XMLStreamException {
        String value = null;
        block4: while (reader.hasNext()) {
            switch (reader.next()) {
                case 2: {
                    return value;
                }
                case 4: {
                    value = reader.getText();
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
    }

    private static enum Attribute {
        MODE("mode"),
        NAME("name"),
        TYPE("type"),
        VALUE("value"),
        TRIM("trim"),
        REPLACE("replace"),
        BEAN("bean"),
        SERVICE("service"),
        PROPERTY("property"),
        CLASS("class"),
        ELEMENT("elementClass"),
        KEY_ELEMENT("keyClass"),
        VALUE_ELEMENT("valueClass"),
        METHOD("method"),
        IGNORED("ignored"),
        SIGNATURE("signature"),
        FACTORY_CLASS("factory-class"),
        FACTORY_METHOD("factory-method"),
        FACTORY_CLASS_LEGACY("factoryClass"),
        FACTORY_METHOD_LEGACY("factoryMethod"),
        STATE("state"),
        TARGET_STATE("targetState"),
        UNKNOWN(null);

        private final String localPart;
        private static final Map<String, Attribute> QNAME_MAP;

        private Attribute(String localPart) {
            this.localPart = localPart;
        }

        static Attribute of(String localPart) {
            Attribute attribute = QNAME_MAP.get(localPart);
            return attribute == null ? UNKNOWN : attribute;
        }

        static {
            QNAME_MAP = new HashMap<String, Attribute>();
            for (Attribute attribute : Attribute.values()) {
                QNAME_MAP.put(attribute.localPart, attribute);
            }
        }
    }

    private static enum Element {
        BEAN("bean"),
        BEAN_FACTORY("bean-factory"),
        CLASSLOADER("classloader"),
        CONSTRUCTOR("constructor"),
        FACTORY("factory"),
        PROPERTY("property"),
        VALUE("value"),
        INJECT("inject"),
        VALUE_FACTORY("value-factory"),
        PARAMETER("parameter"),
        DEPENDS("depends"),
        ALIAS("alias"),
        ANNOTATION("annotation"),
        CREATE("create"),
        START("start"),
        STOP("stop"),
        DESTROY("destroy"),
        INSTALL("install"),
        UNINSTALL("uninstall"),
        INCALLBACK("incallback"),
        UNCALLBACK("uncallback"),
        LIST("list"),
        SET("set"),
        MAP("map"),
        ENTRY("entry"),
        KEY("key"),
        UNKNOWN(null);

        private final String localPart;
        private static final Map<String, Element> QNAME_MAP;

        private Element(String localPart) {
            this.localPart = localPart;
        }

        static Element of(String localPart) {
            Element element = QNAME_MAP.get(localPart);
            return element == null ? UNKNOWN : element;
        }

        static {
            QNAME_MAP = new HashMap<String, Element>();
            for (Element element : Element.values()) {
                QNAME_MAP.put(element.localPart, element);
            }
        }
    }
}

