/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.netty.buffer;

import io.netty.buffer.AbstractByteBufAllocator;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.internal.PlatformDependent;
import org.xnio.ByteBufferSlicePool;
import org.xnio.netty.buffer.XnioDirectByteBuf;
import org.xnio.netty.buffer.XnioHeapByteBuf;
import org.xnio.netty.buffer.XnioUnsafeDirectByteBuf;

public final class XnioByteBufAllocator
extends AbstractByteBufAllocator {
    final ByteBufferSlicePool pool;

    public XnioByteBufAllocator(ByteBufferSlicePool pool) {
        if (pool == null) {
            throw new NullPointerException("pool");
        }
        this.pool = pool;
    }

    protected ByteBuf newHeapBuffer(int initialCapacity, int maxCapacity) {
        return new XnioHeapByteBuf((ByteBufAllocator)this, initialCapacity, maxCapacity);
    }

    protected ByteBuf newDirectBuffer(int initialCapacity, int maxCapacity) {
        if (PlatformDependent.hasUnsafe()) {
            return new XnioUnsafeDirectByteBuf(this, initialCapacity, maxCapacity);
        }
        return new XnioDirectByteBuf((ByteBufAllocator)this, initialCapacity, maxCapacity);
    }

    public boolean isDirectBufferPooled() {
        return true;
    }
}

