/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.web;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Consumer;
import org.jboss.as.clustering.controller.DefaultSubsystemDescribeHandler;
import org.jboss.as.clustering.controller.DeploymentChainContributingResourceRegistrar;
import org.jboss.as.clustering.controller.ManagementResourceRegistration;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.SubsystemRegistration;
import org.jboss.as.clustering.controller.SubsystemResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.jbossallxml.JBossAllSchema;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.clustering.web.service.session.DistributableSessionManagementProvider;
import org.wildfly.clustering.web.service.user.DistributableUserManagementProvider;
import org.wildfly.extension.clustering.web.DistributableWebExtension;
import org.wildfly.extension.clustering.web.HotRodSessionManagementResourceDefinition;
import org.wildfly.extension.clustering.web.HotRodUserManagementResourceDefinition;
import org.wildfly.extension.clustering.web.InfinispanRoutingProviderResourceDefinition;
import org.wildfly.extension.clustering.web.InfinispanSessionManagementResourceDefinition;
import org.wildfly.extension.clustering.web.InfinispanUserManagementResourceDefinition;
import org.wildfly.extension.clustering.web.LocalRoutingProviderResourceDefinition;
import org.wildfly.extension.clustering.web.deployment.DistributableWebDeploymentDependencyProcessor;
import org.wildfly.extension.clustering.web.deployment.DistributableWebDeploymentParsingProcessor;
import org.wildfly.extension.clustering.web.deployment.DistributableWebDeploymentProcessor;
import org.wildfly.extension.clustering.web.deployment.DistributableWebDeploymentSchema;
import org.wildfly.service.descriptor.NullaryServiceDescriptor;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.capability.CapabilityReferenceRecorder;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public class DistributableWebResourceDefinition
extends SubsystemResourceDefinition
implements Consumer<DeploymentProcessorTarget>,
ResourceServiceConfigurator {
    static final PathElement PATH = DistributableWebResourceDefinition.pathElement((String)"distributable-web");
    static final RuntimeCapability<Void> DEFAULT_SESSION_MANAGEMENT_PROVIDER = RuntimeCapability.Builder.of((NullaryServiceDescriptor)DistributableSessionManagementProvider.DEFAULT_SERVICE_DESCRIPTOR).build();
    static final RuntimeCapability<Void> DEFAULT_SSO_MANAGEMENT_PROVIDER = RuntimeCapability.Builder.of((NullaryServiceDescriptor)DistributableUserManagementProvider.DEFAULT_SERVICE_DESCRIPTOR).build();

    DistributableWebResourceDefinition() {
        super(PATH, (ResourceDescriptionResolver)DistributableWebExtension.SUBSYSTEM_RESOLVER);
    }

    public void register(SubsystemRegistration parent) {
        ManagementResourceRegistration registration = parent.registerSubsystemModel((ResourceDefinition)this);
        new DefaultSubsystemDescribeHandler().register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        ResourceDescriptor descriptor = new ResourceDescriptor(this.getResourceDescriptionResolver()).addAttributes(Attribute.class).addCapabilities(List.of(DEFAULT_SESSION_MANAGEMENT_PROVIDER, DEFAULT_SSO_MANAGEMENT_PROVIDER)).addRequiredSingletonChildren(new PathElement[]{LocalRoutingProviderResourceDefinition.PATH});
        ResourceServiceHandler handler = ResourceServiceHandler.of((ResourceOperationRuntimeHandler[])new ResourceOperationRuntimeHandler[]{ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)this)});
        new DeploymentChainContributingResourceRegistrar(descriptor, handler, (Consumer)this).register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        new LocalRoutingProviderResourceDefinition().register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        new InfinispanRoutingProviderResourceDefinition().register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        new InfinispanSessionManagementResourceDefinition().register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        new InfinispanUserManagementResourceDefinition().register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        new HotRodSessionManagementResourceDefinition().register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        new HotRodUserManagementResourceDefinition().register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
    }

    @Override
    public void accept(DeploymentProcessorTarget target) {
        target.addDeploymentProcessor("distributable-web", Phase.STRUCTURE, 2589, JBossAllSchema.createDeploymentUnitProcessor(EnumSet.allOf(DistributableWebDeploymentSchema.class), DistributableWebDeploymentDependencyProcessor.CONFIGURATION_KEY));
        target.addDeploymentProcessor("distributable-web", Phase.PARSE, 19201, (DeploymentUnitProcessor)new DistributableWebDeploymentParsingProcessor());
        target.addDeploymentProcessor("distributable-web", Phase.DEPENDENCIES, 288, (DeploymentUnitProcessor)new DistributableWebDeploymentDependencyProcessor());
        target.addDeploymentProcessor("distributable-web", Phase.CONFIGURE_MODULE, 400, (DeploymentUnitProcessor)new DistributableWebDeploymentProcessor());
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        String defaultSessionManagement = Attribute.DEFAULT_SESSION_MANAGEMENT.resolveModelAttribute((ExpressionResolver)context, model).asString();
        String defaultSSOManagement = Attribute.DEFAULT_SSO_MANAGEMENT.resolveModelAttribute((ExpressionResolver)context, model).asString();
        return ResourceServiceInstaller.combine((ResourceServiceInstaller[])new ResourceServiceInstaller[]{(ResourceServiceInstaller)CapabilityServiceInstaller.builder(DEFAULT_SESSION_MANAGEMENT_PROVIDER, (ServiceDependency)ServiceDependency.on((UnaryServiceDescriptor)DistributableSessionManagementProvider.SERVICE_DESCRIPTOR, (String)defaultSessionManagement)).build(), (ResourceServiceInstaller)CapabilityServiceInstaller.builder(DEFAULT_SSO_MANAGEMENT_PROVIDER, (ServiceDependency)ServiceDependency.on((UnaryServiceDescriptor)DistributableUserManagementProvider.SERVICE_DESCRIPTOR, (String)defaultSSOManagement)).build()});
    }

    static enum Attribute implements org.jboss.as.clustering.controller.Attribute
    {
        DEFAULT_SESSION_MANAGEMENT("default-session-management", ModelType.STRING, CapabilityReferenceRecorder.builder(DEFAULT_SESSION_MANAGEMENT_PROVIDER, (UnaryServiceDescriptor)DistributableSessionManagementProvider.SERVICE_DESCRIPTOR).build()),
        DEFAULT_SSO_MANAGEMENT("default-single-sign-on-management", ModelType.STRING, CapabilityReferenceRecorder.builder(DEFAULT_SSO_MANAGEMENT_PROVIDER, (UnaryServiceDescriptor)DistributableUserManagementProvider.SERVICE_DESCRIPTOR).build());

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type, CapabilityReferenceRecorder<?> reference) {
            this.definition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(false)).setRequired(true)).setCapabilityReference(reference)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }
}

