/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jboss.ws.common.utils.DelegateClassLoader;

public class JAXPDelegateClassLoader
extends DelegateClassLoader {
    private final ClassLoader delegate;
    private final ClassLoader parent;
    private static Set<String> skipSps = new HashSet<String>(Arrays.asList("META-INF/services/javax.xml.parsers.DocumentBuilderFactory", "META-INF/services/javax.xml.parsers.SAXParserFactory", "META-INF/services/javax.xml.validation.SchemaFactory", "META-INF/services/javax.xml.stream.XMLEventFactory", "META-INF/services/javax.xml.datatype.DatatypeFactory", "META-INF/services/javax.xml.transform.TransformerFactory", "META-INF/services/javax.xml.xpath.XPathFactory"));

    public JAXPDelegateClassLoader(ClassLoader delegate, ClassLoader parent) {
        super(delegate, parent);
        this.delegate = delegate;
        this.parent = parent;
    }

    public URL getResource(String name) {
        URL url = null;
        if (this.parent != null) {
            url = this.parent.getResource(name);
        }
        return url == null && !skipSps.contains(name) ? this.delegate.getResource(name) : url;
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        final ArrayList<Enumeration<URL>> foundResources = new ArrayList<Enumeration<URL>>();
        if (!skipSps.contains(name)) {
            foundResources.add(this.delegate.getResources(name));
        }
        if (this.parent != null) {
            foundResources.add(this.parent.getResources(name));
        }
        return new Enumeration<URL>(){
            private int position;
            {
                this.position = foundResources.size() - 1;
            }

            @Override
            public boolean hasMoreElements() {
                while (this.position >= 0) {
                    if (((Enumeration)foundResources.get(this.position)).hasMoreElements()) {
                        return true;
                    }
                    --this.position;
                }
                return false;
            }

            @Override
            public URL nextElement() {
                while (this.position >= 0) {
                    try {
                        return (URL)((Enumeration)foundResources.get(this.position)).nextElement();
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        --this.position;
                    }
                }
                throw new NoSuchElementException();
            }
        };
    }

    public InputStream getResourceAsStream(String name) {
        InputStream is = null;
        if (this.parent != null) {
            is = this.parent.getResourceAsStream(name);
        }
        return is == null && !skipSps.contains(name) ? this.delegate.getResourceAsStream(name) : is;
    }

    public ClassLoader getDelegate() {
        return this.delegate;
    }
}

