/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.bean;

import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.ExpirationConfiguration;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.eviction.EvictionStrategy;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.cache.CacheEntryCreator;
import org.wildfly.clustering.cache.CacheEntryMutatorFactory;
import org.wildfly.clustering.cache.CacheEntryRemover;
import org.wildfly.clustering.cache.CacheProperties;
import org.wildfly.clustering.cache.infinispan.embedded.EmbeddedCacheConfiguration;
import org.wildfly.clustering.cache.infinispan.embedded.container.DataContainerConfigurationBuilder;
import org.wildfly.clustering.ejb.DeploymentConfiguration;
import org.wildfly.clustering.ejb.bean.BeanConfiguration;
import org.wildfly.clustering.ejb.bean.BeanDeploymentConfiguration;
import org.wildfly.clustering.ejb.bean.BeanInstance;
import org.wildfly.clustering.ejb.bean.BeanManagementConfiguration;
import org.wildfly.clustering.ejb.bean.BeanManagementProvider;
import org.wildfly.clustering.ejb.bean.BeanPassivationConfiguration;
import org.wildfly.clustering.ejb.cache.bean.BeanGroupManager;
import org.wildfly.clustering.ejb.cache.bean.DefaultBeanGroupManager;
import org.wildfly.clustering.ejb.cache.bean.DefaultBeanGroupManagerConfiguration;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanGroupKey;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanGroupListener;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanGroupManager;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanManagerFactory;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanManagerFactoryConfiguration;
import org.wildfly.clustering.ejb.infinispan.logging.InfinispanEjbLogger;
import org.wildfly.clustering.infinispan.service.CacheServiceInstallerFactory;
import org.wildfly.clustering.infinispan.service.InfinispanServiceDescriptor;
import org.wildfly.clustering.infinispan.service.TemplateConfigurationServiceInstallerFactory;
import org.wildfly.clustering.marshalling.ByteBufferMarshalledValueFactory;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.MarshalledValue;
import org.wildfly.clustering.marshalling.MarshalledValueFactory;
import org.wildfly.clustering.server.Registration;
import org.wildfly.clustering.server.infinispan.dispatcher.CacheContainerCommandDispatcherFactory;
import org.wildfly.clustering.server.service.BinaryServiceConfiguration;
import org.wildfly.clustering.server.service.ClusteringServiceDescriptor;
import org.wildfly.common.function.Functions;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public class InfinispanBeanManagementProvider<K, V extends BeanInstance<K>>
implements BeanManagementProvider {
    private final String name;
    private final BeanManagementConfiguration configuration;
    private final BinaryServiceConfiguration cacheConfiguration;

    public InfinispanBeanManagementProvider(String name, BeanManagementConfiguration configuration, BinaryServiceConfiguration cacheConfiguration) {
        this.name = name;
        this.configuration = configuration;
        this.cacheConfiguration = cacheConfiguration;
    }

    public String getName() {
        return this.name;
    }

    public Iterable<ServiceInstaller> getDeploymentServiceInstallers(BeanDeploymentConfiguration deploymentConfiguration) {
        BinaryServiceConfiguration deploymentCacheConfiguration = this.cacheConfiguration.withChildName(deploymentConfiguration.getDeploymentName());
        Consumer<ConfigurationBuilder> configurator = builder -> {
            OptionalInt size;
            ExpirationConfiguration expiration = builder.expiration().create();
            if (expiration.lifespan() >= 0L || expiration.maxIdle() >= 0L) {
                builder.expiration().lifespan(-1L).maxIdle(-1L);
                InfinispanEjbLogger.ROOT_LOGGER.expirationDisabled(this.cacheConfiguration.getChildName());
            }
            EvictionStrategy strategy = (size = this.configuration.getMaxActiveBeans()).isPresent() ? EvictionStrategy.REMOVE : EvictionStrategy.MANUAL;
            builder.memory().storage(StorageType.HEAP).whenFull(strategy).maxCount((long)size.orElse(0));
            if (strategy.isEnabled()) {
                ((DataContainerConfigurationBuilder)builder.addModule(DataContainerConfigurationBuilder.class)).evictable(InfinispanBeanGroupKey.class::isInstance);
            }
        };
        ServiceInstaller cacheConfigurationInstaller = new TemplateConfigurationServiceInstallerFactory(configurator).apply(this.cacheConfiguration, deploymentCacheConfiguration);
        ServiceInstaller cacheInstaller = CacheServiceInstallerFactory.INSTANCE.apply(deploymentCacheConfiguration);
        final ByteBufferMarshaller marshaller = (ByteBufferMarshaller)this.configuration.getMarshallerFactory().apply(deploymentConfiguration);
        final ServiceDependency cache = deploymentCacheConfiguration.getServiceDependency(InfinispanServiceDescriptor.CACHE);
        final EmbeddedCacheConfiguration cacheConfiguration = new EmbeddedCacheConfiguration(){

            public <KK, VV> Cache<KK, VV> getCache() {
                return (Cache)cache.get();
            }
        };
        Supplier groupFactory = new Supplier<BeanGroupManager<K, V>>(){

            @Override
            public BeanGroupManager<K, V> get() {
                final InfinispanBeanGroupManager groupManager = new InfinispanBeanGroupManager(cacheConfiguration);
                DefaultBeanGroupManagerConfiguration groupManagerConfiguration = new DefaultBeanGroupManagerConfiguration<K, V, ByteBufferMarshaller>(){

                    public CacheEntryCreator<K, MarshalledValue<Map<K, V>, ByteBufferMarshaller>, MarshalledValue<Map<K, V>, ByteBufferMarshaller>> getCreator() {
                        return groupManager;
                    }

                    public CacheEntryRemover<K> getRemover() {
                        return groupManager;
                    }

                    public CacheEntryMutatorFactory<K, MarshalledValue<Map<K, V>, ByteBufferMarshaller>> getMutatorFactory() {
                        return groupManager;
                    }

                    public CacheProperties getCacheProperties() {
                        return cacheConfiguration.getCacheProperties();
                    }

                    public MarshalledValueFactory<ByteBufferMarshaller> getMarshalledValueFactory() {
                        return new ByteBufferMarshalledValueFactory(marshaller);
                    }
                };
                return new DefaultBeanGroupManager(groupManagerConfiguration);
            }
        };
        ServiceName groupManagerServiceName = this.getGroupManagerServiceName((DeploymentConfiguration)deploymentConfiguration);
        ServiceInstaller groupManagerInstaller = (ServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder((Supplier)groupFactory).provides(groupManagerServiceName)).requires((Consumer)cache)).build();
        Supplier<Registration> groupListener = new Supplier<Registration>(){

            @Override
            public Registration get() {
                return new InfinispanBeanGroupListener(cacheConfiguration, marshaller);
            }
        };
        ServiceInstaller groupListenerInstaller = (ServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder((Supplier)groupListener).onStop(Functions.closingConsumer())).requires((Consumer)ServiceDependency.on((ServiceName)groupManagerServiceName))).asPassive()).build();
        return List.of(cacheConfigurationInstaller, cacheInstaller, groupManagerInstaller, groupListenerInstaller);
    }

    public ServiceInstaller getBeanManagerFactoryServiceInstaller(ServiceName name, final BeanConfiguration beanConfiguration) {
        BinaryServiceConfiguration deploymentCacheConfiguration = this.cacheConfiguration.withChildName(beanConfiguration.getDeploymentName());
        final ServiceDependency cache = deploymentCacheConfiguration.getServiceDependency(InfinispanServiceDescriptor.CACHE);
        final ServiceDependency dispatcherFactory = deploymentCacheConfiguration.getServiceDependency(ClusteringServiceDescriptor.COMMAND_DISPATCHER_FACTORY).map(CacheContainerCommandDispatcherFactory.class::cast);
        final ServiceDependency beanGroupManager = ServiceDependency.on((ServiceName)this.getGroupManagerServiceName((DeploymentConfiguration)beanConfiguration));
        InfinispanBeanManagerFactoryConfiguration configuration = new InfinispanBeanManagerFactoryConfiguration<K, V>(){

            public BeanConfiguration getBeanConfiguration() {
                return beanConfiguration;
            }

            public <KK, VV> Cache<KK, VV> getCache() {
                return (Cache)cache.get();
            }

            public BeanPassivationConfiguration getPassivationConfiguration() {
                return InfinispanBeanManagementProvider.this.configuration;
            }

            @Override
            public CacheContainerCommandDispatcherFactory getCommandDispatcherFactory() {
                return (CacheContainerCommandDispatcherFactory)dispatcherFactory.get();
            }

            public BeanGroupManager<K, V> getBeanGroupManager() {
                return (BeanGroupManager)beanGroupManager.get();
            }
        };
        return (ServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder((Supplier)Functions.constantSupplier(new InfinispanBeanManagerFactory(configuration))).provides(name)).requires(List.of(cache, dispatcherFactory, beanGroupManager))).build();
    }

    private ServiceName getGroupManagerServiceName(DeploymentConfiguration config) {
        return config.getDeploymentServiceName().append(new String[]{this.name, "bean-group"});
    }
}

