/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp.paging;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpMaxReadPagingTest
extends AmqpClientTestSupport {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    protected void addConfiguration(ActiveMQServer server) {
        super.addConfiguration(server);
        Map addressesSettings = server.getConfiguration().getAddressSettings();
        ((AddressSettings)addressesSettings.get("#")).setMaxSizeMessages(1L).setMaxSizeBytes(100000L).setPageSizeBytes(10000).setMaxReadPageMessages(10).setMaxReadPageBytes(0xA00000);
        server.getConfiguration().setMessageExpiryScanPeriod(-1L);
    }

    @Test
    @Timeout(value=60L)
    public void testMaxReadPage() throws Exception {
        int MSG_SIZE = 1000;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < 1000; ++i) {
            builder.append('0');
        }
        String data = builder.toString();
        int MSG_COUNT = 100;
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        this.runAfter(connection::close);
        AmqpSession session = connection.createSession();
        Queue queue = this.server.locateQueue(this.getQueueName());
        Assertions.assertNotNull((Object)queue);
        queue.getPagingStore().startPaging();
        AmqpSender sender = session.createSender(this.getQueueName(), true);
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        receiver.setPresettle(true);
        for (int i = 0; i < 100; ++i) {
            AmqpMessage message = new AmqpMessage();
            message.setText(data);
            message.setDurable(true);
            sender.send(message);
        }
        sender.close();
        Wait.assertEquals((long)100L, () -> ((Queue)queue).getMessageCount());
        receiver.flow(100);
        Assertions.assertNotNull((Object)receiver.receive(10L, TimeUnit.SECONDS));
        if (receiver.getPrefetchSize() > 10) {
            logger.warn("Receiver has an unexpected size of {} elements on the client buffer", (Object)receiver.getPrefetchSize());
        }
        PagingStore pagingStore = this.server.getPagingManager().getPageStore(SimpleString.of((String)this.getQueueName()));
        Assertions.assertTrue((boolean)pagingStore.isPaging());
        Assertions.assertTrue((receiver.getPrefetchSize() <= 10 ? 1 : 0) != 0);
        Thread.sleep(500L);
        for (int i = 0; i < 99; ++i) {
            AmqpMessage message = receiver.receive(10L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)message);
            System.out.println("Received " + i);
            message.accept();
        }
        receiver.close();
        connection.close();
    }
}

