/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.crossprotocol;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.LinkedList;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.integration.openwire.OpenWireTestBase;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtendWith(value={ParameterizedTestExtension.class})
public class RequestReplyMultiProtocolTest
extends OpenWireTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    String protocolSender;
    String protocolConsumer;
    ConnectionFactory senderCF;
    ConnectionFactory consumerCF;
    private static final SimpleString queueName = SimpleString.of((String)"RequestReplyQueueTest");
    private static final SimpleString topicName = SimpleString.of((String)"RequestReplyTopicTest");
    private static final SimpleString replyQueue = SimpleString.of((String)"ReplyOnRequestReplyQueueTest");

    public RequestReplyMultiProtocolTest(String protocolSender, String protocolConsumer) {
        this.protocolSender = protocolSender;
        this.protocolConsumer = protocolConsumer;
    }

    @Parameters(name="senderProtocol={0},receiverProtocol={1}")
    public static Iterable<Object[]> data() {
        return Arrays.asList({"OPENWIRE", "OPENWIRE"}, {"OPENWIRE", "CORE"}, {"OPENWIRE", "AMQP"}, {"CORE", "OPENWIRE"}, {"CORE", "CORE"}, {"CORE", "AMQP"}, {"AMQP", "OPENWIRE"}, {"AMQP", "CORE"}, {"AMQP", "AMQP"});
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.senderCF = CFUtil.createConnectionFactory(this.protocolSender, "tcp://localhost:61616?wireFormat.cacheEnabled=true");
        this.consumerCF = CFUtil.createConnectionFactory(this.protocolConsumer, "tcp://localhost:61616?wireFormat.cacheEnabled=true");
        Wait.assertTrue(() -> ((ActiveMQServer)this.server).isStarted());
        Wait.assertTrue(() -> ((ActiveMQServer)this.server).isActive());
        this.server.createQueue(QueueConfiguration.of((SimpleString)queueName).setRoutingType(RoutingType.ANYCAST));
        this.server.createQueue(QueueConfiguration.of((SimpleString)replyQueue).setRoutingType(RoutingType.ANYCAST));
        AddressInfo info = new AddressInfo(topicName, RoutingType.MULTICAST);
        this.server.addAddressInfo(info);
    }

    @TestTemplate
    public void testReplyToUsingQueue() throws Throwable {
        this.testReplyTo(false);
    }

    @TestTemplate
    public void testReplyToUsingTopic() throws Throwable {
        this.testReplyTo(true);
    }

    private void testReplyTo(boolean useTopic) throws Throwable {
        Connection senderConn = this.senderCF.createConnection();
        Connection consumerConn = this.consumerCF.createConnection();
        consumerConn.setClientID("consumer");
        try {
            Session consumerSess = consumerConn.createSession(false, 1);
            Object consumerDestination = useTopic ? consumerSess.createTopic(topicName.toString()) : consumerSess.createQueue(queueName.toString());
            Object consumer = useTopic ? consumerSess.createDurableSubscriber(consumerDestination, "test") : consumerSess.createConsumer((Destination)consumerDestination);
            consumerConn.start();
            Session senderSess = senderConn.createSession(false, 1);
            LinkedList<Object> replyToDestinations = new LinkedList<Object>();
            replyToDestinations.add(senderSess.createQueue(replyQueue.toString()));
            replyToDestinations.add(senderSess.createTopic(topicName.toString()));
            replyToDestinations.add(senderSess.createTemporaryQueue());
            replyToDestinations.add(senderSess.createTemporaryTopic());
            Object senderDestination = useTopic ? senderSess.createTopic(topicName.toString()) : senderSess.createQueue(queueName.toString());
            MessageProducer sender = senderSess.createProducer((Destination)senderDestination);
            int i = 0;
            for (Destination destination : replyToDestinations) {
                TextMessage message = senderSess.createTextMessage("hello " + i++);
                message.setJMSReplyTo(destination);
                sender.send((Message)message);
            }
            i = 0;
            for (Destination destination : replyToDestinations) {
                TextMessage received = (TextMessage)consumer.receive(5000L);
                Assertions.assertNotNull((Object)received);
                logger.debug("Destination::{}", (Object)received.getJMSDestination());
                if (useTopic) {
                    Assertions.assertTrue((boolean)(received.getJMSDestination() instanceof Topic), (String)("JMSDestination type is " + received.getJMSDestination().getClass()));
                } else {
                    Assertions.assertTrue((boolean)(received.getJMSDestination() instanceof Queue), (String)("JMSDestination type is " + received.getJMSDestination().getClass()));
                }
                Assertions.assertNotNull((Object)received.getJMSReplyTo());
                Assertions.assertEquals((Object)("hello " + i++), (Object)received.getText());
                logger.debug("received {} and {}", (Object)received.getText(), (Object)received.getJMSReplyTo());
                if (destination instanceof Queue) {
                    Assertions.assertTrue((boolean)(received.getJMSReplyTo() instanceof Queue), (String)("Type is " + received.getJMSReplyTo().getClass().toString()));
                    Assertions.assertEquals((Object)((Queue)destination).getQueueName(), (Object)((Queue)received.getJMSReplyTo()).getQueueName());
                }
                if (destination instanceof Topic) {
                    Assertions.assertTrue((boolean)(received.getJMSReplyTo() instanceof Topic), (String)("Type is " + received.getJMSReplyTo().getClass().toString()));
                    Assertions.assertEquals((Object)((Topic)destination).getTopicName(), (Object)((Topic)received.getJMSReplyTo()).getTopicName());
                }
                if (destination instanceof TemporaryQueue) {
                    Assertions.assertTrue((boolean)(received.getJMSReplyTo() instanceof TemporaryQueue), (String)("Type is " + received.getJMSReplyTo().getClass().toString()));
                    Assertions.assertEquals((Object)((TemporaryQueue)destination).getQueueName(), (Object)((TemporaryQueue)received.getJMSReplyTo()).getQueueName());
                }
                if (!(destination instanceof TemporaryTopic)) continue;
                Assertions.assertTrue((boolean)(received.getJMSReplyTo() instanceof TemporaryTopic), (String)("Type is " + received.getJMSReplyTo().getClass().toString()));
                Assertions.assertEquals((Object)((TemporaryTopic)destination).getTopicName(), (Object)((TemporaryTopic)received.getJMSReplyTo()).getTopicName());
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            try {
                senderConn.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                consumerConn.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

