/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.cluster;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import java.util.Enumeration;
import java.util.Set;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQMessage;
import org.apache.activemq.artemis.tests.util.JMSClusteredTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TopicClusterTest
extends JMSClusteredTestBase {
    public static final String TOPIC = "jms.t1";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteTopicAfterClusteredSend() throws Exception {
        Connection conn1 = this.cf1.createConnection();
        conn1.setClientID("someClient1");
        Connection conn2 = this.cf2.createConnection();
        conn2.setClientID("someClient2");
        conn1.start();
        conn2.start();
        try {
            Topic topic1 = this.createTopic(TOPIC);
            Topic topic2 = (Topic)this.context1.lookup("topic/jms.t1");
            Session session1 = conn1.createSession(false, 1);
            Session session2 = conn2.createSession(false, 1);
            TopicSubscriber cons2 = session2.createDurableSubscriber(topic2, "sub2");
            Thread.sleep(500L);
            MessageProducer prod1 = session1.createProducer((Destination)topic1);
            prod1.setDeliveryMode(2);
            for (int i = 0; i < 2; ++i) {
                prod1.send((Message)session1.createTextMessage("someMessage"));
            }
            TextMessage received = (TextMessage)cons2.receive(5000L);
            Assertions.assertNotNull((Object)received);
            Assertions.assertEquals((Object)"someMessage", (Object)received.getText());
            cons2.close();
        }
        finally {
            conn1.close();
            conn2.close();
        }
        this.jmsServer1.destroyTopic(TOPIC);
        this.jmsServer2.destroyTopic(TOPIC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInternalPropertyNotExposed() throws Exception {
        Connection conn1 = this.cf1.createConnection();
        conn1.setClientID("someClient1");
        Connection conn2 = this.cf2.createConnection();
        conn2.setClientID("someClient2");
        conn1.start();
        conn2.start();
        try {
            int i;
            Topic topic1 = this.createTopic(TOPIC, true);
            Session session1 = conn1.createSession(false, 1);
            Session session2 = conn2.createSession(false, 1);
            MessageProducer prod1 = session1.createProducer((Destination)topic1);
            prod1.setDeliveryMode(2);
            TopicSubscriber cons1 = session1.createDurableSubscriber(topic1, "sub1");
            TopicSubscriber cons2 = session2.createDurableSubscriber(topic1, "sub2");
            this.waitForBindings(this.server1, TOPIC, true, 1, 1, 2000L);
            this.waitForBindings(this.server2, TOPIC, true, 1, 1, 2000L);
            this.waitForBindings(this.server1, TOPIC, false, 1, 1, 2000L);
            this.waitForBindings(this.server2, TOPIC, false, 1, 1, 2000L);
            boolean num = true;
            for (i = 0; i < 1; ++i) {
                prod1.send((Message)session1.createTextMessage("someMessage" + i));
            }
            for (i = 0; i < 1; ++i) {
                TextMessage m2 = (TextMessage)cons2.receive(5000L);
                Assertions.assertNotNull((Object)m2);
                TextMessage m1 = (TextMessage)cons1.receive(5000L);
                Assertions.assertNotNull((Object)m1);
                this.checkInternalProperty(new Message[]{m1, m2});
            }
        }
        finally {
            conn1.close();
            conn2.close();
            this.jmsServer1.destroyTopic(TOPIC);
            this.jmsServer2.destroyTopic(TOPIC);
        }
    }

    private void checkInternalProperty(Message ... msgs) throws Exception {
        boolean checked = false;
        for (Message m : msgs) {
            ActiveMQMessage hqMessage = (ActiveMQMessage)m;
            ClientMessage coreMessage = hqMessage.getCoreMessage();
            Set coreProps = coreMessage.getPropertyNames();
            boolean exist = false;
            for (SimpleString prop : coreProps) {
                if (!prop.startsWith(org.apache.activemq.artemis.api.core.Message.HDR_ROUTE_TO_IDS)) continue;
                exist = true;
                break;
            }
            if (!exist) continue;
            Enumeration enumProps = m.getPropertyNames();
            while (enumProps.hasMoreElements()) {
                String propName = (String)enumProps.nextElement();
                Assertions.assertFalse((boolean)propName.startsWith(org.apache.activemq.artemis.api.core.Message.HDR_ROUTE_TO_IDS.toString()), (String)("Shouldn't be in jms property: " + propName));
            }
            checked = true;
        }
        Assertions.assertTrue((boolean)checked);
    }
}

