/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt5;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.IntStream;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.tests.integration.mqtt5.MQTT5TestSupport;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.apache.activemq.artemis.utils.Wait;
import org.eclipse.paho.mqttv5.client.MqttCallback;
import org.eclipse.paho.mqttv5.client.MqttClient;
import org.eclipse.paho.mqttv5.common.MqttException;
import org.eclipse.paho.mqttv5.common.MqttMessage;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class MQTTRetainMessageManagerTest
extends MQTT5TestSupport {
    private MqttClient mqttPublisher;
    private MqttClient mqttConsumerBeforePublish;
    private MqttClient mqttConsumerAfterPublish;
    private MqttClient mqttConsumerAfterPublish2;
    private final AtomicInteger arrivedCountBeforePublish = new AtomicInteger();
    private final AtomicInteger arrivedCountAferPublish = new AtomicInteger();
    private final AtomicInteger arrivedCountAferPublish2 = new AtomicInteger();
    private final AtomicReference<MqttMessage> lastMessagePublished = new AtomicReference();
    private final AtomicReference<MqttMessage> lastMessageArrivedOnConsumerBeforePublish = new AtomicReference();
    private final AtomicReference<MqttMessage> lastMessageArrivedOnConsumerAfterPublish = new AtomicReference();
    private final AtomicReference<MqttMessage> lastMessageArrivedOnConsumerAfterPublish2 = new AtomicReference();
    private final String topic = "fact";
    private final int numberOfMessages = 1000;
    private final int numberOfTests = 10;

    @BeforeEach
    public void beforeEach() throws MqttException {
        this.mqttPublisher = this.createPahoClient("publisher");
        this.mqttPublisher.connect();
        MqttMessage clearRetainedMessage = new MqttMessage(new byte[0]);
        clearRetainedMessage.setRetained(true);
        clearRetainedMessage.setQos(1);
        this.mqttPublisher.publish("fact", clearRetainedMessage);
        this.arrivedCountBeforePublish.set(0);
        this.mqttConsumerBeforePublish = this.createPahoClient("consumer-before");
        this.mqttConsumerBeforePublish.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) {
                MQTTRetainMessageManagerTest.this.lastMessageArrivedOnConsumerBeforePublish.set(message);
                MQTTRetainMessageManagerTest.this.arrivedCountBeforePublish.incrementAndGet();
            }
        });
        this.mqttConsumerBeforePublish.connect();
        this.arrivedCountAferPublish.set(0);
        this.mqttConsumerAfterPublish = this.createPahoClient("consumer-after");
        this.mqttConsumerAfterPublish.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) {
                MQTTRetainMessageManagerTest.this.lastMessageArrivedOnConsumerAfterPublish.set(message);
                MQTTRetainMessageManagerTest.this.arrivedCountAferPublish.incrementAndGet();
            }
        });
        this.mqttConsumerAfterPublish.connect();
        this.arrivedCountAferPublish2.set(0);
        this.mqttConsumerAfterPublish2 = this.createPahoClient("consumer-after2");
        this.mqttConsumerAfterPublish2.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) {
                MQTTRetainMessageManagerTest.this.lastMessageArrivedOnConsumerAfterPublish2.set(message);
                MQTTRetainMessageManagerTest.this.arrivedCountAferPublish2.incrementAndGet();
            }
        });
        this.mqttConsumerAfterPublish2.connect();
    }

    @AfterEach
    public void afterEach() throws MqttException {
        this.mqttPublisher.disconnect();
        this.mqttPublisher.close();
        this.mqttConsumerBeforePublish.unsubscribe("fact");
        this.mqttConsumerBeforePublish.disconnect();
        this.mqttConsumerBeforePublish.close();
        this.mqttConsumerAfterPublish.unsubscribe("fact");
        this.mqttConsumerAfterPublish.disconnect();
        this.mqttConsumerAfterPublish.close();
        this.mqttConsumerAfterPublish2.unsubscribe("fact");
        this.mqttConsumerAfterPublish2.disconnect();
        this.mqttConsumerAfterPublish2.close();
    }

    @Test
    @Timeout(value=60L)
    public void testAtMostOnce() {
        IntStream.of(10).forEach(i -> this.test(0));
    }

    @Test
    @Timeout(value=60L)
    public void testAtLeastOnce() {
        IntStream.of(10).forEach(i -> this.test(1));
    }

    @Test
    @Timeout(value=60L)
    public void testExactlyOnce() {
        IntStream.of(10).forEach(i -> this.test(2));
    }

    private void test(int qos) {
        try {
            this.mqttConsumerBeforePublish.subscribe("fact", qos);
            for (int i = 0; i < 1000; ++i) {
                MqttMessage message = new MqttMessage();
                message.setQos(qos);
                message.setRetained(true);
                message.setPayload(RandomUtil.randomBytes((int)128));
                this.mqttPublisher.publish("fact", message);
                this.lastMessagePublished.set(message);
            }
            Wait.waitFor(() -> this.server.getAddressInfo(SimpleString.of((String)"fact")).getRoutedMessageCount() >= 1000L, (long)5000L, (long)100L);
            this.mqttConsumerAfterPublish.subscribe("fact", qos);
            this.mqttConsumerAfterPublish2.subscribe("fact", qos);
            Wait.waitFor(() -> this.lastMessageArrivedOnConsumerAfterPublish.get() != null, (long)5000L, (long)100L);
            Wait.waitFor(() -> this.lastMessageArrivedOnConsumerAfterPublish2.get() != null, (long)5000L, (long)100L);
            Assertions.assertEquals((int)1, (int)this.arrivedCountAferPublish.get());
            Assertions.assertArrayEquals((byte[])this.lastMessagePublished.get().getPayload(), (byte[])this.lastMessageArrivedOnConsumerBeforePublish.get().getPayload(), (String)String.format("\nMessage arrived on consumer subscribed before the publish is different from the last published message!\nPublished: %s\nArrived  : %s\n", new String(this.lastMessagePublished.get().getPayload()), new String(this.lastMessageArrivedOnConsumerAfterPublish.get().getPayload())));
            Assertions.assertArrayEquals((byte[])this.lastMessagePublished.get().getPayload(), (byte[])this.lastMessageArrivedOnConsumerAfterPublish.get().getPayload(), (String)String.format("\nMessage arrived on consumer subscribed after the publish is different from the last published message!\nPublished: %s\nArrived  : %s\n", new String(this.lastMessagePublished.get().getPayload()), new String(this.lastMessageArrivedOnConsumerAfterPublish.get().getPayload())));
            Assertions.assertArrayEquals((byte[])this.lastMessagePublished.get().getPayload(), (byte[])this.lastMessageArrivedOnConsumerAfterPublish2.get().getPayload(), (String)String.format("\nMessage arrived on consumer subscribed after the publish (2) is different from the last published message!\nPublished: %s\nArrived  : %s\n", new String(this.lastMessagePublished.get().getPayload()), new String(this.lastMessageArrivedOnConsumerAfterPublish.get().getPayload())));
        }
        catch (MqttException e) {
            Assertions.fail((String)e.getMessage());
        }
    }
}

