/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.util;

import java.util.HashSet;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.UUID;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UUIDGeneratorTest
extends ActiveMQTestBase {
    @Test
    public void testFromJavaUUID() throws Exception {
        java.util.UUID javaId = java.util.UUID.randomUUID();
        UUIDGenerator gen = UUIDGenerator.getInstance();
        UUID nativeId = gen.fromJavaUUID(javaId);
        Assertions.assertEquals((Object)javaId.toString(), (Object)nativeId.toString());
    }

    @Test
    public void testDifferentInTightLoop() throws Exception {
        UUIDGenerator gen = UUIDGenerator.getInstance();
        int numIterations = 10000;
        HashSet<UUID> uuidSet = new HashSet<UUID>();
        for (int i = 0; i < 10000; ++i) {
            UUID nativeId = gen.generateUUID();
            uuidSet.add(nativeId);
        }
        Assertions.assertEquals((int)10000, (int)uuidSet.size(), (String)"All there");
    }

    @Test
    public void testGetHardwareAddress() throws Exception {
        byte[] bytes = UUIDGenerator.getHardwareAddress();
        Assertions.assertNotNull((Object)bytes);
        Assertions.assertTrue((bytes.length == 6 ? (byte)1 : 0) != 0);
    }

    @Test
    public void testZeroPaddedBytes() throws Exception {
        Assertions.assertNull((Object)UUIDGenerator.getZeroPaddedSixBytes(null));
        Assertions.assertNull((Object)UUIDGenerator.getZeroPaddedSixBytes((byte[])new byte[0]));
        Assertions.assertNull((Object)UUIDGenerator.getZeroPaddedSixBytes((byte[])new byte[7]));
        byte[] fiveBytes = new byte[]{1, 2, 3, 4, 5};
        byte[] zeroPaddedFiveBytes = UUIDGenerator.getZeroPaddedSixBytes((byte[])fiveBytes);
        ActiveMQTestBase.assertEqualsByteArrays(new byte[]{1, 2, 3, 4, 5, 0}, zeroPaddedFiveBytes);
        byte[] fourBytes = new byte[]{1, 2, 3, 4};
        byte[] zeroPaddedFourBytes = UUIDGenerator.getZeroPaddedSixBytes((byte[])fourBytes);
        ActiveMQTestBase.assertEqualsByteArrays(new byte[]{1, 2, 3, 4, 0, 0}, zeroPaddedFourBytes);
        byte[] threeBytes = new byte[]{1, 2, 3};
        byte[] zeroPaddedThreeBytes = UUIDGenerator.getZeroPaddedSixBytes((byte[])threeBytes);
        ActiveMQTestBase.assertEqualsByteArrays(new byte[]{1, 2, 3, 0, 0, 0}, zeroPaddedThreeBytes);
    }
}

