/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp.client.sasl;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.security.sasl.SaslException;
import org.apache.activemq.transport.amqp.client.sasl.AbstractMechanism;
import org.apache.activemq.transport.amqp.client.sasl.Mechanism;

public class CramMD5Mechanism
extends AbstractMechanism {
    private static final String HMACMD5 = "HMACMD5";
    private boolean sentResponse;

    @Override
    public int getPriority() {
        return Mechanism.PRIORITY.HIGH.getValue();
    }

    @Override
    public String getName() {
        return "CRAM-MD5";
    }

    @Override
    public byte[] getInitialResponse() {
        return EMPTY;
    }

    @Override
    public byte[] getChallengeResponse(byte[] challenge) throws SaslException {
        if (!this.sentResponse && challenge != null && challenge.length != 0) {
            try {
                SecretKeySpec key = new SecretKeySpec(this.getPassword().getBytes(StandardCharsets.US_ASCII), HMACMD5);
                Mac mac = Mac.getInstance(HMACMD5);
                mac.init(key);
                byte[] bytes = mac.doFinal(challenge);
                StringBuffer hash = new StringBuffer(this.getUsername());
                hash.append(' ');
                for (byte b : bytes) {
                    String hex = Integer.toHexString(0xFF & b);
                    if (hex.length() == 1) {
                        hash.append('0');
                    }
                    hash.append(hex);
                }
                this.sentResponse = true;
                return hash.toString().getBytes(StandardCharsets.US_ASCII);
            }
            catch (InvalidKeyException e) {
                throw new SaslException("Unable to utilise key", e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new SaslException("Unable to utilise required algorithm", e);
            }
        }
        return EMPTY;
    }

    @Override
    public boolean isApplicable(String username, String password) {
        return username != null && username.length() > 0 && password != null && password.length() > 0;
    }
}

