/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.xml;

import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.FeatureRegistry;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.xml.QNameResolver;
import org.jboss.as.controller.xml.XMLAttribute;
import org.jboss.as.controller.xml.XMLCardinality;
import org.jboss.as.controller.xml.XMLContainer;
import org.jboss.as.controller.xml.XMLContent;
import org.jboss.as.controller.xml.XMLContentWriter;
import org.jboss.as.controller.xml.XMLElementReader;
import org.jboss.as.controller.xml.XMLParticle;
import org.jboss.as.version.Stability;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public interface XMLElement<RC, WC>
extends XMLContainer<RC, WC> {
    public QName getName();

    default public <R, W> XMLElement<R, W> map(Function<R, RC> readContextMapper, Function<W, WC> writeContentMapper) {
        return new DefaultXMLElement<R, W>(this.getName(), this.getCardinality(), this.getReader().map(readContextMapper), this.getWriter().map(writeContentMapper), this.getStability());
    }

    default public <R, W> XMLElement<R, W> withContext(Supplier<RC> readContextFactory, BiConsumer<R, RC> readContextConsumer, Function<W, WC> writeContentMapper) {
        return new DefaultXMLElement<R, W>(this.getName(), this.getCardinality(), this.getReader().withContext(readContextFactory, readContextConsumer), this.getWriter().map(writeContentMapper), this.getStability());
    }

    public static <RC, WC> XMLElement<RC, WC> ignore(final QName name, XMLCardinality cardinality) {
        XMLElementReader reader = new XMLElementReader<RC>(){

            public void readElement(XMLExtendedStreamReader reader, RC context) throws XMLStreamException {
                ControllerLogger.ROOT_LOGGER.elementIgnored(name);
                this.skipElement(reader);
            }

            private void skipElement(XMLExtendedStreamReader reader) throws XMLStreamException {
                while (reader.hasNext() && reader.nextTag() != 2) {
                    this.skipElement(reader);
                }
            }
        };
        return new DefaultXMLElement(name, cardinality, XMLElementReader.validate(name, reader), XMLContentWriter.empty(), Stability.DEFAULT);
    }

    public static class DefaultXMLElementWriter<RC, WC, CC>
    implements XMLContentWriter<WC> {
        private final QName name;
        private final XMLContentWriter<WC> attributesWriter;
        private final Function<WC, CC> childContentFactory;
        private final XMLContent<RC, CC> childContent;

        public DefaultXMLElementWriter(QName name, XMLContentWriter<WC> attributesWriter, Function<WC, CC> childContentFactory, XMLContent<RC, CC> childContent) {
            this.name = name;
            this.attributesWriter = attributesWriter;
            this.childContentFactory = childContentFactory;
            this.childContent = childContent;
        }

        public void writeContent(XMLExtendedStreamWriter writer, WC content) throws XMLStreamException {
            String namespaceURI = this.name.getNamespaceURI();
            writer.writeStartElement(namespaceURI, this.name.getLocalPart());
            if (writer.getNamespaceContext().getPrefix(namespaceURI) == null) {
                writer.setPrefix(this.name.getPrefix(), namespaceURI);
                writer.writeNamespace(this.name.getPrefix(), namespaceURI);
            }
            this.attributesWriter.writeContent(writer, content);
            this.childContent.writeContent(writer, this.childContentFactory.apply(content));
            writer.writeEndElement();
        }

        @Override
        public boolean isEmpty(WC content) {
            return this.attributesWriter.isEmpty(content) && this.childContent.isEmpty(this.childContentFactory.apply(content));
        }
    }

    public static class DefaultXMLElement<RC, WC>
    extends XMLParticle.DefaultXMLParticle<RC, WC>
    implements XMLElement<RC, WC> {
        private final QName name;

        protected DefaultXMLElement(QName name, XMLCardinality cardinality, XMLElementReader<RC> reader, XMLContentWriter<WC> writer, Stability stability) {
            super(cardinality, reader, writer, stability);
            this.name = name;
        }

        @Override
        public QName getName() {
            return this.name;
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof XMLElement)) {
                return false;
            }
            XMLElement element = (XMLElement)object;
            return this.getName().equals(element.getName());
        }

        public String toString() {
            return String.format("<xs:element name=\"%s\" %s/>", this.name.getLocalPart(), XMLCardinality.toString(this.getCardinality()));
        }
    }

    public static class DefaultBuilder<RC, WC>
    extends XMLContainer.AbstractBuilder<RC, WC, XMLElement<RC, WC>, Builder<RC, WC>>
    implements Builder<RC, WC>,
    FeatureRegistry {
        private final QName name;
        private final List<XMLAttribute<RC, WC>> attributes = new LinkedList<XMLAttribute<RC, WC>>();
        private final Stability stability;

        DefaultBuilder(QName name, Stability stability) {
            this.name = name;
            this.stability = stability;
        }

        @Override
        public Builder<RC, WC> addAttribute(XMLAttribute<RC, WC> attribute) {
            if (this.enables(attribute)) {
                this.attributes.add(attribute);
            }
            return this;
        }

        @Override
        protected Builder<RC, WC> builder() {
            return this;
        }

        @Override
        public XMLElement<RC, WC> build() {
            QName name = this.name;
            final TreeMap<QName, XMLAttribute<RC, WC>> attributes = new TreeMap<QName, XMLAttribute<RC, WC>>(QNameResolver.COMPARATOR);
            for (XMLAttribute<RC, WC> attribute : this.attributes) {
                attributes.put(attribute.getName(), attribute);
            }
            final XMLContent content = this.getContent();
            XMLElementReader reader = new XMLElementReader<RC>(){

                public void readElement(XMLExtendedStreamReader reader, RC context) throws XMLStreamException {
                    TreeMap remaining = new TreeMap(QNameResolver.COMPARATOR);
                    remaining.putAll(attributes);
                    for (int i = 0; i < reader.getAttributeCount(); ++i) {
                        XMLAttribute attribute;
                        QName attributeName = reader.getAttributeName(i);
                        if (attributeName.getNamespaceURI().equals("") && !reader.getName().getNamespaceURI().equals("")) {
                            attributeName = new QName(reader.getName().getNamespaceURI(), attributeName.getLocalPart());
                        }
                        if ((attribute = (XMLAttribute)remaining.remove(attributeName)) == null) {
                            if (attributes.containsKey(attributeName)) {
                                throw ParseUtils.duplicateAttribute(reader, attributeName.getLocalPart());
                            }
                            throw ParseUtils.unexpectedAttribute(reader, i, attributes.keySet());
                        }
                        if (!attribute.getUsage().isEnabled()) {
                            throw ParseUtils.unexpectedAttribute(reader, i);
                        }
                        attribute.getReader().readAttribute((XMLStreamReader)reader, i, context);
                    }
                    if (!remaining.isEmpty()) {
                        TreeSet<QName> missing = new TreeSet<QName>(QNameResolver.COMPARATOR);
                        for (XMLAttribute attribute : remaining.values()) {
                            if (attribute.getUsage().isRequired()) {
                                missing.add(attribute.getName());
                                continue;
                            }
                            attribute.getReader().whenAbsent(context);
                        }
                        if (!missing.isEmpty()) {
                            throw ParseUtils.missingRequired(reader, remaining.keySet());
                        }
                    }
                    content.readContent(reader, context);
                }
            };
            DefaultXMLElementWriter writer = new DefaultXMLElementWriter(name, XMLContentWriter.composite(attributes.values()), Function.identity(), content);
            return new DefaultXMLElement(this.name, this.getCardinality(), XMLElementReader.validate(name, reader), writer, this.stability);
        }

        @Override
        public Stability getStability() {
            return this.stability;
        }
    }

    public static interface Builder<RC, WC>
    extends XMLContainer.Builder<RC, WC, XMLElement<RC, WC>, Builder<RC, WC>> {
        public Builder<RC, WC> addAttribute(XMLAttribute<RC, WC> var1);

        default public Builder<RC, WC> addAttributes(Iterable<? extends XMLAttribute<RC, WC>> attributes) {
            for (XMLAttribute<RC, WC> attribute : attributes) {
                this.addAttribute(attribute);
            }
            return this;
        }
    }
}

