/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.federation;

import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederation;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationAsyncCompletion;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationConsumer;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationLocalPolicyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AMQPFederationConsumerManager {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final AMQPFederation federation;
    private final AMQPFederationLocalPolicyManager manager;
    private final Set<Object> demandTracking = new HashSet<Object>();
    private State state = State.READY;
    private AMQPFederationConsumer consumer;
    private ScheduledFuture<?> pendingIdleTimeout;

    public AMQPFederationConsumerManager(AMQPFederationLocalPolicyManager manager) {
        this.manager = manager;
        this.federation = manager.getFederation();
    }

    public void shutdown() {
        this.handleShutdown(true);
    }

    public void shutdownNow() {
        this.handleShutdown(false);
    }

    private void handleShutdown(boolean stopFirst) {
        if (this.state != State.CLOSED) {
            this.state = State.CLOSED;
            try {
                if (this.consumer == null) {
                    return;
                }
                if (stopFirst && this.state != State.STOPPED) {
                    this.tryStopFederationConsumer();
                } else {
                    this.safeCloseCurrentFederationConsumer();
                }
            }
            finally {
                this.consumer = null;
                if (this.pendingIdleTimeout != null) {
                    this.pendingIdleTimeout.cancel(false);
                    this.pendingIdleTimeout = null;
                }
            }
        }
    }

    public void recover() {
        this.checkClosed();
        if (this.hasDemand()) {
            if (this.state == State.STOPPED) {
                this.tryRestartFederationConsumer();
            } else if (this.state == State.READY) {
                this.tryCreateFederationConsumer();
            }
        }
    }

    public void addDemand(Object demand) {
        this.checkClosed();
        this.demandTracking.add(demand);
        if (this.state == State.STOPPED) {
            this.tryRestartFederationConsumer();
        } else if (this.state == State.READY) {
            this.tryCreateFederationConsumer();
        }
    }

    public void removeDemand(Object demand) {
        this.checkClosed();
        this.demandTracking.remove(demand);
        if (this.hasDemand() || this.state == State.READY) {
            return;
        }
        if (this.state != State.STOPPING) {
            this.tryStopFederationConsumer();
        }
    }

    private void tryCreateFederationConsumer() {
        if (!this.isPluginBlockingFederationConsumerCreate()) {
            this.state = State.STARTING;
            this.consumer = this.createFederationConsumer();
            logger.trace("Federation Consumer manager creating remote consumer for: {}", (Object)this.consumer.getConsumerInfo());
            this.manager.signalPluginBeforeCreateFederationConsumer(this.consumer.getConsumerInfo());
            this.consumer.setRemoteOpenHandler(openedConsumer -> {
                AMQPFederationLocalPolicyManager aMQPFederationLocalPolicyManager = this.manager;
                synchronized (aMQPFederationLocalPolicyManager) {
                    if (this.state == State.STARTING) {
                        this.state = State.STARTED;
                    }
                }
            });
            this.consumer.setRemoteClosedHandler(closedConsumer -> {
                AMQPFederationLocalPolicyManager aMQPFederationLocalPolicyManager = this.manager;
                synchronized (aMQPFederationLocalPolicyManager) {
                    this.safeCloseCurrentFederationConsumer();
                }
            });
            this.consumer.initialize();
            this.manager.signalPluginAfterCreateFederationConsumer(this.consumer);
        } else {
            this.state = State.READY;
        }
    }

    private void tryRestartFederationConsumer() {
        block3: {
            this.state = State.STARTING;
            try {
                if (this.pendingIdleTimeout != null) {
                    this.pendingIdleTimeout.cancel(false);
                    this.pendingIdleTimeout = null;
                }
                this.consumer.startAsync(new AMQPFederationAsyncCompletion<AMQPFederationConsumer>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onComplete(AMQPFederationConsumer consumer) {
                        logger.trace("Restarted federation consumer after new demand added.");
                        AMQPFederationLocalPolicyManager aMQPFederationLocalPolicyManager = AMQPFederationConsumerManager.this.manager;
                        synchronized (aMQPFederationLocalPolicyManager) {
                            if (AMQPFederationConsumerManager.this.state == State.STARTING) {
                                AMQPFederationConsumerManager.this.state = State.STARTED;
                            }
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onException(AMQPFederationConsumer consumer, Exception error) {
                        if (error instanceof IllegalStateException) {
                            return;
                        }
                        logger.trace("Start of federation consumer {} threw unexpected error, closing consumer: ", (Object)consumer, (Object)error);
                        AMQPFederationLocalPolicyManager aMQPFederationLocalPolicyManager = AMQPFederationConsumerManager.this.manager;
                        synchronized (aMQPFederationLocalPolicyManager) {
                            AMQPFederationConsumerManager.this.safeCloseCurrentFederationConsumer();
                        }
                    }
                });
            }
            catch (Exception ex) {
                logger.trace("Caught error on attempted restart of existing federation consumer", (Throwable)ex);
                this.safeCloseCurrentFederationConsumer();
                if (this.state != State.READY) break block3;
                this.tryCreateFederationConsumer();
            }
        }
    }

    private void tryStopFederationConsumer() {
        if (this.consumer != null && this.state != State.STOPPING) {
            this.state = this.state == State.CLOSED ? State.CLOSED : State.STOPPING;
            this.consumer.stopAsync(new AMQPFederationAsyncCompletion<AMQPFederationConsumer>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onComplete(AMQPFederationConsumer consumer) {
                    logger.trace("Stop of federation consumer {} succeeded, consumer: ", (Object)consumer);
                    AMQPFederationLocalPolicyManager aMQPFederationLocalPolicyManager = AMQPFederationConsumerManager.this.manager;
                    synchronized (aMQPFederationLocalPolicyManager) {
                        AMQPFederationConsumerManager.this.handleFederationConsumerStopped(consumer, true);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onException(AMQPFederationConsumer consumer, Exception error) {
                    logger.trace("Stop of federation consumer {} failed, closing consumer: ", (Object)consumer, (Object)error);
                    AMQPFederationLocalPolicyManager aMQPFederationLocalPolicyManager = AMQPFederationConsumerManager.this.manager;
                    synchronized (aMQPFederationLocalPolicyManager) {
                        AMQPFederationConsumerManager.this.handleFederationConsumerStopped(consumer, false);
                    }
                }
            });
        }
    }

    private void handleFederationConsumerStopped(AMQPFederationConsumer stoppedConsumer, boolean didStop) {
        if (this.state == State.STOPPING) {
            if (!didStop) {
                this.safeCloseCurrentFederationConsumer();
            } else {
                this.state = State.STOPPED;
            }
            if (this.state == State.READY) {
                if (this.hasDemand()) {
                    this.tryCreateFederationConsumer();
                }
            } else if (this.state == State.STOPPED) {
                if (this.hasDemand()) {
                    this.tryRestartFederationConsumer();
                } else if (this.consumer.getReceiverIdleTimeout() > 0) {
                    this.pendingIdleTimeout = this.federation.getScheduler().schedule(() -> {
                        AMQPFederationLocalPolicyManager aMQPFederationLocalPolicyManager = this.manager;
                        synchronized (aMQPFederationLocalPolicyManager) {
                            logger.debug("Federation consumer {} idle timeout reached, closing now", (Object)this.consumer.getConsumerInfo());
                            if (this.state == State.STOPPED) {
                                this.safeCloseCurrentFederationConsumer();
                                this.pendingIdleTimeout = null;
                            }
                        }
                    }, (long)this.consumer.getReceiverIdleTimeout(), TimeUnit.MILLISECONDS);
                } else {
                    this.safeCloseCurrentFederationConsumer();
                }
            }
        } else if (this.state == State.CLOSED) {
            this.safeCloseAnyFederationConsumer(stoppedConsumer);
        }
    }

    private void safeCloseCurrentFederationConsumer() {
        if (this.consumer != null) {
            try {
                this.safeCloseAnyFederationConsumer(this.consumer);
                State state = this.state = this.state == State.CLOSED ? State.CLOSED : State.READY;
            }
            catch (Throwable throwable) {
                State state = this.state = this.state == State.CLOSED ? State.CLOSED : State.READY;
                if (this.pendingIdleTimeout != null) {
                    this.pendingIdleTimeout.cancel(false);
                    this.pendingIdleTimeout = null;
                }
                throw throwable;
            }
            if (this.pendingIdleTimeout != null) {
                this.pendingIdleTimeout.cancel(false);
                this.pendingIdleTimeout = null;
            }
        }
    }

    private void safeCloseAnyFederationConsumer(AMQPFederationConsumer consumer) {
        if (consumer != null) {
            try {
                if (!consumer.isClosed()) {
                    this.manager.signalPluginBeforeCloseFederationConsumer(consumer);
                    consumer.close();
                    this.manager.signalPluginAfterCloseFederationConsumer(consumer);
                }
            }
            catch (Exception e) {
                logger.trace("Suppressed error on close of federation consumer. ", (Throwable)e);
            }
        }
    }

    private boolean hasDemand() {
        return !this.demandTracking.isEmpty();
    }

    private void checkClosed() {
        if (this.state == State.CLOSED) {
            throw new IllegalStateException("The federated consumer has been closed already");
        }
    }

    protected abstract AMQPFederationConsumer createFederationConsumer();

    protected abstract boolean isPluginBlockingFederationConsumerCreate();

    private static enum State {
        READY,
        STARTING,
        STARTED,
        STOPPING,
        STOPPED,
        CLOSED;

    }
}

