/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.instmgr;

import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.core.instmgr.InstMgrOperationStepHandler;
import org.wildfly.core.instmgr.InstMgrResolver;
import org.wildfly.core.instmgr.InstMgrService;
import org.wildfly.core.instmgr.logging.InstMgrLogger;
import org.wildfly.installationmanager.ArtifactChange;
import org.wildfly.installationmanager.Channel;
import org.wildfly.installationmanager.ChannelChange;
import org.wildfly.installationmanager.InstallationChanges;
import org.wildfly.installationmanager.MavenOptions;
import org.wildfly.installationmanager.Repository;
import org.wildfly.installationmanager.spi.InstallationManager;
import org.wildfly.installationmanager.spi.InstallationManagerFactory;

public class InstMgrHistoryRevisionHandler
extends InstMgrOperationStepHandler {
    public static final String OPERATION_NAME = "history-from-revision";
    private static final AttributeDefinition REVISION = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"revision", (ModelType)ModelType.STRING).setStorageRuntime()).build();
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("history-from-revision", InstMgrResolver.RESOLVER).addParameter(REVISION).withFlags(new OperationEntry.Flag[]{OperationEntry.Flag.HOST_CONTROLLER_ONLY}).setReplyType(ModelType.LIST).setRuntimeOnly().setReplyValueType(ModelType.OBJECT).build();

    InstMgrHistoryRevisionHandler(InstMgrService imService, InstallationManagerFactory imf) {
        super(imService, imf);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final String revision = REVISION.resolveModelAttribute(context, operation).asString();
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                try {
                    Path serverHome = InstMgrHistoryRevisionHandler.this.imService.getHomeDir();
                    MavenOptions mavenOptions = new MavenOptions(null, false);
                    InstallationManager installationManager = InstMgrHistoryRevisionHandler.this.imf.create(serverHome, mavenOptions);
                    ModelNode resulList = new ModelNode();
                    InstallationChanges changes = installationManager.revisionDetails(revision);
                    List artifactChanges = changes.artifactChanges();
                    List channelChanges = changes.channelChanges();
                    if (!artifactChanges.isEmpty()) {
                        for (ArtifactChange artifactChange : artifactChanges) {
                            ModelNode artifactChangeMn = new ModelNode();
                            artifactChangeMn.get("name").set(artifactChange.getArtifactName());
                            artifactChangeMn.get("status").set(artifactChange.getStatus().name().toLowerCase(Locale.ENGLISH));
                            switch (artifactChange.getStatus()) {
                                case REMOVED: {
                                    artifactChangeMn.get("old-version").set(artifactChange.getOldVersion());
                                    artifactChangeMn.get("new-version");
                                    break;
                                }
                                case INSTALLED: {
                                    artifactChangeMn.get("old-version");
                                    artifactChangeMn.get("new-version").set(artifactChange.getNewVersion());
                                    break;
                                }
                                case UPDATED: {
                                    artifactChangeMn.get("old-version").set(artifactChange.getOldVersion());
                                    artifactChangeMn.get("new-version").set(artifactChange.getNewVersion());
                                    break;
                                }
                                default: {
                                    throw InstMgrLogger.ROOT_LOGGER.unexpectedArtifactChange(artifactChange.toString());
                                }
                            }
                            resulList.get("artifact-changes").add(artifactChangeMn);
                        }
                    }
                    if (!channelChanges.isEmpty()) {
                        for (ChannelChange channelChange : channelChanges) {
                            ModelNode channelChangeMn = new ModelNode();
                            channelChangeMn.get("status").set(channelChange.getStatus().name().toLowerCase(Locale.ENGLISH));
                            switch (channelChange.getStatus()) {
                                case REMOVED: {
                                    ModelNode repositoryMn;
                                    ModelNode manifestMn;
                                    Channel channel = (Channel)channelChange.getOldChannel().get();
                                    channelChangeMn.get("channel-name").set(String.format(channel.getName(), new Object[0]));
                                    String manifest = InstMgrHistoryRevisionHandler.this.getManifest(channel);
                                    if (!"".equals(manifest)) {
                                        manifestMn = channelChangeMn.get("manifest");
                                        manifestMn.get("old-manifest").set(manifest);
                                        manifestMn.get("new-manifest");
                                    }
                                    ModelNode repositoriesMn = channelChangeMn.get("repositories");
                                    List repositories = channel.getRepositories();
                                    for (Repository repository : repositories) {
                                        repositoryMn = new ModelNode();
                                        repositoryMn.get("old-repository").set(repository.asFormattedString());
                                        repositoryMn.get("new-repository");
                                        repositoriesMn.add(repositoryMn);
                                    }
                                    break;
                                }
                                case ADDED: {
                                    ModelNode repositoryMn;
                                    ModelNode manifestMn;
                                    Channel channel = (Channel)channelChange.getNewChannel().get();
                                    channelChangeMn.get("channel-name").set(String.format(channel.getName(), new Object[0]));
                                    String manifest = InstMgrHistoryRevisionHandler.this.getManifest(channel);
                                    if (!"".equals(manifest)) {
                                        manifestMn = channelChangeMn.get("manifest");
                                        manifestMn.get("old-manifest");
                                        manifestMn.get("new-manifest").set(manifest);
                                    }
                                    ModelNode repositoriesMn = channelChangeMn.get("repositories");
                                    List repositories = channel.getRepositories();
                                    for (Repository repository : repositories) {
                                        repositoryMn = new ModelNode();
                                        repositoryMn.get("old-repository");
                                        repositoryMn.get("new-repository").set(repository.asFormattedString());
                                        repositoriesMn.add(repositoryMn);
                                    }
                                    break;
                                }
                                case MODIFIED: {
                                    ModelNode repositoryMn;
                                    Channel channel = (Channel)channelChange.getNewChannel().get();
                                    channelChangeMn.get("channel-name").set(String.format(channel.getName(), new Object[0]));
                                    Channel oldChannel = (Channel)channelChange.getOldChannel().get();
                                    Channel newChannel = (Channel)channelChange.getNewChannel().get();
                                    String oldManifest = InstMgrHistoryRevisionHandler.this.getManifest(oldChannel);
                                    String newManifest = InstMgrHistoryRevisionHandler.this.getManifest(newChannel);
                                    if (!"".equals(oldManifest) || !"".equals(newManifest)) {
                                        ModelNode manifestMn = channelChangeMn.get("manifest");
                                        ModelNode oldManifestMn = "".equals(oldManifest) ? new ModelNode() : new ModelNode(oldManifest);
                                        ModelNode newManifestMn = "".equals(newManifest) ? new ModelNode() : new ModelNode(newManifest);
                                        manifestMn.get("old-manifest").set(oldManifestMn);
                                        manifestMn.get("new-manifest").set(newManifestMn);
                                    }
                                    ModelNode repositoriesMn = channelChangeMn.get("repositories");
                                    ArrayList oldRepositoriesLst = new ArrayList(oldChannel.getRepositories());
                                    ArrayList newRepositoriesLst = new ArrayList(newChannel.getRepositories());
                                    Iterator newIt = newRepositoriesLst.iterator();
                                    Iterator oldIt = oldRepositoriesLst.iterator();
                                    while (oldIt.hasNext()) {
                                        repositoryMn = new ModelNode();
                                        Repository oldRepository = (Repository)oldIt.next();
                                        repositoryMn.get("old-repository").set(oldRepository.asFormattedString());
                                        oldIt.remove();
                                        if (newIt.hasNext()) {
                                            Repository newRepository = (Repository)newIt.next();
                                            repositoryMn.get("new-repository").set(newRepository.asFormattedString());
                                            newIt.remove();
                                        } else {
                                            repositoryMn.get("new-repository");
                                        }
                                        repositoriesMn.add(repositoryMn);
                                    }
                                    while (newIt.hasNext()) {
                                        repositoryMn = new ModelNode();
                                        Repository newRepository = (Repository)newIt.next();
                                        repositoryMn.get("new-repository").set(newRepository.asFormattedString());
                                        newIt.remove();
                                        if (oldIt.hasNext()) {
                                            Repository oldRepository = (Repository)oldIt.next();
                                            repositoryMn.get("old-repository").set(oldRepository.asFormattedString());
                                            oldIt.remove();
                                        } else {
                                            repositoryMn.get("old-repository");
                                        }
                                        repositoriesMn.add(repositoryMn);
                                    }
                                    break;
                                }
                                default: {
                                    throw InstMgrLogger.ROOT_LOGGER.unexpectedConfigurationChange(channelChange.toString());
                                }
                            }
                            resulList.get("channel-changes").add(channelChangeMn);
                        }
                    }
                    context.getResult().set(resulList);
                }
                catch (RuntimeException | OperationFailedException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, OperationContext.Stage.RUNTIME);
    }

    private String getManifest(Channel channel) {
        String manifest = "";
        if (channel.getManifestUrl().isPresent()) {
            manifest = ((URL)channel.getManifestUrl().get()).toString();
        } else if (channel.getManifestCoordinate().isPresent()) {
            manifest = (String)channel.getManifestCoordinate().get();
        }
        return manifest;
    }
}

