/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity.internal;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.EntityFilterException;
import org.hibernate.FetchNotFoundException;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.StaleObjectStateException;
import org.hibernate.WrongClassException;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.bytecode.enhance.spi.interceptor.EnhancementAsProxyLazinessInterceptor;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.CachedDomainDataAccess;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.entry.CacheEntry;
import org.hibernate.engine.internal.ForeignKeys;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityHolder;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.EntityUniqueKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SessionEventListenerManager;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.spi.EventManager;
import org.hibernate.event.spi.HibernateMonitoringEvent;
import org.hibernate.event.spi.PreLoadEvent;
import org.hibernate.event.spi.PreLoadEventListener;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.internal.util.ImmutableBitSet;
import org.hibernate.internal.util.NullnessUtil;
import org.hibernate.loader.ast.internal.CacheEntityLoaderHelper;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.AttributeMetadata;
import org.hibernate.metamodel.mapping.CompositeIdentifierMapping;
import org.hibernate.metamodel.mapping.DiscriminatorValueDetails;
import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.EntityVersionMapping;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.UniqueKeyEntry;
import org.hibernate.property.access.internal.PropertyAccessStrategyBackRefImpl;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.proxy.map.MapProxy;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.InitializerData;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.graph.basic.BasicResultAssembler;
import org.hibernate.sql.results.graph.collection.internal.AbstractImmediateCollectionInitializer;
import org.hibernate.sql.results.graph.embeddable.EmbeddableInitializer;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.entity.EntityResultGraphNode;
import org.hibernate.sql.results.graph.internal.AbstractInitializer;
import org.hibernate.sql.results.internal.NullValueAssembler;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.type.ManyToOneType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.MutabilityPlan;

public class EntityInitializerImpl
extends AbstractInitializer<EntityInitializerData>
implements EntityInitializer<EntityInitializerData> {
    private final EntityValuedModelPart referencedModelPart;
    private final EntityPersister entityDescriptor;
    private final EntityPersister rootEntityDescriptor;
    private final @Nullable Type keyTypeForEqualsHashCode;
    private final NavigablePath navigablePath;
    private final String sourceAlias;
    private final @Nullable InitializerParent<?> parent;
    private final NotFoundAction notFoundAction;
    private final boolean affectedByFilter;
    private final boolean isPartOfKey;
    private final boolean isResultInitializer;
    private final boolean hasKeyManyToOne;
    private final boolean previousRowReuse;
    private final boolean couldUseEmbeddedIdentifierInstanceAsEntity;
    private final @Nullable DomainResultAssembler<?> keyAssembler;
    private final @Nullable DomainResultAssembler<?> identifierAssembler;
    private final @Nullable BasicResultAssembler<?> discriminatorAssembler;
    private final @Nullable DomainResultAssembler<?> versionAssembler;
    private final @Nullable DomainResultAssembler<Object> rowIdAssembler;
    private final DomainResultAssembler<?>[][] assemblers;
    private final @Nullable Initializer<?>[] allInitializers;
    private final @Nullable Initializer<?>[][] subInitializers;
    private final @Nullable Initializer<?>[][] subInitializersForResolveFromInitialized;
    private final @Nullable Initializer<?>[][] collectionContainingSubInitializers;
    private final MutabilityPlan<Object>[][] updatableAttributeMutabilityPlans;
    private final ImmutableBitSet[] lazySets;
    private final ImmutableBitSet[] maybeLazySets;
    private final boolean hasLazySubInitializers;
    private final ConcurrentHashMap<String, Type[]> parentEntityAttributeTypes = new ConcurrentHashMap();

    public EntityInitializerImpl(EntityResultGraphNode resultDescriptor, String sourceAlias, @Nullable Fetch identifierFetch, @Nullable Fetch discriminatorFetch, @Nullable DomainResult<?> keyResult, @Nullable DomainResult<Object> rowIdResult, NotFoundAction notFoundAction, boolean affectedByFilter, @Nullable InitializerParent<?> parent, boolean isResultInitializer, AssemblerCreationState creationState) {
        super(creationState);
        this.referencedModelPart = resultDescriptor.getEntityValuedModelPart();
        this.entityDescriptor = (EntityPersister)this.referencedModelPart.getEntityMappingType();
        String rootEntityName = this.entityDescriptor.getRootEntityName();
        this.rootEntityDescriptor = rootEntityName == null || rootEntityName.equals(this.entityDescriptor.getEntityName()) ? this.entityDescriptor : this.entityDescriptor.getRootEntityDescriptor().getEntityPersister();
        this.keyTypeForEqualsHashCode = this.entityDescriptor.getIdentifierType().getTypeForEqualsHashCode();
        this.couldUseEmbeddedIdentifierInstanceAsEntity = this.entityDescriptor.getIdentifierMapping() instanceof CompositeIdentifierMapping && !((CompositeIdentifierMapping)this.entityDescriptor.getIdentifierMapping()).hasContainingClass();
        this.navigablePath = resultDescriptor.getNavigablePath();
        this.sourceAlias = sourceAlias;
        this.parent = parent;
        this.isResultInitializer = isResultInitializer;
        this.isPartOfKey = Initializer.isPartOfKey(this.navigablePath, parent);
        boolean bl = this.previousRowReuse = !EntityInitializerImpl.isPreviousRowReuse(parent) && (resultDescriptor.containsCollectionFetches() || creationState.containsMultipleCollectionFetches());
        assert (identifierFetch != null || isResultInitializer) : "Identifier must be fetched, unless this is a result initializer";
        if (identifierFetch == null) {
            this.identifierAssembler = null;
            this.hasKeyManyToOne = false;
        } else {
            this.identifierAssembler = identifierFetch.createAssembler(this, creationState);
            Initializer<?> initializer = this.identifierAssembler.getInitializer();
            boolean bl2 = this.hasKeyManyToOne = initializer != null && initializer.isLazyCapable();
        }
        assert (this.entityDescriptor.hasSubclasses() == (discriminatorFetch != null)) : "Discriminator should only be fetched if the entity has subclasses";
        this.discriminatorAssembler = discriminatorFetch != null ? (BasicResultAssembler)discriminatorFetch.createAssembler(this, creationState) : null;
        EntityVersionMapping versionMapping = this.entityDescriptor.getVersionMapping();
        if (versionMapping != null) {
            Fetch versionFetch = resultDescriptor.findFetch(versionMapping);
            assert (versionFetch != null);
            this.versionAssembler = versionFetch.createAssembler(this, creationState);
        } else {
            this.versionAssembler = null;
        }
        this.rowIdAssembler = rowIdResult != null ? rowIdResult.createResultAssembler(this, creationState) : null;
        int fetchableCount = this.entityDescriptor.getNumberOfFetchables();
        Collection<EntityMappingType> subMappingTypes = this.rootEntityDescriptor.getSubMappingTypes();
        DomainResultAssembler[][] assemblers = new DomainResultAssembler[subMappingTypes.size() + 1][];
        Initializer[] allInitializers = new Initializer[fetchableCount];
        Initializer[][] subInitializers = new Initializer[subMappingTypes.size() + 1][];
        Initializer[][] eagerSubInitializers = new Initializer[subMappingTypes.size() + 1][];
        Initializer[][] collectionContainingSubInitializers = new Initializer[subMappingTypes.size() + 1][];
        BitSet[] lazySets = new BitSet[subMappingTypes.size() + 1];
        BitSet[] maybeLazySets = new BitSet[subMappingTypes.size() + 1];
        MutabilityPlan[][] updatableAttributeMutabilityPlans = new MutabilityPlan[subMappingTypes.size() + 1][];
        assemblers[this.rootEntityDescriptor.getSubclassId()] = new DomainResultAssembler[this.rootEntityDescriptor.getNumberOfFetchables()];
        updatableAttributeMutabilityPlans[this.rootEntityDescriptor.getSubclassId()] = new MutabilityPlan[this.rootEntityDescriptor.getNumberOfAttributeMappings()];
        for (EntityMappingType subMappingType : subMappingTypes) {
            assemblers[subMappingType.getSubclassId()] = new DomainResultAssembler[subMappingType.getNumberOfFetchables()];
            updatableAttributeMutabilityPlans[subMappingType.getSubclassId()] = new MutabilityPlan[subMappingType.getNumberOfAttributeMappings()];
        }
        boolean hasLazySubInitializers = false;
        for (int i = 0; i < fetchableCount; ++i) {
            AttributeMapping attributeMapping = this.entityDescriptor.getFetchable(i).asAttributeMapping();
            Fetch fetch = resultDescriptor.findFetch(attributeMapping);
            DomainResultAssembler<?> stateAssembler = fetch == null ? new NullValueAssembler(attributeMapping.getMappedType().getMappedJavaType()) : fetch.createAssembler(this, creationState);
            int stateArrayPosition = attributeMapping.getStateArrayPosition();
            EntityMappingType declaringType = attributeMapping.getDeclaringType().asEntityMappingType();
            int subclassId = declaringType.getSubclassId();
            Initializer<?> subInitializer = stateAssembler.getInitializer();
            if (subInitializer != null) {
                allInitializers[i] = subInitializer;
                if (subInitializers[subclassId] == null) {
                    subInitializers[subclassId] = new Initializer[fetchableCount];
                    eagerSubInitializers[subclassId] = new Initializer[fetchableCount];
                    collectionContainingSubInitializers[subclassId] = new Initializer[fetchableCount];
                    lazySets[subclassId] = new BitSet(fetchableCount);
                    maybeLazySets[subclassId] = new BitSet(fetchableCount);
                }
                subInitializers[subclassId][stateArrayPosition] = subInitializer;
                if (subInitializer.isEager()) {
                    eagerSubInitializers[subclassId][stateArrayPosition] = subInitializer;
                    if (subInitializer.hasLazySubInitializers()) {
                        maybeLazySets[subclassId].set(stateArrayPosition);
                        hasLazySubInitializers = true;
                    }
                    assert (fetch != null);
                    FetchParent fetchParent = fetch.asFetchParent();
                    if (fetchParent != null && fetchParent.containsCollectionFetches() || subInitializer.isCollectionInitializer()) {
                        collectionContainingSubInitializers[subclassId][stateArrayPosition] = subInitializer;
                    }
                } else {
                    lazySets[subclassId].set(stateArrayPosition);
                    maybeLazySets[subclassId].set(stateArrayPosition);
                    hasLazySubInitializers = true;
                }
            }
            assemblers[subclassId][stateArrayPosition] = stateAssembler;
            AttributeMetadata attributeMetadata = attributeMapping.getAttributeMetadata();
            if (attributeMetadata.isUpdatable()) {
                updatableAttributeMutabilityPlans[subclassId][stateArrayPosition] = attributeMetadata.getMutabilityPlan();
            }
            for (EntityMappingType subMappingType : declaringType.getSubMappingTypes()) {
                assemblers[subMappingType.getSubclassId()][stateArrayPosition] = stateAssembler;
                updatableAttributeMutabilityPlans[subMappingType.getSubclassId()][stateArrayPosition] = updatableAttributeMutabilityPlans[subclassId][stateArrayPosition];
                if (subInitializer == null) continue;
                if (subInitializers[subMappingType.getSubclassId()] == null) {
                    subInitializers[subMappingType.getSubclassId()] = new Initializer[fetchableCount];
                    eagerSubInitializers[subMappingType.getSubclassId()] = new Initializer[fetchableCount];
                    collectionContainingSubInitializers[subMappingType.getSubclassId()] = new Initializer[fetchableCount];
                    lazySets[subMappingType.getSubclassId()] = new BitSet(fetchableCount);
                    maybeLazySets[subMappingType.getSubclassId()] = new BitSet(fetchableCount);
                }
                subInitializers[subMappingType.getSubclassId()][stateArrayPosition] = subInitializer;
                eagerSubInitializers[subMappingType.getSubclassId()][stateArrayPosition] = eagerSubInitializers[subclassId][stateArrayPosition];
                collectionContainingSubInitializers[subMappingType.getSubclassId()][stateArrayPosition] = collectionContainingSubInitializers[subclassId][stateArrayPosition];
                if (lazySets[subclassId].get(stateArrayPosition)) {
                    lazySets[subMappingType.getSubclassId()].set(stateArrayPosition);
                }
                if (!maybeLazySets[subclassId].get(stateArrayPosition)) continue;
                maybeLazySets[subMappingType.getSubclassId()].set(stateArrayPosition);
            }
        }
        BitSet emptyBitSet = new BitSet();
        for (int i = 0; i < subInitializers.length; ++i) {
            boolean emptySubInitializers = true;
            if (subInitializers[i] != null) {
                for (Initializer initializer : subInitializers[i]) {
                    if (initializer == null) continue;
                    emptySubInitializers = false;
                    break;
                }
            }
            if (emptySubInitializers) {
                subInitializers[i] = Initializer.EMPTY_ARRAY;
                lazySets[i] = emptyBitSet;
                maybeLazySets[i] = emptyBitSet;
            }
            boolean emptyContainingSubInitializers = true;
            if (collectionContainingSubInitializers[i] != null) {
                for (Initializer initializer : collectionContainingSubInitializers[i]) {
                    if (initializer == null) continue;
                    emptyContainingSubInitializers = false;
                    break;
                }
            }
            if (emptyContainingSubInitializers) {
                collectionContainingSubInitializers[i] = Initializer.EMPTY_ARRAY;
            }
            boolean emptyEagerSubInitializers = true;
            if (eagerSubInitializers[i] != null) {
                for (Initializer initializer : eagerSubInitializers[i]) {
                    if (initializer == null) continue;
                    emptyEagerSubInitializers = false;
                    break;
                }
            }
            if (!emptyEagerSubInitializers) continue;
            eagerSubInitializers[i] = Initializer.EMPTY_ARRAY;
        }
        this.assemblers = assemblers;
        this.allInitializers = allInitializers;
        this.subInitializers = subInitializers;
        this.subInitializersForResolveFromInitialized = this.rootEntityDescriptor.getBytecodeEnhancementMetadata().isEnhancedForLazyLoading() ? subInitializers : eagerSubInitializers;
        this.collectionContainingSubInitializers = collectionContainingSubInitializers;
        this.lazySets = (ImmutableBitSet[])Arrays.stream(lazySets).map(ImmutableBitSet::valueOf).toArray(ImmutableBitSet[]::new);
        this.maybeLazySets = (ImmutableBitSet[])Arrays.stream(maybeLazySets).map(ImmutableBitSet::valueOf).toArray(ImmutableBitSet[]::new);
        this.hasLazySubInitializers = hasLazySubInitializers;
        this.updatableAttributeMutabilityPlans = updatableAttributeMutabilityPlans;
        this.notFoundAction = notFoundAction;
        this.keyAssembler = keyResult == null ? null : keyResult.createResultAssembler(this, creationState);
        this.affectedByFilter = affectedByFilter;
    }

    private static boolean isPreviousRowReuse(@Nullable InitializerParent<?> parent) {
        while (parent != null) {
            if (parent instanceof EntityInitializerImpl) {
                return ((EntityInitializerImpl)parent).isPreviousRowReuse();
            }
            if (parent instanceof AbstractImmediateCollectionInitializer) {
                return false;
            }
            parent = parent.getParent();
        }
        return false;
    }

    @Override
    protected EntityInitializerData createInitializerData(RowProcessingState rowProcessingState) {
        return new EntityInitializerData(this, rowProcessingState);
    }

    @Override
    public void resolveKey(EntityInitializerData data) {
        this.resolveKey(data, false);
    }

    @Override
    public @Nullable Object getEntityIdentifier(EntityInitializerData data) {
        return data.entityKey == null ? null : data.entityKey.getIdentifier();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable EntityKey resolveEntityKeyOnly(RowProcessingState rowProcessingState) {
        assert (this.identifierAssembler != null);
        EntityInitializerData data = (EntityInitializerData)this.getData(rowProcessingState);
        this.resolveKey(data, true);
        try {
            if (data.getState() == Initializer.State.MISSING) {
                EntityKey entityKey = null;
                return entityKey;
            }
            if (data.entityKey == null) {
                Object id = this.identifierAssembler.assemble(rowProcessingState);
                if (id == null) {
                    this.setMissing(data);
                    EntityKey initializer = null;
                    return initializer;
                }
                this.resolveEntityKey(data, id);
            }
            EntityKey entityKey = data.entityKey;
            return entityKey;
        }
        finally {
            Initializer<?> initializer = this.identifierAssembler.getInitializer();
            if (this.hasKeyManyToOne && initializer != null) {
                EmbeddableInitializer<?> embeddableInitializer = initializer.asEmbeddableInitializer();
                assert (embeddableInitializer != null);
                embeddableInitializer.resetResolvedEntityRegistrations(rowProcessingState);
            }
        }
    }

    @Override
    public void resetResolvedEntityRegistrations(RowProcessingState rowProcessingState) {
        EntityInitializerData data = (EntityInitializerData)this.getData(rowProcessingState);
        if (data.getState() == Initializer.State.RESOLVED) {
            rowProcessingState.getSession().getPersistenceContextInternal().removeEntityHolder(data.entityKey);
            rowProcessingState.getJdbcValuesSourceProcessingState().getLoadingEntityHolders().remove(data.entityHolder);
            data.entityKey = null;
            data.entityHolder = null;
            data.entityInstanceForNotify = null;
            data.setInstance(null);
        }
    }

    protected void resolveKey(EntityInitializerData data, boolean entityKeyOnly) {
        Object id;
        if (data.getState() != Initializer.State.UNINITIALIZED) {
            return;
        }
        data.setState(Initializer.State.KEY_RESOLVED);
        EntityKey oldEntityKey = data.entityKey;
        Object oldEntityInstance = data.getInstance();
        Object oldEntityInstanceForNotify = data.entityInstanceForNotify;
        EntityHolder oldEntityHolder = data.entityHolder;
        EntityPersister concreteDescriptor = data.concreteDescriptor = data.defaultConcreteDescriptor;
        data.entityKey = null;
        data.setInstance(null);
        data.entityInstanceForNotify = null;
        data.entityHolder = null;
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        if (this.identifierAssembler == null) {
            id = rowProcessingState.getEntityId();
            assert (id != null) : "Initializer requires a not null id for loading";
        } else {
            Initializer<?> initializer = this.identifierAssembler.getInitializer();
            if (initializer != null) {
                Object subData = initializer.getData(rowProcessingState);
                initializer.resolveKey(subData);
                if (((InitializerData)subData).getState() == Initializer.State.MISSING) {
                    this.setMissing(data);
                    return;
                }
                if (concreteDescriptor == null) {
                    data.concreteDescriptor = EntityInitializerImpl.determineConcreteEntityDescriptor(rowProcessingState, this.discriminatorAssembler, this.entityDescriptor);
                    assert (data.concreteDescriptor != null);
                }
                if (this.hasKeyManyToOne) {
                    if (!data.shallowCached && !entityKeyOnly) {
                        this.resolveKeySubInitializers(data);
                    }
                    return;
                }
            }
            if ((id = this.identifierAssembler.assemble(rowProcessingState)) == null) {
                this.setMissing(data);
                return;
            }
        }
        if (oldEntityKey != null && this.previousRowReuse && oldEntityInstance != null && this.areKeysEqual(oldEntityKey.getIdentifier(), id) && !oldEntityHolder.isDetached()) {
            data.setState(Initializer.State.INITIALIZED);
            data.entityKey = oldEntityKey;
            data.setInstance(oldEntityInstance);
            data.entityInstanceForNotify = oldEntityInstanceForNotify;
            data.concreteDescriptor = oldEntityKey.getPersister();
            data.entityHolder = oldEntityHolder;
            if (!entityKeyOnly) {
                this.notifySubInitializersToReusePreviousRowInstance(data);
            }
            return;
        }
        this.resolveEntityKey(data, id);
        if (!entityKeyOnly) {
            this.resolveInstance(data);
            if (!data.shallowCached) {
                if (data.getState() == Initializer.State.INITIALIZED) {
                    if (data.entityHolder.getEntityInitializer() == null) {
                        this.resolveInstanceSubInitializers(data);
                    } else {
                        this.resolveKeySubInitializers(data);
                    }
                } else {
                    this.resolveKeySubInitializers(data);
                }
            }
        }
    }

    private boolean areKeysEqual(Object key1, Object key2) {
        return this.keyTypeForEqualsHashCode == null ? key1.equals(key2) : this.keyTypeForEqualsHashCode.isEqual(key1, key2);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void resolveInstanceSubInitializers(EntityInitializerData data) {
        Object[] state;
        RowProcessingState rowProcessingState;
        ImmutableBitSet maybeLazySet;
        Initializer<?>[] initializers;
        block14: {
            int subclassId = data.concreteDescriptor.getSubclassId();
            EntityEntry entityEntry = data.entityHolder.getEntityEntry();
            assert (entityEntry != null) : "This method should only be called if the entity is already initialized";
            if (data.entityHolder.getEntityInitializer() == this) {
                initializers = this.collectionContainingSubInitializers[subclassId];
                maybeLazySet = null;
            } else {
                initializers = this.subInitializersForResolveFromInitialized[subclassId];
                maybeLazySet = entityEntry.getMaybeLazySet();
                if (initializers.length == 0 || maybeLazySet != null && this.lazySets[subclassId].contains(maybeLazySet)) {
                    return;
                }
            }
            rowProcessingState = data.getRowProcessingState();
            PersistenceContext persistenceContext = rowProcessingState.getSession().getPersistenceContextInternal();
            assert (entityEntry == persistenceContext.getEntry(data.entityInstanceForNotify));
            Object[] loadedState = entityEntry.getLoadedState();
            if (loadedState == null) {
                if (entityEntry.getStatus() == Status.READ_ONLY) {
                    state = data.concreteDescriptor.getValues(data.entityInstanceForNotify);
                    break block14;
                } else {
                    assert (entityEntry.getStatus() == Status.LOADING);
                    return;
                }
            }
            state = loadedState;
        }
        int i = 0;
        while (i < initializers.length) {
            Initializer<?> initializer = initializers[i];
            if (initializer != null && (maybeLazySet == null || maybeLazySet.get(i))) {
                Object subInstance = state[i];
                if (subInstance == LazyPropertyInitializer.UNFETCHED_PROPERTY) {
                    initializer.resolveKey(rowProcessingState);
                } else {
                    initializer.resolveInstance(subInstance, rowProcessingState);
                }
            }
            ++i;
        }
        return;
    }

    private void notifySubInitializersToReusePreviousRowInstance(EntityInitializerData data) {
        ImmutableBitSet maybeLazySet;
        Initializer<?>[] subInitializer;
        EntityEntry entityEntry = data.entityHolder.getEntityEntry();
        if (data.entityHolder.getEntityInitializer() == this) {
            subInitializer = this.collectionContainingSubInitializers[data.concreteDescriptor.getSubclassId()];
            maybeLazySet = null;
        } else {
            subInitializer = this.subInitializersForResolveFromInitialized[data.concreteDescriptor.getSubclassId()];
            maybeLazySet = entityEntry == null ? null : entityEntry.getMaybeLazySet();
        }
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        for (int i = 0; i < subInitializer.length; ++i) {
            Initializer<?> initializer = subInitializer[i];
            if (initializer == null || maybeLazySet != null && !maybeLazySet.get(i)) continue;
            initializer.resolveFromPreviousRow(rowProcessingState);
        }
    }

    protected void resolveKeySubInitializers(EntityInitializerData data) {
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        for (Initializer<?> initializer : this.subInitializers[data.concreteDescriptor.getSubclassId()]) {
            if (initializer == null) continue;
            initializer.resolveKey(rowProcessingState);
        }
    }

    @EnsuresNonNull(value={"data.entityKey"})
    protected void resolveEntityKey(EntityInitializerData data, Object id) {
        EntityPersister concreteDescriptor = data.concreteDescriptor;
        if (concreteDescriptor == null) {
            concreteDescriptor = data.concreteDescriptor = EntityInitializerImpl.determineConcreteEntityDescriptor(data.getRowProcessingState(), this.discriminatorAssembler, this.entityDescriptor);
            assert (concreteDescriptor != null);
        }
        data.entityKey = new EntityKey(id, concreteDescriptor);
    }

    protected void setMissing(EntityInitializerData data) {
        Object fkKeyValue;
        data.entityKey = null;
        data.concreteDescriptor = null;
        data.setInstance(null);
        data.entityInstanceForNotify = null;
        data.entityHolder = null;
        data.setState(Initializer.State.MISSING);
        if (this.keyAssembler != null && (fkKeyValue = this.keyAssembler.assemble(data.getRowProcessingState())) != null && this.notFoundAction != NotFoundAction.IGNORE) {
            if (this.affectedByFilter) {
                throw new EntityFilterException(this.getEntityDescriptor().getEntityName(), fkKeyValue, this.referencedModelPart.getNavigableRole().getFullPath());
            }
            throw new FetchNotFoundException(this.getEntityDescriptor().getEntityName(), fkKeyValue);
        }
    }

    @Override
    public void resolveFromPreviousRow(EntityInitializerData data) {
        if (data.getState() == Initializer.State.UNINITIALIZED) {
            EntityKey entityKey = data.entityKey;
            if (entityKey == null) {
                this.setMissing(data);
            } else {
                data.setState(Initializer.State.INITIALIZED);
                this.notifySubInitializersToReusePreviousRowInstance(data);
            }
        }
    }

    @Override
    public void initializeInstanceFromParent(Object parentInstance, EntityInitializerData data) {
        AttributeMapping attributeMapping = this.getInitializedPart().asAttributeMapping();
        Object instance = attributeMapping != null ? attributeMapping.getValue(parentInstance) : parentInstance;
        SharedSessionContractImplementor session = data.getRowProcessingState().getSession();
        if (instance == null) {
            this.setMissing(data);
        } else {
            data.setInstance(instance);
            Object entityInstanceForNotify = data.entityInstanceForNotify = Hibernate.unproxy(instance);
            data.concreteDescriptor = session.getEntityPersister(null, entityInstanceForNotify);
            this.resolveEntityKey(data, data.concreteDescriptor.getIdentifier(entityInstanceForNotify, session));
            data.entityHolder = session.getPersistenceContextInternal().getEntityHolder(data.entityKey);
            data.setState(Initializer.State.INITIALIZED);
            this.initializeSubInstancesFromParent(data);
        }
    }

    @Override
    public boolean isResultInitializer() {
        return this.isResultInitializer;
    }

    private void deepCopy(EntityPersister containerDescriptor, Object[] source, Object[] target) {
        MutabilityPlan<Object>[] updatableAttributeMutabilityPlan = this.updatableAttributeMutabilityPlans[containerDescriptor.getSubclassId()];
        for (int i = 0; i < updatableAttributeMutabilityPlan.length; ++i) {
            Object sourceValue = source[i];
            if (updatableAttributeMutabilityPlan[i] == null || sourceValue == LazyPropertyInitializer.UNFETCHED_PROPERTY || sourceValue == PropertyAccessStrategyBackRefImpl.UNKNOWN) continue;
            target[i] = updatableAttributeMutabilityPlan[i].deepCopy(source[i]);
        }
    }

    @Override
    public ModelPart getInitializedPart() {
        return this.referencedModelPart;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    protected DomainResultAssembler<?> getIdentifierAssembler() {
        return this.identifierAssembler;
    }

    @Override
    public EntityPersister getEntityDescriptor() {
        return this.entityDescriptor;
    }

    @Override
    public Object getTargetInstance(EntityInitializerData data) {
        return data.entityInstanceForNotify;
    }

    @Override
    public @Nullable InitializerParent<?> getParent() {
        return this.parent;
    }

    protected Type[] getParentEntityAttributeTypes(String attributeName) {
        Type[] types = this.parentEntityAttributeTypes.get(attributeName);
        if (types == null) {
            types = new Type[this.entityDescriptor.getRootEntityDescriptor().getSubclassEntityNames().size()];
            this.initializeAttributeType(types, this.entityDescriptor, attributeName);
            for (EntityMappingType subMappingType : this.entityDescriptor.getSubMappingTypes()) {
                this.initializeAttributeType(types, subMappingType.getEntityPersister(), attributeName);
            }
            this.parentEntityAttributeTypes.putIfAbsent(attributeName, types);
        }
        return types;
    }

    protected void initializeAttributeType(Type[] attributeTypes, EntityPersister entityDescriptor, String attributeName) {
        if (entityDescriptor.findByPath(attributeName) != null) {
            attributeTypes[entityDescriptor.getSubclassId()] = entityDescriptor.getPropertyType(attributeName);
        }
    }

    public static @Nullable EntityPersister determineConcreteEntityDescriptor(RowProcessingState rowProcessingState, @Nullable BasicResultAssembler<?> discriminatorAssembler, EntityPersister entityDescriptor) throws WrongClassException {
        if (discriminatorAssembler == null || rowProcessingState.isQueryCacheHit() && entityDescriptor.useShallowQueryCacheLayout() && !entityDescriptor.storeDiscriminatorInShallowQueryCacheLayout()) {
            return entityDescriptor;
        }
        assert (entityDescriptor.hasSubclasses()) : "Reading a discriminator from a result set should only happen if the entity has subclasses";
        EntityDiscriminatorMapping discriminatorMapping = entityDescriptor.getDiscriminatorMapping();
        assert (discriminatorMapping != null);
        Object discriminator = discriminatorAssembler.extractRawValue(rowProcessingState);
        DiscriminatorValueDetails discriminatorDetails = discriminatorMapping.resolveDiscriminatorValue(discriminator);
        if (discriminatorDetails == null) {
            assert (discriminator == null) : "Discriminator details should only be null for null values";
            return null;
        }
        EntityMappingType indicatedEntity = discriminatorDetails.getIndicatedEntity();
        if (indicatedEntity.isTypeOrSuperType(entityDescriptor)) {
            return indicatedEntity.getEntityPersister();
        }
        throw new WrongClassException(indicatedEntity.getEntityName(), null, entityDescriptor.getEntityName(), discriminator);
    }

    protected boolean useEmbeddedIdentifierInstanceAsEntity(EntityInitializerData data) {
        return data.canUseEmbeddedIdentifierInstanceAsEntity && (data.concreteDescriptor = EntityInitializerImpl.determineConcreteEntityDescriptor(data.getRowProcessingState(), this.discriminatorAssembler, this.entityDescriptor)) != null && data.concreteDescriptor.isInstance(data.getRowProcessingState().getEntityId());
    }

    @Override
    public void resolveInstance(Object instance, EntityInitializerData data) {
        Initializer<?> initializer;
        if (instance == null) {
            this.setMissing(data);
            return;
        }
        data.setInstance(instance);
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(instance);
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        SharedSessionContractImplementor session = rowProcessingState.getSession();
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        if (lazyInitializer == null) {
            data.entityInstanceForNotify = instance;
            data.concreteDescriptor = session.getEntityPersister(null, instance);
            this.resolveEntityKey(data, data.concreteDescriptor.getIdentifier(instance, session));
            data.entityHolder = persistenceContext.getEntityHolder(data.entityKey);
            if (data.entityHolder == null) {
                data.entityHolder = persistenceContext.claimEntityHolderIfPossible(data.entityKey, data.entityInstanceForNotify, rowProcessingState.getJdbcValuesSourceProcessingState(), this);
            }
            if (data.concreteDescriptor.getBytecodeEnhancementMetadata().isEnhancedForLazyLoading() && ManagedTypeHelper.isPersistentAttributeInterceptable(data.entityInstanceForNotify) && EntityInitializerImpl.getAttributeInterceptor(data.entityInstanceForNotify) instanceof EnhancementAsProxyLazinessInterceptor && !((EnhancementAsProxyLazinessInterceptor)EntityInitializerImpl.getAttributeInterceptor(data.entityInstanceForNotify)).isInitialized()) {
                data.setState(Initializer.State.RESOLVED);
            } else {
                data.setState(data.entityHolder.getEntityInitializer() == null ? Initializer.State.INITIALIZED : Initializer.State.RESOLVED);
            }
            if (data.getState() == Initializer.State.RESOLVED) {
                data.entityHolder = persistenceContext.claimEntityHolderIfPossible(data.entityKey, data.entityInstanceForNotify, rowProcessingState.getJdbcValuesSourceProcessingState(), this);
            }
        } else if (lazyInitializer.isUninitialized()) {
            data.setState(Initializer.State.RESOLVED);
            EntityPersister entityPersister = data.concreteDescriptor = this.discriminatorAssembler == null ? this.entityDescriptor : EntityInitializerImpl.determineConcreteEntityDescriptor(rowProcessingState, this.discriminatorAssembler, this.entityDescriptor);
            assert (data.concreteDescriptor != null);
            this.resolveEntityKey(data, lazyInitializer.getIdentifier());
            data.entityHolder = persistenceContext.claimEntityHolderIfPossible(data.entityKey, null, rowProcessingState.getJdbcValuesSourceProcessingState(), this);
            data.entityInstanceForNotify = this.resolveEntityInstance(data);
            lazyInitializer.setImplementation(data.entityInstanceForNotify);
            this.registerLoadingEntity(data, data.entityInstanceForNotify);
        } else {
            data.entityInstanceForNotify = lazyInitializer.getImplementation();
            data.concreteDescriptor = session.getEntityPersister(null, data.entityInstanceForNotify);
            this.resolveEntityKey(data, lazyInitializer.getIdentifier());
            data.entityHolder = persistenceContext.getEntityHolder(data.entityKey);
            data.setState(data.entityHolder.isInitialized() ? Initializer.State.INITIALIZED : Initializer.State.RESOLVED);
        }
        if (this.identifierAssembler != null && (initializer = this.identifierAssembler.getInitializer()) != null) {
            initializer.resolveInstance(data.entityKey.getIdentifier(), rowProcessingState);
        }
        this.upgradeLockMode(data);
        if (data.getState() == Initializer.State.INITIALIZED) {
            this.registerReloadedEntity(data);
            this.resolveInstanceSubInitializers(data);
            if (rowProcessingState.needsResolveState()) {
                this.resolveEntityState(data);
            }
        } else {
            this.resolveKeySubInitializers(data);
        }
    }

    @Override
    public void resolveInstance(EntityInitializerData data) {
        if (data.getState() != Initializer.State.KEY_RESOLVED) {
            return;
        }
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        data.setState(Initializer.State.RESOLVED);
        if (data.entityKey == null) {
            assert (this.identifierAssembler != null);
            Object id = this.identifierAssembler.assemble(rowProcessingState);
            if (id == null) {
                this.setMissing(data);
                return;
            }
            this.resolveEntityKey(data, id);
        }
        PersistenceContext persistenceContext = rowProcessingState.getSession().getPersistenceContextInternal();
        data.entityHolder = persistenceContext.claimEntityHolderIfPossible(data.entityKey, null, rowProcessingState.getJdbcValuesSourceProcessingState(), this);
        if (this.useEmbeddedIdentifierInstanceAsEntity(data)) {
            data.entityInstanceForNotify = rowProcessingState.getEntityId();
            data.setInstance(data.entityInstanceForNotify);
        } else {
            this.resolveEntityInstance1(data);
            if (data.uniqueKeyAttributePath != null) {
                SharedSessionContractImplementor session = rowProcessingState.getSession();
                EntityPersister concreteDescriptor = this.getConcreteDescriptor(data);
                EntityUniqueKey euk = new EntityUniqueKey(concreteDescriptor.getEntityName(), data.uniqueKeyAttributePath, rowProcessingState.getEntityUniqueKey(), data.uniqueKeyPropertyTypes[concreteDescriptor.getSubclassId()], session.getFactory());
                session.getPersistenceContextInternal().addEntity(euk, data.getInstance());
            }
        }
        if (data.getInstance() != null) {
            this.upgradeLockMode(data);
            if (data.getState() == Initializer.State.INITIALIZED) {
                this.registerReloadedEntity(data);
                if (rowProcessingState.needsResolveState()) {
                    this.resolveEntityState(data);
                }
            }
            if (data.shallowCached) {
                this.initializeSubInstancesFromParent(data);
            }
        }
    }

    protected void resolveEntityInstance1(EntityInitializerData data) {
        boolean unwrapProxy;
        Object proxy = data.entityHolder.getProxy();
        boolean bl = unwrapProxy = proxy != null && this.referencedModelPart instanceof ToOneAttributeMapping && ((ToOneAttributeMapping)this.referencedModelPart).isUnwrapProxy() && this.getConcreteDescriptor(data).getBytecodeEnhancementMetadata().isEnhancedForLazyLoading();
        if (!unwrapProxy && this.isProxyInstance(proxy)) {
            Object entityFromExecutionContext = this.getEntityFromExecutionContext(data);
            if (entityFromExecutionContext != null) {
                data.entityInstanceForNotify = entityFromExecutionContext;
                data.setInstance(data.entityInstanceForNotify);
                this.registerReloadedEntity(data);
            } else {
                data.setInstance(proxy);
                if (Hibernate.isInitialized(proxy)) {
                    data.setState(Initializer.State.INITIALIZED);
                    data.entityInstanceForNotify = Hibernate.unproxy(proxy);
                } else {
                    LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(proxy);
                    assert (lazyInitializer != null);
                    data.entityInstanceForNotify = this.resolveEntityInstance2(data);
                    lazyInitializer.setImplementation(data.entityInstanceForNotify);
                }
            }
        } else {
            Object existingEntity = data.entityHolder.getEntity();
            if (existingEntity != null) {
                data.entityInstanceForNotify = existingEntity;
                data.setInstance(data.entityInstanceForNotify);
                if (data.entityHolder.getEntityInitializer() == null) {
                    assert (data.entityHolder.isInitialized() == this.isExistingEntityInitialized(existingEntity));
                    if (data.entityHolder.isInitialized()) {
                        data.setState(Initializer.State.INITIALIZED);
                    } else if (this.isResultInitializer()) {
                        this.registerLoadingEntity(data, existingEntity);
                    }
                } else if (data.entityHolder.getEntityInitializer() != this) {
                    data.setState(Initializer.State.INITIALIZED);
                }
            } else {
                Object entityFromExecutionContext = this.getEntityFromExecutionContext(data);
                if (entityFromExecutionContext != null) {
                    data.entityInstanceForNotify = entityFromExecutionContext;
                    data.setInstance(data.entityInstanceForNotify);
                    if (this.isResultInitializer()) {
                        this.registerLoadingEntity(data, entityFromExecutionContext);
                    }
                } else {
                    Initializer<?> idInitializer;
                    assert (data.entityHolder.getEntityInitializer() == this);
                    data.entityInstanceForNotify = this.resolveEntityInstance2(data);
                    data.setInstance(data.entityInstanceForNotify);
                    if (data.entityHolder.getEntityInitializer() == this && data.getState() != Initializer.State.INITIALIZED && this.identifierAssembler != null && (idInitializer = this.identifierAssembler.getInitializer()) != null) {
                        idInitializer.initializeInstance(data.getRowProcessingState());
                    }
                }
            }
        }
        assert (!data.shallowCached || data.getState() == Initializer.State.INITIALIZED) : "Forgot to initialize the entity";
    }

    protected Object getEntityFromExecutionContext(EntityInitializerData data) {
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        ExecutionContext executionContext = rowProcessingState.getJdbcValuesSourceProcessingState().getExecutionContext();
        if (this.rootEntityDescriptor == executionContext.getRootEntityDescriptor() && this.areKeysEqual(data.entityKey.getIdentifier(), executionContext.getEntityId())) {
            return executionContext.getEntityInstance();
        }
        return null;
    }

    protected void upgradeLockMode(EntityInitializerData data) {
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        if (data.lockMode != LockMode.NONE && rowProcessingState.upgradeLocks()) {
            EntityEntry entry = data.entityHolder.getEntityEntry();
            assert (entry == rowProcessingState.getSession().getPersistenceContextInternal().getEntry(data.entityInstanceForNotify));
            if (entry != null && entry.getLockMode().lessThan(data.lockMode)) {
                if (this.versionAssembler != null && entry.getLockMode() != LockMode.NONE) {
                    this.checkVersion(data, entry, rowProcessingState);
                }
                entry.setLockMode(data.lockMode);
            }
        }
    }

    private boolean isProxyInstance(Object proxy) {
        return proxy != null && (proxy instanceof MapProxy || this.entityDescriptor.getJavaType().getJavaTypeClass().isInstance(proxy));
    }

    private boolean isExistingEntityInitialized(Object existingEntity) {
        return Hibernate.isInitialized(existingEntity);
    }

    private void checkVersion(EntityInitializerData data, EntityEntry entry, RowProcessingState rowProcessingState) throws HibernateException {
        Object version = entry.getVersion();
        if (version != null) {
            Object currentVersion = this.versionAssembler.assemble(rowProcessingState);
            if (!data.concreteDescriptor.getVersionType().isEqual(version, currentVersion)) {
                StatisticsImplementor statistics = rowProcessingState.getSession().getFactory().getStatistics();
                if (statistics.isStatisticsEnabled()) {
                    statistics.optimisticFailure(data.concreteDescriptor.getEntityName());
                }
                throw new StaleObjectStateException(data.concreteDescriptor.getEntityName(), entry.getId());
            }
        }
    }

    protected Object resolveEntityInstance2(EntityInitializerData data) {
        if (data.entityHolder.getEntityInitializer() == this) {
            assert (data.entityHolder.getEntity() == null);
            return this.resolveEntityInstance(data);
        }
        return data.entityHolder.getEntity();
    }

    protected Object resolveEntityInstance(EntityInitializerData data) {
        Object cached;
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        Object resolved = this.resolveToOptionalInstance(data);
        if (resolved != null) {
            this.registerLoadingEntity(data, resolved);
            return resolved;
        }
        if (rowProcessingState.isQueryCacheHit() && this.entityDescriptor.useShallowQueryCacheLayout()) {
            data.setState(Initializer.State.INITIALIZED);
            SharedSessionContractImplementor session = rowProcessingState.getSession();
            assert (data.entityHolder.getEntityInitializer() == this);
            rowProcessingState.getJdbcValuesSourceProcessingState().getLoadingEntityHolders().remove(data.entityHolder);
            session.getPersistenceContextInternal().removeEntityHolder(data.entityKey);
            return session.internalLoad(data.concreteDescriptor.getEntityName(), data.entityKey.getIdentifier(), true, false);
        }
        if (this.entityDescriptor.canUseReferenceCacheEntries() && (cached = this.resolveInstanceFromCache(data)) != null) {
            data.setState(Initializer.State.INITIALIZED);
            return cached;
        }
        Object instance = this.instantiateEntity(data);
        this.registerLoadingEntity(data, instance);
        return instance;
    }

    protected Object instantiateEntity(EntityInitializerData data) {
        return data.getRowProcessingState().getSession().instantiate(data.concreteDescriptor, data.entityKey.getIdentifier());
    }

    private Object resolveToOptionalInstance(EntityInitializerData data) {
        if (this.isResultInitializer()) {
            JdbcValuesSourceProcessingOptions processingOptions = data.getRowProcessingState().getJdbcValuesSourceProcessingState().getProcessingOptions();
            return this.matchesOptionalInstance(data, processingOptions) ? processingOptions.getEffectiveOptionalObject() : null;
        }
        return null;
    }

    private boolean matchesOptionalInstance(EntityInitializerData data, JdbcValuesSourceProcessingOptions processingOptions) {
        Object optionalEntityInstance = processingOptions.getEffectiveOptionalObject();
        Object requestedEntityId = processingOptions.getEffectiveOptionalId();
        return requestedEntityId != null && optionalEntityInstance != null && this.areKeysEqual(requestedEntityId, data.entityKey.getIdentifier());
    }

    private Object resolveInstanceFromCache(EntityInitializerData data) {
        return CacheEntityLoaderHelper.INSTANCE.loadFromSecondLevelCache(data.getRowProcessingState().getSession().asEventSource(), null, data.lockMode, this.entityDescriptor, data.entityKey);
    }

    protected void registerLoadingEntity(EntityInitializerData data, Object instance) {
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        rowProcessingState.getSession().getPersistenceContextInternal().claimEntityHolderIfPossible(data.entityKey, instance, rowProcessingState.getJdbcValuesSourceProcessingState(), this);
    }

    protected void registerReloadedEntity(EntityInitializerData data) {
        if (data.hasCallbackActions) {
            data.entityHolder.markAsReloaded(data.getRowProcessingState().getJdbcValuesSourceProcessingState());
        }
    }

    @Override
    public void initializeInstance(EntityInitializerData data) {
        if (data.getState() != Initializer.State.RESOLVED) {
            return;
        }
        if (!this.skipInitialization(data)) {
            assert (this.consistentInstance(data));
            this.initializeEntityInstance(data);
        }
        data.setState(Initializer.State.INITIALIZED);
    }

    protected boolean consistentInstance(EntityInitializerData data) {
        PersistenceContext persistenceContextInternal = data.getRowProcessingState().getSession().getPersistenceContextInternal();
        Object entity = persistenceContextInternal.getEntity(data.entityKey);
        return entity == null || entity == data.entityInstanceForNotify;
    }

    protected void initializeEntityInstance(EntityInitializerData data) {
        PersistentAttributeInterceptor persistentAttributeInterceptor;
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        SharedSessionContractImplementor session = rowProcessingState.getSession();
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        EntityKey entityKey = data.entityKey;
        assert (entityKey != null);
        Object entityIdentifier = entityKey.getIdentifier();
        Object[] resolvedEntityState = this.extractConcreteTypeStateValues(data);
        this.preLoad(data, resolvedEntityState);
        Object entityInstanceForNotify = data.entityInstanceForNotify;
        if (ManagedTypeHelper.isPersistentAttributeInterceptable(entityInstanceForNotify) && ((persistentAttributeInterceptor = ManagedTypeHelper.asPersistentAttributeInterceptable(entityInstanceForNotify).$$_hibernate_getInterceptor()) == null || persistentAttributeInterceptor instanceof EnhancementAsProxyLazinessInterceptor)) {
            data.concreteDescriptor.getBytecodeEnhancementMetadata().injectInterceptor(entityInstanceForNotify, entityIdentifier, session);
        }
        data.concreteDescriptor.setPropertyValues(entityInstanceForNotify, resolvedEntityState);
        persistenceContext.addEntity(entityKey, entityInstanceForNotify);
        this.registerPossibleUniqueKeyEntries(data, resolvedEntityState, session);
        Object version = this.versionAssembler != null ? this.versionAssembler.assemble(rowProcessingState) : null;
        Object rowId = this.rowIdAssembler != null ? this.rowIdAssembler.assemble(rowProcessingState) : null;
        LockMode lockModeToAcquire = data.lockMode == LockMode.NONE ? LockMode.READ : data.lockMode;
        EntityEntry entityEntry = persistenceContext.addEntry(entityInstanceForNotify, Status.LOADING, resolvedEntityState, rowId, entityIdentifier, version, lockModeToAcquire, true, data.concreteDescriptor, false);
        entityEntry.setMaybeLazySet(this.maybeLazySets[data.concreteDescriptor.getSubclassId()]);
        data.entityHolder.setEntityEntry(entityEntry);
        this.registerNaturalIdResolution(data, persistenceContext, resolvedEntityState);
        this.takeSnapshot(data, session, persistenceContext, entityEntry, resolvedEntityState);
        data.concreteDescriptor.afterInitialize(entityInstanceForNotify, session);
        assert (data.concreteDescriptor.getIdentifier(entityInstanceForNotify, session) != null);
        StatisticsImplementor statistics = session.getFactory().getStatistics();
        if (statistics.isStatisticsEnabled() && !rowProcessingState.isQueryCacheHit()) {
            statistics.loadEntity(data.concreteDescriptor.getEntityName());
        }
        this.updateCaches(data, session, session.getPersistenceContextInternal(), resolvedEntityState, version);
    }

    protected void updateCaches(EntityInitializerData data, SharedSessionContractImplementor session, PersistenceContext persistenceContext, Object[] resolvedEntityState, Object version) {
        EntityDataAccess cacheAccess;
        if (data.concreteDescriptor.canWriteToCache() && !data.getRowProcessingState().isQueryCacheHit() && session.getCacheMode().isPutEnabled() && (cacheAccess = data.concreteDescriptor.getCacheAccessStrategy()) != null) {
            this.putInCache(data, session, persistenceContext, resolvedEntityState, version, cacheAccess);
        }
    }

    protected void registerNaturalIdResolution(EntityInitializerData data, PersistenceContext persistenceContext, Object[] resolvedEntityState) {
        if (this.entityDescriptor.getNaturalIdMapping() != null) {
            Object naturalId = this.entityDescriptor.getNaturalIdMapping().extractNaturalIdFromEntityState(resolvedEntityState);
            persistenceContext.getNaturalIdResolutions().cacheResolutionFromLoad(data.entityKey.getIdentifier(), naturalId, this.entityDescriptor);
        }
    }

    protected void takeSnapshot(EntityInitializerData data, SharedSessionContractImplementor session, PersistenceContext persistenceContext, EntityEntry entityEntry, Object[] resolvedEntityState) {
        if (this.isReallyReadOnly(data, session)) {
            persistenceContext.setEntryStatus(entityEntry, Status.READ_ONLY);
        } else {
            this.deepCopy(data.concreteDescriptor, resolvedEntityState, resolvedEntityState);
            persistenceContext.setEntryStatus(entityEntry, Status.MANAGED);
        }
    }

    private boolean isReallyReadOnly(EntityInitializerData data, SharedSessionContractImplementor session) {
        if (!data.concreteDescriptor.isMutable()) {
            return true;
        }
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(data.getInstance());
        if (lazyInitializer != null) {
            return lazyInitializer.isReadOnly();
        }
        return this.isReadOnly(data.getRowProcessingState(), session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void putInCache(EntityInitializerData data, SharedSessionContractImplementor session, PersistenceContext persistenceContext, Object[] resolvedEntityState, Object version, EntityDataAccess cacheAccess) {
        SessionFactoryImplementor factory = session.getFactory();
        CacheEntry cacheEntry = data.concreteDescriptor.buildCacheEntry(data.entityInstanceForNotify, resolvedEntityState, version, session);
        Object cacheKey = cacheAccess.generateCacheKey(data.entityKey.getIdentifier(), this.rootEntityDescriptor, factory, session.getTenantIdentifier());
        EventManager eventManager = session.getEventManager();
        if (persistenceContext.wasInsertedDuringTransaction(data.concreteDescriptor, data.entityKey.getIdentifier())) {
            boolean cacheContentChanged = false;
            HibernateMonitoringEvent cachePutEvent = eventManager.beginCachePutEvent();
            try {
                if (cacheAccess.getAccessType() != AccessType.TRANSACTIONAL) return;
                cacheContentChanged = cacheAccess.update(session, cacheKey, data.concreteDescriptor.getCacheEntryStructure().structure(cacheEntry), version, version);
                return;
            }
            finally {
                eventManager.completeCachePutEvent(cachePutEvent, session, (CachedDomainDataAccess)cacheAccess, data.concreteDescriptor, cacheContentChanged, EventManager.CacheActionDescription.ENTITY_UPDATE);
            }
        }
        SessionEventListenerManager eventListenerManager = session.getEventListenerManager();
        boolean put = false;
        HibernateMonitoringEvent cachePutEvent = eventManager.beginCachePutEvent();
        try {
            eventListenerManager.cachePutStart();
            put = cacheAccess.putFromLoad(session, cacheKey, data.concreteDescriptor.getCacheEntryStructure().structure(cacheEntry), version, false);
            return;
        }
        finally {
            eventManager.completeCachePutEvent(cachePutEvent, session, (CachedDomainDataAccess)cacheAccess, data.concreteDescriptor, put, EventManager.CacheActionDescription.ENTITY_LOAD);
            StatisticsImplementor statistics = factory.getStatistics();
            if (put && statistics.isStatisticsEnabled()) {
                statistics.entityCachePut(this.rootEntityDescriptor.getNavigableRole(), cacheAccess.getRegion().getName());
            }
            eventListenerManager.cachePutEnd();
        }
    }

    protected void registerPossibleUniqueKeyEntries(EntityInitializerData data, Object[] resolvedEntityState, SharedSessionContractImplementor session) {
        for (UniqueKeyEntry entry : data.concreteDescriptor.uniqueKeyEntries()) {
            String ukName = entry.getUniqueKeyName();
            int index = entry.getStateArrayPosition();
            Type type = entry.getPropertyType();
            if (resolvedEntityState[index] == null) continue;
            Object key = type instanceof ManyToOneType ? ForeignKeys.getEntityIdentifierIfNotUnsaved(((ManyToOneType)type).getAssociatedEntityName(), resolvedEntityState[index], session) : resolvedEntityState[index];
            EntityUniqueKey entityUniqueKey = new EntityUniqueKey(data.concreteDescriptor.getRootEntityDescriptor().getEntityName(), ukName, key, type, session.getFactory());
            session.getPersistenceContextInternal().addEntity(entityUniqueKey, data.entityInstanceForNotify);
        }
    }

    protected Object[] extractConcreteTypeStateValues(EntityInitializerData data) {
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        Object[] values = new Object[data.concreteDescriptor.getNumberOfAttributeMappings()];
        DomainResultAssembler<?>[] concreteAssemblers = this.assemblers[data.concreteDescriptor.getSubclassId()];
        for (int i = 0; i < values.length; ++i) {
            DomainResultAssembler<?> assembler = concreteAssemblers[i];
            values[i] = assembler == null ? LazyPropertyInitializer.UNFETCHED_PROPERTY : assembler.assemble(rowProcessingState);
        }
        return values;
    }

    @Override
    public void resolveState(EntityInitializerData data) {
        if (this.identifierAssembler != null) {
            this.identifierAssembler.resolveState(data.getRowProcessingState());
        }
        if (this.discriminatorAssembler != null) {
            this.discriminatorAssembler.resolveState(data.getRowProcessingState());
        }
        if (this.keyAssembler != null) {
            this.keyAssembler.resolveState(data.getRowProcessingState());
        }
        if (this.versionAssembler != null) {
            this.versionAssembler.resolveState(data.getRowProcessingState());
        }
        if (this.rowIdAssembler != null) {
            this.rowIdAssembler.resolveState(data.getRowProcessingState());
        }
        if (data.concreteDescriptor == null) {
            data.concreteDescriptor = data.defaultConcreteDescriptor;
            if (data.concreteDescriptor == null) {
                data.concreteDescriptor = EntityInitializerImpl.determineConcreteEntityDescriptor(data.getRowProcessingState(), NullnessUtil.castNonNull(this.discriminatorAssembler), this.entityDescriptor);
            }
        }
        this.resolveEntityState(data);
    }

    protected void resolveEntityState(EntityInitializerData data) {
        assert (data.concreteDescriptor != null);
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        for (DomainResultAssembler<?> assembler : this.assemblers[data.concreteDescriptor.getSubclassId()]) {
            if (assembler == null) continue;
            assembler.resolveState(rowProcessingState);
        }
    }

    protected boolean skipInitialization(EntityInitializerData data) {
        PersistentAttributeInterceptor interceptor;
        if (data.entityHolder.getEntityInitializer() != this) {
            return true;
        }
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        EntityEntry entry = data.entityHolder.getEntityEntry();
        assert (entry == rowProcessingState.getSession().getPersistenceContextInternal().getEntry(data.entityInstanceForNotify));
        if (entry == null) {
            return false;
        }
        if (entry.getStatus().isDeletedOrGone()) {
            return true;
        }
        if (ManagedTypeHelper.isPersistentAttributeInterceptable(data.entityInstanceForNotify) && (interceptor = ManagedTypeHelper.asPersistentAttributeInterceptable(data.entityInstanceForNotify).$$_hibernate_getInterceptor()) instanceof EnhancementAsProxyLazinessInterceptor) {
            return entry.getStatus() == Status.LOADING;
        }
        if (entry.getStatus() != Status.LOADING) {
            return rowProcessingState.getJdbcValuesSourceProcessingState().getProcessingOptions().getEffectiveOptionalObject() != data.entityInstanceForNotify;
        }
        return false;
    }

    private boolean isReadOnly(RowProcessingState rowProcessingState, SharedSessionContractImplementor persistenceContext) {
        Boolean readOnly = rowProcessingState.getQueryOptions().isReadOnly();
        return readOnly == null ? persistenceContext.isDefaultReadOnly() : readOnly.booleanValue();
    }

    protected void preLoad(EntityInitializerData data, Object[] resolvedEntityState) {
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        SharedSessionContractImplementor session = rowProcessingState.getSession();
        if (session.isEventSource()) {
            PreLoadEvent preLoadEvent = rowProcessingState.getJdbcValuesSourceProcessingState().getPreLoadEvent();
            assert (preLoadEvent != null);
            preLoadEvent.reset();
            preLoadEvent.setEntity(data.getInstance()).setState(resolvedEntityState).setId(data.entityKey.getIdentifier()).setPersister(data.concreteDescriptor);
            session.getFactory().getFastSessionServices().eventListenerGroup_PRE_LOAD.fireEventOnEachListener(preLoadEvent, PreLoadEventListener::onPreLoad);
        }
    }

    @Override
    public boolean isPartOfKey() {
        return this.isPartOfKey;
    }

    @Override
    public boolean isEager() {
        return true;
    }

    @Override
    public boolean hasLazySubInitializers() {
        return this.hasLazySubInitializers;
    }

    public boolean isPreviousRowReuse() {
        return this.previousRowReuse;
    }

    @Override
    public EntityPersister getConcreteDescriptor(EntityInitializerData data) {
        assert (data.getState() != Initializer.State.UNINITIALIZED);
        return data.concreteDescriptor == null ? this.entityDescriptor : data.concreteDescriptor;
    }

    protected void initializeSubInstancesFromParent(EntityInitializerData data) {
        if (data.entityInstanceForNotify != null) {
            for (Initializer<?> initializer : this.subInitializers[data.concreteDescriptor.getSubclassId()]) {
                if (initializer == null) continue;
                initializer.initializeInstanceFromParent(data.entityInstanceForNotify, data.getRowProcessingState());
            }
        }
    }

    @Override
    protected void forEachSubInitializer(BiConsumer<Initializer<?>, RowProcessingState> consumer, InitializerData data) {
        Initializer<?> initializer;
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        if (this.keyAssembler != null && (initializer = this.keyAssembler.getInitializer()) != null) {
            consumer.accept(initializer, rowProcessingState);
        }
        if (this.identifierAssembler != null && (initializer = this.identifierAssembler.getInitializer()) != null) {
            consumer.accept(initializer, rowProcessingState);
        }
        EntityInitializerData entityInitializerData = (EntityInitializerData)data;
        if (entityInitializerData.concreteDescriptor == null) {
            for (Initializer<?> initializer2 : this.allInitializers) {
                if (initializer2 == null) continue;
                consumer.accept(initializer2, rowProcessingState);
            }
        } else {
            for (Initializer<?> initializer3 : this.subInitializers[entityInitializerData.concreteDescriptor.getSubclassId()]) {
                if (initializer3 == null) continue;
                consumer.accept(initializer3, rowProcessingState);
            }
        }
    }

    public static PersistentAttributeInterceptor getAttributeInterceptor(Object entity) {
        return ManagedTypeHelper.asPersistentAttributeInterceptable(entity).$$_hibernate_getInterceptor();
    }

    public String toString() {
        return "EntityJoinedFetchInitializer(" + LoggingHelper.toLoggableString(this.getNavigablePath()) + ")";
    }

    protected @Nullable DomainResultAssembler<?> getVersionAssembler() {
        return this.versionAssembler;
    }

    protected @Nullable DomainResultAssembler<Object> getRowIdAssembler() {
        return this.rowIdAssembler;
    }

    protected @Nullable DomainResultAssembler<?>[][] getAssemblers() {
        return this.assemblers;
    }

    protected @Nullable BasicResultAssembler<?> getDiscriminatorAssembler() {
        return this.discriminatorAssembler;
    }

    protected boolean isKeyManyToOne() {
        return this.hasKeyManyToOne;
    }

    protected Initializer<?>[][] getSubInitializers() {
        return this.subInitializers;
    }

    public @Nullable DomainResultAssembler<?> getKeyAssembler() {
        return this.keyAssembler;
    }

    public static class EntityInitializerData
    extends InitializerData {
        protected final boolean shallowCached;
        protected final LockMode lockMode;
        protected final String uniqueKeyAttributePath;
        protected final Type[] uniqueKeyPropertyTypes;
        protected final boolean canUseEmbeddedIdentifierInstanceAsEntity;
        protected final boolean hasCallbackActions;
        protected final @Nullable EntityPersister defaultConcreteDescriptor;
        protected @Nullable EntityPersister concreteDescriptor;
        protected @Nullable EntityKey entityKey;
        protected @Nullable Object entityInstanceForNotify;
        protected @Nullable EntityHolder entityHolder;

        public EntityInitializerData(EntityInitializerImpl initializer, RowProcessingState rowProcessingState) {
            super(rowProcessingState);
            EntityPersister entityDescriptor = initializer.entityDescriptor;
            this.shallowCached = rowProcessingState.isQueryCacheHit() && entityDescriptor.useShallowQueryCacheLayout();
            this.lockMode = rowProcessingState.determineEffectiveLockMode(initializer.sourceAlias);
            if (initializer.isResultInitializer()) {
                this.uniqueKeyAttributePath = rowProcessingState.getEntityUniqueKeyAttributePath();
                this.uniqueKeyPropertyTypes = this.uniqueKeyAttributePath != null ? initializer.getParentEntityAttributeTypes(this.uniqueKeyAttributePath) : null;
                this.canUseEmbeddedIdentifierInstanceAsEntity = rowProcessingState.getEntityId() != null && initializer.couldUseEmbeddedIdentifierInstanceAsEntity;
            } else {
                this.uniqueKeyAttributePath = null;
                this.uniqueKeyPropertyTypes = null;
                this.canUseEmbeddedIdentifierInstanceAsEntity = false;
            }
            this.hasCallbackActions = rowProcessingState.hasCallbackActions();
            this.defaultConcreteDescriptor = initializer.discriminatorAssembler == null || rowProcessingState.isQueryCacheHit() && entityDescriptor.useShallowQueryCacheLayout() && !entityDescriptor.storeDiscriminatorInShallowQueryCacheLayout() ? entityDescriptor : null;
        }

        public EntityInitializerData(EntityInitializerData original) {
            super(original);
            this.shallowCached = original.shallowCached;
            this.lockMode = original.lockMode;
            this.uniqueKeyAttributePath = original.uniqueKeyAttributePath;
            this.uniqueKeyPropertyTypes = original.uniqueKeyPropertyTypes;
            this.canUseEmbeddedIdentifierInstanceAsEntity = original.canUseEmbeddedIdentifierInstanceAsEntity;
            this.hasCallbackActions = original.hasCallbackActions;
            this.defaultConcreteDescriptor = original.defaultConcreteDescriptor;
            this.concreteDescriptor = original.concreteDescriptor;
            this.entityKey = original.entityKey;
            this.entityInstanceForNotify = original.entityInstanceForNotify;
            this.entityHolder = original.entityHolder;
        }
    }
}

