/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.JMSSecurityException;
import java.io.IOException;
import java.util.Set;
import java.util.UUID;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.CompositeAddress;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=20L)
public class AmqpTargetedFQQNSecurityTest
extends AmqpClientTestSupport {
    private final String FQQN_SENDER_1 = "fqqnSender1";
    private final String FQQN_SENDER_2 = "fqqnSender2";
    private final String FQQN_RECEIVER_1 = "fqqnReceiver1";
    private final String FQQN_RECEIVER_2 = "fqqnReceiver2";
    private final String FQQN_SENDER1_ROLE = "fqqnSender1Role";
    private final String FQQN_SENDER2_ROLE = "fqqnSender2Role";
    private final String FQQN_RECEIVER1_ROLE = "fqqnReceiver1Role";
    private final String FQQN_RECEIVER2_ROLE = "fqqnReceiver2Role";
    private final String FQQN_ADDRESS = "fqqnAddress";
    private final String FQQN_QUEUE1 = "fqqnQueue1";
    private final String FQQN_QUEUE2 = "fqqnQueue2";
    private final String FQQN_1 = CompositeAddress.toFullyQualified((String)"fqqnAddress", (String)"fqqnQueue1");
    private final String FQQN_2 = CompositeAddress.toFullyQualified((String)"fqqnAddress", (String)"fqqnQueue2");
    private final String PASS = UUID.randomUUID().toString();

    @Override
    protected boolean isSecurityEnabled() {
        return true;
    }

    @Override
    protected void enableSecurity(ActiveMQServer server, String ... securityMatches) {
        ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)server.getSecurityManager();
        Configuration configuration = server.getConfiguration();
        Role fqqnSender1Role = new Role("fqqnSender1Role", true, false, false, false, false, false, false, false, false, false, false, false);
        Role fqqnSender2Role = new Role("fqqnSender2Role", true, false, false, false, false, false, false, false, false, false, false, false);
        Role fqqnReceiver1Role = new Role("fqqnReceiver1Role", false, true, false, false, false, false, false, false, false, false, true, false);
        Role fqqnReceiver2Role = new Role("fqqnReceiver2Role", false, true, false, false, false, false, false, false, false, false, true, false);
        securityManager.getConfiguration().addUser("fqqnSender1", this.PASS);
        securityManager.getConfiguration().addRole("fqqnSender1", "fqqnSender1Role");
        securityManager.getConfiguration().addUser("fqqnSender2", this.PASS);
        securityManager.getConfiguration().addRole("fqqnSender2", "fqqnSender2Role");
        securityManager.getConfiguration().addUser("fqqnReceiver1", this.PASS);
        securityManager.getConfiguration().addRole("fqqnReceiver1", "fqqnReceiver1Role");
        securityManager.getConfiguration().addUser("fqqnReceiver2", this.PASS);
        securityManager.getConfiguration().addRole("fqqnReceiver2", "fqqnReceiver2Role");
        configuration.putSecurityRoles(this.FQQN_1, Set.of(fqqnSender1Role, fqqnReceiver1Role));
        configuration.putSecurityRoles(this.FQQN_2, Set.of(fqqnSender2Role, fqqnReceiver2Role));
        configuration.addQueueConfiguration(QueueConfiguration.of((String)this.FQQN_1).setAddress("fqqnAddress").setRoutingType(RoutingType.ANYCAST));
        configuration.addQueueConfiguration(QueueConfiguration.of((String)this.FQQN_2).setAddress("fqqnAddress").setRoutingType(RoutingType.ANYCAST));
        server.getConfiguration().setSecurityEnabled(true);
    }

    @Test
    public void testSender1CanWriteToAssignedFQQN() throws Exception {
        this.doTestSenderCanWriteToAssignedFQQN("fqqnSender1", this.FQQN_1);
    }

    @Test
    public void testSender2CanWriteToAssignedFQQN() throws Exception {
        this.doTestSenderCanWriteToAssignedFQQN("fqqnSender2", this.FQQN_2);
    }

    private void doTestSenderCanWriteToAssignedFQQN(String username, String fqqn) throws Exception {
        AmqpClient client = this.createAmqpClient(username, this.PASS);
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(fqqn);
        AmqpMessage message = new AmqpMessage();
        message.setText("Test-Message");
        sender.send(message);
        Queue queue = this.getProxyToQueue(fqqn);
        Assertions.assertNotNull((Object)queue);
        Wait.assertEquals((long)1L, () -> ((Queue)queue).getMessageCount());
    }

    @Test
    public void testReceiver1CanReadFromAssignedFQQN() throws Exception {
        this.doTestReceiverCanReadFromAssignedFQQN("fqqnSender1", "fqqnReceiver1", this.FQQN_1);
    }

    @Test
    public void testReceiver2CanReadFromAssignedFQQN() throws Exception {
        this.doTestReceiverCanReadFromAssignedFQQN("fqqnSender2", "fqqnReceiver2", this.FQQN_2);
    }

    private void doTestReceiverCanReadFromAssignedFQQN(String senderUser, String receiverUser, String fqqn) throws Exception {
        AmqpClient sendClient = this.createAmqpClient(senderUser, this.PASS);
        AmqpConnection sendConnection = this.addConnection(sendClient.connect());
        AmqpSession sendSession = sendConnection.createSession();
        AmqpSender sender = sendSession.createSender(fqqn);
        AmqpMessage message = new AmqpMessage();
        message.setText("Test-Message");
        sender.send(message);
        Queue queue = this.getProxyToQueue(fqqn);
        Assertions.assertNotNull((Object)queue);
        Wait.assertEquals((long)1L, () -> ((Queue)queue).getMessageCount());
        AmqpClient receiveClient = this.createAmqpClient(receiverUser, this.PASS);
        AmqpConnection receiveConnection = this.addConnection(receiveClient.connect());
        AmqpSession receiveSession = receiveConnection.createSession();
        AmqpReceiver receiver = receiveSession.createReceiver(fqqn);
        receiver.flow(1);
        AmqpMessage received = receiver.receive();
        Assertions.assertNotNull((Object)received);
        Assertions.assertEquals((Object)"Test-Message", (Object)received.getText());
        received.accept();
        Wait.assertEquals((long)0L, () -> ((Queue)queue).getMessageCount());
    }

    @Test
    public void testReceiver1CannotReadFromFQQNAssignedToReceiver2() throws Exception {
        this.doTestReceiverCannotReadFromFQQNAssignedToAnotherReceiver("fqqnSender2", "fqqnReceiver1", this.FQQN_2);
    }

    @Test
    public void testReceiver2CannotReadFromFQQNAssignedToReceiver1() throws Exception {
        this.doTestReceiverCannotReadFromFQQNAssignedToAnotherReceiver("fqqnSender1", "fqqnReceiver2", this.FQQN_1);
    }

    private void doTestReceiverCannotReadFromFQQNAssignedToAnotherReceiver(String senderUser, String receiverUser, String fqqn) throws Exception {
        AmqpClient sendClient = this.createAmqpClient(senderUser, this.PASS);
        AmqpConnection sendConnection = this.addConnection(sendClient.connect());
        AmqpSession sendSession = sendConnection.createSession();
        AmqpSender sender = sendSession.createSender(fqqn);
        AmqpMessage message = new AmqpMessage();
        message.setText("Test-Message");
        sender.send(message);
        Queue queue = this.getProxyToQueue(fqqn);
        Assertions.assertNotNull((Object)queue);
        Wait.assertEquals((long)1L, () -> ((Queue)queue).getMessageCount());
        AmqpClient receiveClient = this.createAmqpClient(receiverUser, this.PASS);
        AmqpConnection receiveConnection = this.addConnection(receiveClient.connect());
        AmqpSession receiveSession = receiveConnection.createSession();
        try {
            receiveSession.createReceiver(fqqn);
            Assertions.fail((String)"Should not be able to attach to FQQN assigned to another user.");
        }
        catch (IOException e) {
            Assertions.assertNotNull((Object)e.getCause());
            Assertions.assertTrue((boolean)(e.getCause() instanceof JMSSecurityException));
        }
        Wait.assertEquals((long)1L, () -> ((Queue)queue).getMessageCount());
    }

    @Test
    public void testAnonymousSender1CanWriteToAssignedFQQN() throws Exception {
        this.doTestAnonymousSendersCanWriteToAssignedFQQN("fqqnSender1", this.FQQN_1);
    }

    @Test
    public void testAnonymousSenders2CanWriteToAssignedFQQN() throws Exception {
        this.doTestAnonymousSendersCanWriteToAssignedFQQN("fqqnSender2", this.FQQN_2);
    }

    private void doTestAnonymousSendersCanWriteToAssignedFQQN(String username, String fqqn) throws Exception {
        AmqpClient client = this.createAmqpClient(username, this.PASS);
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender();
        AmqpMessage message = new AmqpMessage();
        message.setText("Test-Message");
        message.setAddress(fqqn);
        sender.send(message);
        Queue queue = this.getProxyToQueue(fqqn);
        Assertions.assertNotNull((Object)queue);
        Wait.assertEquals((long)1L, () -> ((Queue)queue).getMessageCount());
    }

    @Test
    public void testSender1CannotAttachToUnassignedFQQN() throws Exception {
        this.doTestSendersCannotAttachToUnassignedFQQN("fqqnSender1", this.FQQN_2);
    }

    @Test
    public void testSender2CannotAttachToUnassignedFQQN() throws Exception {
        this.doTestSendersCannotAttachToUnassignedFQQN("fqqnSender2", this.FQQN_1);
    }

    private void doTestSendersCannotAttachToUnassignedFQQN(String username, String fqqn) throws Exception {
        AmqpClient client = this.createAmqpClient(username, this.PASS);
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        try {
            session.createSender(fqqn);
            Assertions.fail((String)"Should not be able to attach to FQQN assigned to another user.");
        }
        catch (IOException e) {
            Assertions.assertNotNull((Object)e.getCause());
            Assertions.assertTrue((boolean)(e.getCause() instanceof JMSSecurityException));
        }
    }

    @Test
    public void testAnonymousSender1CannotWriteToUnassignedFQQN() throws Exception {
        this.doTestAnonymousSendersCannotWriteToUnassignedFQQN("fqqnSender1", this.FQQN_2);
    }

    @Test
    public void testAnonymousSender2CannotWriteToUnassignedFQQN() throws Exception {
        this.doTestAnonymousSendersCannotWriteToUnassignedFQQN("fqqnSender2", this.FQQN_1);
    }

    private void doTestAnonymousSendersCannotWriteToUnassignedFQQN(String username, String fqqn) throws Exception {
        AmqpClient client = this.createAmqpClient(username, this.PASS);
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender();
        AmqpMessage message = new AmqpMessage();
        message.setText("Test-Message");
        message.setAddress(fqqn);
        try {
            sender.send(message);
            Assertions.fail((String)"Should not be able to send to FQQN assigned to another user.");
        }
        catch (IOException e) {
            Assertions.assertNotNull((Object)e.getCause());
            Assertions.assertTrue((boolean)(e.getCause() instanceof JMSSecurityException));
        }
    }

    @Test
    public void testReceiver1CannotAttachAsSenderToEitherFQQN() throws Exception {
        this.doTestReceiverCannotAttachAsSenderToEitherFQQN("fqqnReceiver1");
    }

    @Test
    public void testReceiver2CannotAttachAsSenderToEitherFQQN() throws Exception {
        this.doTestReceiverCannotAttachAsSenderToEitherFQQN("fqqnReceiver2");
    }

    private void doTestReceiverCannotAttachAsSenderToEitherFQQN(String receiverUser) throws Exception {
        AmqpClient client = this.createAmqpClient(receiverUser, this.PASS);
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        try {
            session.createSender(this.FQQN_1);
            Assertions.fail((String)"Should not be able to attach to FQQN as sender from read only user.");
        }
        catch (IOException e) {
            Assertions.assertNotNull((Object)e.getCause());
            Assertions.assertTrue((boolean)(e.getCause() instanceof JMSSecurityException));
        }
        try {
            session.createSender(this.FQQN_2);
            Assertions.fail((String)"Should not be able to attach to FQQN as sender from read only user.");
        }
        catch (IOException e) {
            Assertions.assertNotNull((Object)e.getCause());
            Assertions.assertTrue((boolean)(e.getCause() instanceof JMSSecurityException));
        }
    }

    @Test
    public void testSender1CannotAttachAsReceiverToEitherFQQN() throws Exception {
        this.doTestSenderCannotAttachAsReceiverToEitherFQQN("fqqnSender1");
    }

    @Test
    public void testSender2CannotAttachAsReceiverToEitherFQQN() throws Exception {
        this.doTestSenderCannotAttachAsReceiverToEitherFQQN("fqqnSender2");
    }

    private void doTestSenderCannotAttachAsReceiverToEitherFQQN(String senderUser) throws Exception {
        AmqpClient client = this.createAmqpClient(senderUser, this.PASS);
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        try {
            session.createReceiver(this.FQQN_1);
            Assertions.fail((String)"Should not be able to attach to FQQN as receiver from write only user.");
        }
        catch (IOException e) {
            Assertions.assertNotNull((Object)e.getCause());
            Assertions.assertTrue((boolean)(e.getCause() instanceof JMSSecurityException));
        }
        try {
            session.createReceiver(this.FQQN_2);
            Assertions.fail((String)"Should not be able to attach to FQQN as receiver from write only user.");
        }
        catch (IOException e) {
            Assertions.assertNotNull((Object)e.getCause());
            Assertions.assertTrue((boolean)(e.getCause() instanceof JMSSecurityException));
        }
    }
}

