/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.lang.invoke.MethodHandles;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AckBatchSizeTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public final SimpleString addressA = SimpleString.of((String)"addressA");
    public final SimpleString queueA = SimpleString.of((String)"queueA");
    public final SimpleString queueB = SimpleString.of((String)"queueB");
    public final SimpleString queueC = SimpleString.of((String)"queueC");

    private int getMessageEncodeSize(SimpleString address) throws Exception {
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory cf = this.createSessionFactory(locator);
        ClientSession session = cf.createSession(false, true, true);
        ClientMessage message = session.createMessage(false);
        message.setAddress(address);
        int encodeSize = message.getEncodeSize();
        session.close();
        cf.close();
        return encodeSize;
    }

    @Test
    public void testAckBatchSize() throws Exception {
        ActiveMQServer server = this.createServer(false);
        server.start();
        int numMessages = 100;
        int originalSize = this.getMessageEncodeSize(this.addressA);
        ServerLocator locator = this.createInVMNonHALocator().setAckBatchSize(numMessages * originalSize).setBlockOnAcknowledge(true);
        ClientSessionFactory cf = this.createSessionFactory(locator);
        ClientSession sendSession = cf.createSession(false, true, true);
        ClientSession session = cf.createSession(false, true, true);
        session.createQueue(QueueConfiguration.of((SimpleString)this.queueA).setAddress(this.addressA).setDurable(Boolean.valueOf(false)));
        ClientProducer cp = sendSession.createProducer(this.addressA);
        for (int i = 0; i < numMessages; ++i) {
            ClientMessage message = (ClientMessage)sendSession.createMessage(false).setAddress(this.addressA);
            Assertions.assertEquals((int)originalSize, (int)message.getEncodeSize());
            cp.send((Message)message);
            Assertions.assertEquals((int)originalSize, (int)message.getEncodeSize());
        }
        ClientConsumer consumer = session.createConsumer(this.queueA);
        session.start();
        for (int i = 0; i < numMessages - 1; ++i) {
            logger.debug("Receive ");
            ClientMessage m = consumer.receive(5000L);
            Assertions.assertEquals((int)0, (int)m.getPropertyNames().size());
            Assertions.assertEquals((int)originalSize, (int)m.getEncodeSize(), (String)("expected to be " + originalSize));
            m.acknowledge();
        }
        ClientMessage m = consumer.receive(5000L);
        Queue q = (Queue)server.getPostOffice().getBinding(this.queueA).getBindable();
        Assertions.assertEquals((int)numMessages, (int)q.getDeliveringCount());
        m.acknowledge();
        Assertions.assertEquals((int)0, (int)q.getDeliveringCount());
        sendSession.close();
        session.close();
    }

    @Test
    public void testAckBatchSizeZero() throws Exception {
        int i;
        ActiveMQServer server = this.createServer(false);
        server.start();
        ServerLocator locator = this.createInVMNonHALocator().setAckBatchSize(0).setBlockOnAcknowledge(true);
        ClientSessionFactory cf = this.createSessionFactory(locator);
        ClientSession sendSession = cf.createSession(false, true, true);
        int numMessages = 100;
        ClientSession session = cf.createSession(false, true, true);
        session.createQueue(QueueConfiguration.of((SimpleString)this.queueA).setAddress(this.addressA).setDurable(Boolean.valueOf(false)));
        ClientProducer cp = sendSession.createProducer(this.addressA);
        for (int i2 = 0; i2 < numMessages; ++i2) {
            cp.send((Message)sendSession.createMessage(false));
        }
        ClientConsumer consumer = session.createConsumer(this.queueA);
        session.start();
        Queue q = (Queue)server.getPostOffice().getBinding(this.queueA).getBindable();
        ClientMessage[] messages = new ClientMessage[numMessages];
        for (i = 0; i < numMessages; ++i) {
            messages[i] = consumer.receive(5000L);
            Assertions.assertNotNull((Object)messages[i]);
        }
        for (i = 0; i < numMessages; ++i) {
            messages[i].acknowledge();
            Assertions.assertEquals((int)(numMessages - i - 1), (int)q.getDeliveringCount());
        }
        sendSession.close();
        session.close();
    }
}

