/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class CreateQueueTest
extends ActiveMQTestBase {
    private boolean legacyCreateQueue;
    public final SimpleString addressA = SimpleString.of((String)"addressA");
    public final SimpleString addressB = SimpleString.of((String)"addressB");
    public final SimpleString queueA = SimpleString.of((String)"queueA");
    public final SimpleString queueB = SimpleString.of((String)"queueB");
    public final SimpleString queueC = SimpleString.of((String)"queueC");
    public final SimpleString queueD = SimpleString.of((String)"queueD");
    private ServerLocator locator;
    private ActiveMQServer server;
    private ClientSessionFactory cf;

    @Parameters(name="legacyCreateQueue={0}")
    public static Collection<Object[]> getParams() {
        return Arrays.asList({true}, {false});
    }

    public CreateQueueTest(boolean legacyCreateQueue) {
        this.legacyCreateQueue = legacyCreateQueue;
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.locator = this.createInVMNonHALocator();
        this.server = this.createServer(false);
        this.server.start();
        this.cf = this.createSessionFactory(this.locator);
    }

    @TestTemplate
    public void testUnsupportedRoutingType() throws Exception {
        ActiveMQException ae;
        ClientSession sendSession = this.cf.createSession(false, true, true);
        this.server.getAddressSettingsRepository().addMatch(this.addressA.toString(), (Object)new AddressSettings().setAutoCreateAddresses(Boolean.valueOf(false)));
        this.server.getAddressSettingsRepository().addMatch(this.addressB.toString(), (Object)new AddressSettings().setAutoCreateAddresses(Boolean.valueOf(false)));
        EnumSet<RoutingType> routingTypes = EnumSet.of(RoutingType.ANYCAST);
        sendSession.createAddress(this.addressA, routingTypes, false);
        try {
            if (this.legacyCreateQueue) {
                sendSession.createQueue(this.addressA, RoutingType.MULTICAST, this.queueA);
            } else {
                sendSession.createQueue(QueueConfiguration.of((SimpleString)this.queueA).setAddress(this.addressA));
            }
            Assertions.fail((String)"Creating a queue here should fail since the queue routing type differs from what is supported on the address.");
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof ActiveMQException));
            ae = (ActiveMQException)((Object)e);
            Assertions.assertEquals((Object)ActiveMQExceptionType.INTERNAL_ERROR, (Object)ae.getType());
        }
        routingTypes = EnumSet.of(RoutingType.MULTICAST);
        sendSession.createAddress(this.addressB, routingTypes, false);
        try {
            if (this.legacyCreateQueue) {
                sendSession.createQueue(this.addressB, RoutingType.ANYCAST, this.queueB);
            } else {
                sendSession.createQueue(QueueConfiguration.of((SimpleString)this.queueB).setAddress(this.addressB).setRoutingType(RoutingType.ANYCAST));
            }
            Assertions.fail((String)"Creating a queue here should fail since the queue routing type differs from what is supported on the address.");
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof ActiveMQException));
            ae = (ActiveMQException)((Object)e);
            Assertions.assertEquals((Object)ActiveMQExceptionType.INTERNAL_ERROR, (Object)ae.getType());
        }
        sendSession.close();
    }

    @TestTemplate
    public void testAddressDoesNotExist() throws Exception {
        ClientSession sendSession = this.cf.createSession(false, true, true);
        this.server.getAddressSettingsRepository().addMatch(this.addressA.toString(), (Object)new AddressSettings().setAutoCreateAddresses(Boolean.valueOf(false)));
        HashSet<RoutingType> routingTypes = new HashSet<RoutingType>();
        routingTypes.add(RoutingType.ANYCAST);
        try {
            if (this.legacyCreateQueue) {
                sendSession.createQueue(this.addressA, RoutingType.MULTICAST, this.queueA);
            } else {
                sendSession.createQueue(QueueConfiguration.of((SimpleString)this.queueA).setAddress(this.addressA));
            }
            Assertions.fail((String)"Creating a queue here should fail since the queue's address doesn't exist and auto-create-addresses = false.");
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof ActiveMQException));
            ActiveMQException ae = (ActiveMQException)((Object)e);
            Assertions.assertEquals((Object)ActiveMQExceptionType.ADDRESS_DOES_NOT_EXIST, (Object)ae.getType());
        }
        sendSession.close();
    }
}

