/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.bridge;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.config.CoreAddressConfiguration;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.postoffice.impl.LocalQueueBinding;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Consumer;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.cluster.impl.BridgeImpl;
import org.apache.activemq.artemis.core.server.cluster.impl.BridgeTestAccessor;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.tests.integration.cluster.bridge.BridgeTestBase;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.actors.ArtemisExecutor;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class NettyBridgeReconnectTest
extends BridgeTestBase {
    final String bridgeName = "bridge1";
    final String testAddress = "testAddress";
    final int confirmationWindowSize = 102400;
    Map<String, Object> server0Params;
    Map<String, Object> server1Params;
    ActiveMQServer server0;
    ActiveMQServer server1;
    private TransportConfiguration server0tc = new TransportConfiguration(this.getConnector(), this.server0Params, "server0tc");
    private TransportConfiguration server1tc = new TransportConfiguration(this.getConnector(), this.server1Params, "server1tc");
    private Map<String, TransportConfiguration> connectors;
    private ArrayList<String> staticConnectors;

    @AfterEach
    public void destroyServer() throws Exception {
        if (this.server1 != null) {
            this.server1.stop();
        }
        if (this.server0 != null) {
            this.server0.stop();
        }
    }

    private void server1Start() throws Exception {
        this.server1.start();
    }

    public void server0Start() throws Exception {
        this.server0 = this.createActiveMQServer(0, this.server0Params, this.isNetty(), null);
        this.server0.getConfiguration().setConnectorConfigurations(this.connectors);
        this.server0.start();
    }

    @BeforeEach
    public void setServer() throws Exception {
        this.server0Params = new HashMap<String, Object>();
        this.server1Params = new HashMap<String, Object>();
        this.connectors = new HashMap<String, TransportConfiguration>();
        this.server1 = this.createActiveMQServer(1, this.isNetty(), this.server1Params);
        this.connectors.put(this.server1tc.getName(), this.server1tc);
        this.connectors.put(this.server0tc.getName(), this.server0tc);
        this.connectors.put(this.server1tc.getName(), this.server1tc);
        this.staticConnectors = new ArrayList();
        this.staticConnectors.add(this.server1tc.getName());
    }

    protected boolean isNetty() {
        return true;
    }

    private String getConnector() {
        return NETTY_CONNECTOR_FACTORY;
    }

    @Test
    public void testFailoverWhileSending() throws Exception {
        this.internalFailoverWhileSending(false);
    }

    @Test
    public void testFailoverWhileSendingInternalQueue() throws Exception {
        this.internalFailoverWhileSending(true);
    }

    private void internalFailoverWhileSending(boolean forceInternal) throws Exception {
        this.connectors.put(this.server0tc.getName(), this.server0tc);
        this.connectors.put(this.server1tc.getName(), this.server1tc);
        this.server1.getConfiguration().setConnectorConfigurations(this.connectors);
        BridgeConfiguration bridgeConfiguration = new BridgeConfiguration().setName("bridge1").setQueueName("testAddress").setForwardingAddress("testAddress").setRetryInterval(10L).setReconnectAttempts(-1).setReconnectAttemptsOnSameNode(-1).setConfirmationWindowSize(102400).setPassword("UnitTestsClusterPassword");
        ArrayList<String> bridgeConnectors = new ArrayList<String>();
        bridgeConnectors.add(this.server0tc.getName());
        bridgeConfiguration.setStaticConnectors(bridgeConnectors);
        bridgeConfiguration.setQueueName("testAddress");
        ArrayList<BridgeConfiguration> bridgeConfigs = new ArrayList<BridgeConfiguration>();
        bridgeConfigs.add(bridgeConfiguration);
        this.server1.getConfiguration().setBridgeConfigurations(bridgeConfigs);
        this.server0Start();
        this.server1Start();
        Queue serverQueue1 = this.server1.locateQueue("testAddress");
        if (forceInternal) {
            serverQueue1.setInternalQueue(true);
        }
        int TRANSACTIONS = 10;
        int NUM_MESSAGES = 1000;
        try (ActiveMQConnectionFactory cf = (ActiveMQConnectionFactory)CFUtil.createConnectionFactory("core", "tcp://localhost:61617");
             Connection connection = cf.createConnection();
             Session session = connection.createSession(true, 0);){
            jakarta.jms.Queue queue = session.createQueue("testAddress");
            MessageProducer producer = session.createProducer((Destination)queue);
            int sequenceID = 0;
            for (int j = 0; j < TRANSACTIONS; ++j) {
                for (int i = 0; i < NUM_MESSAGES; ++i) {
                    producer.send((Message)session.createTextMessage("" + sequenceID++));
                }
                session.commit();
            }
        }
        Wait.waitFor(() -> serverQueue1.getDeliveringCount() > 10, (long)300000L);
        BridgeImpl bridge = null;
        for (Consumer c : serverQueue1.getConsumers()) {
            System.out.println("Consumer " + c);
            if (!(c instanceof BridgeImpl)) continue;
            bridge = (BridgeImpl)c;
        }
        Assertions.assertNotNull(bridge);
        ArtemisExecutor executorFail = this.server1.getExecutorFactory().getExecutor();
        BridgeImpl finalBridge = bridge;
        Wait.assertTrue(() -> NettyBridgeReconnectTest.lambda$internalFailoverWhileSending$3(finalBridge, (Executor)executorFail));
        AtomicInteger queuesTested = new AtomicInteger(0);
        this.server1.getPostOffice().getAllBindings().filter(b -> b instanceof LocalQueueBinding).forEach(b -> {
            queuesTested.incrementAndGet();
            try {
                Wait.assertEquals((long)0L, () -> ((PagingStore)((LocalQueueBinding)b).getQueue().getPagingStore()).getAddressSize());
            }
            catch (Exception e) {
                Assertions.fail((String)e.getMessage());
            }
        });
        Assertions.assertTrue((queuesTested.get() > 0 ? 1 : 0) != 0);
        Wait.assertEquals((int)0, () -> ((Queue)serverQueue1).getDeliveringCount());
        Wait.assertEquals((long)0L, () -> ((Queue)serverQueue1).getMessageCount());
        try (ActiveMQConnectionFactory cf = (ActiveMQConnectionFactory)CFUtil.createConnectionFactory("core", "tcp://localhost:61616");
             Connection connection = cf.createConnection();
             Session session = connection.createSession(false, 1);){
            jakarta.jms.Queue queue = session.createQueue("testAddress");
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            connection.start();
            HashSet<String> received = new HashSet<String>();
            for (int j = 0; j < TRANSACTIONS * NUM_MESSAGES; ++j) {
                TextMessage message = (TextMessage)consumer.receive(5000L);
                Assertions.assertNotNull((Object)message);
                received.add(message.getText());
            }
            Assertions.assertEquals((int)(TRANSACTIONS * NUM_MESSAGES), (int)received.size());
            Assertions.assertNull((Object)consumer.receiveNoWait());
        }
        queuesTested.set(0);
        this.server0.getPostOffice().getAllBindings().filter(b -> b instanceof LocalQueueBinding).forEach(b -> {
            queuesTested.incrementAndGet();
            try {
                Wait.assertEquals((long)0L, () -> ((PagingStore)((LocalQueueBinding)b).getQueue().getPagingStore()).getAddressSize());
            }
            catch (Exception e) {
                Assertions.fail((String)e.getMessage());
            }
        });
        Assertions.assertTrue((queuesTested.get() > 0 ? 1 : 0) != 0);
    }

    @Override
    protected ActiveMQServer createActiveMQServer(int id, Map<String, Object> params, boolean netty, NodeManager nodeManager) throws Exception {
        ActiveMQServer server = super.createActiveMQServer(id, params, netty, nodeManager);
        QueueConfiguration queueConfig0 = QueueConfiguration.of((String)"testAddress").setAddress("testAddress").setRoutingType(RoutingType.ANYCAST);
        ArrayList<QueueConfiguration> queueConfigs0 = new ArrayList<QueueConfiguration>();
        queueConfigs0.add(queueConfig0);
        CoreAddressConfiguration addressConfiguration = new CoreAddressConfiguration();
        addressConfiguration.setName("testAddress").addRoutingType(RoutingType.ANYCAST);
        addressConfiguration.addQueueConfiguration(QueueConfiguration.of((String)"testAddress").setAddress("testAddress").setRoutingType(RoutingType.ANYCAST));
        server.getConfiguration().addAddressConfiguration(addressConfiguration);
        server.getConfiguration().setPersistIDCache(true);
        return server;
    }

    private static /* synthetic */ boolean lambda$internalFailoverWhileSending$3(BridgeImpl finalBridge, Executor executorFail) throws Exception {
        return BridgeTestAccessor.withinRefs(finalBridge, refs -> {
            Map map = refs;
            synchronized (map) {
                if (refs.size() > 100) {
                    executorFail.execute(() -> finalBridge.connectionFailed(new ActiveMQException("bye"), false));
                    return true;
                }
                return false;
            }
        });
    }
}

