/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTestBase;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FakeServiceComponent;
import org.apache.activemq.artemis.tests.util.TransportConfigurationUtils;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BackupAuthenticationTest
extends FailoverTestBase {
    private static CountDownLatch latch;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.startBackupServer = false;
        latch = new CountDownLatch(1);
        super.setUp();
    }

    @Test
    public void testWrongPasswordSetting() throws Exception {
        FakeServiceComponent fakeServiceComponent = new FakeServiceComponent("fake web server");
        Wait.assertTrue(() -> ((ActiveMQServer)this.primaryServer.getServer()).isActive());
        this.waitForServerToStart(this.primaryServer.getServer());
        this.backupServer.start();
        this.backupServer.getServer().addExternalComponent((ActiveMQComponent)fakeServiceComponent, true);
        Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        Wait.waitFor(() -> !this.backupServer.isStarted());
        Assertions.assertFalse((boolean)this.backupServer.isStarted(), (String)"backup should have stopped");
        Wait.assertFalse(fakeServiceComponent::isStarted);
        this.backupServer.stop();
        this.primaryServer.stop();
    }

    @Override
    protected void createConfigs() throws Exception {
        this.createReplicatedConfigs();
        this.backupConfig.setClusterPassword("crocodile");
        this.primaryConfig.setIncomingInterceptorClassNames(Arrays.asList(NotifyingInterceptor.class.getName()));
        this.backupConfig.setSecurityEnabled(true);
        this.primaryConfig.setSecurityEnabled(true);
    }

    @Override
    protected TransportConfiguration getAcceptorTransportConfiguration(boolean live) {
        return TransportConfigurationUtils.getInVMAcceptor(live);
    }

    @Override
    protected TransportConfiguration getConnectorTransportConfiguration(boolean live) {
        return TransportConfigurationUtils.getInVMConnector(live);
    }

    public static final class NotifyingInterceptor
    implements Interceptor {
        public boolean intercept(Packet packet, RemotingConnection connection) throws ActiveMQException {
            if (packet.getType() == 115) {
                latch.countDown();
            } else if (packet.getType() == 125) {
                latch.countDown();
            }
            return true;
        }
    }
}

