/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover.lockmanager;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.ha.DistributedLockManagerConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicationBackupPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicationPrimaryPolicyConfiguration;
import org.apache.activemq.artemis.lockmanager.file.FileBasedLockManager;
import org.apache.activemq.artemis.tests.integration.cluster.failover.ReplicaTimeoutTest;
import org.apache.activemq.artemis.tests.util.ReplicatedBackupUtils;

public class LockManagerReplicaTimeoutTest
extends ReplicaTimeoutTest {
    @Override
    protected void configureReplicationPair(Configuration backupConfig, Configuration primaryConfig, TransportConfiguration backupConnector, TransportConfiguration backupAcceptor, TransportConfiguration primaryConnector) throws IOException {
        DistributedLockManagerConfiguration managerConfiguration = new DistributedLockManagerConfiguration(FileBasedLockManager.class.getName(), Collections.singletonMap("locks-folder", LockManagerReplicaTimeoutTest.newFolder(this.temporaryFolder, "manager").toString()));
        ReplicatedBackupUtils.configurePluggableQuorumReplicationPair(backupConfig, backupConnector, backupAcceptor, primaryConfig, primaryConnector, null, managerConfiguration, managerConfiguration);
        ReplicationPrimaryPolicyConfiguration primaryConfiguration = (ReplicationPrimaryPolicyConfiguration)primaryConfig.getHAPolicyConfiguration();
        primaryConfiguration.setInitialReplicationSyncTimeout(1000L);
        ReplicationBackupPolicyConfiguration backupConfiguration = (ReplicationBackupPolicyConfiguration)backupConfig.getHAPolicyConfiguration();
        backupConfiguration.setInitialReplicationSyncTimeout(1000L);
        backupConfiguration.setMaxSavedReplicatedJournalsSize(2).setAllowFailBack(true);
    }

    @Override
    protected boolean expectPrimarySuicide() {
        return false;
    }

    private static File newFolder(File root, String ... subDirs) throws IOException {
        String subFolder = String.join((CharSequence)"/", subDirs);
        File result = new File(root, subFolder);
        if (!result.mkdirs()) {
            throw new IOException("Couldn't create folders " + root);
        }
        return result;
    }
}

