/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.client;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.TextMessage;
import java.util.HashSet;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.impl.ServerSessionImpl;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.jms.client.ActiveMQConnection;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TemporaryDestinationTest
extends JMSTestBase {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected boolean usePersistence() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTemporaryQueueLeak() throws Exception {
        try (ActiveMQConnection conn = null;){
            conn = (ActiveMQConnection)this.createConnection();
            Session producerSession = conn.createSession(false, 1);
            Session consumerSession = conn.createSession(false, 1);
            TemporaryQueue tempQueue = producerSession.createTemporaryQueue();
            MessageProducer producer = producerSession.createProducer((Destination)tempQueue);
            MessageConsumer consumer = consumerSession.createConsumer((Destination)tempQueue);
            conn.start();
            String messageText = "This is a message";
            TextMessage m = producerSession.createTextMessage("This is a message");
            producer.send((Message)m);
            TextMessage m2 = (TextMessage)consumer.receive(2000L);
            Assertions.assertNotNull((Object)m2);
            Assertions.assertEquals((Object)"This is a message", (Object)m2.getText());
            consumer.close();
            Assertions.assertTrue((boolean)((ActiveMQDestination)tempQueue).isCreated());
            tempQueue.delete();
            Assertions.assertFalse((boolean)((ActiveMQDestination)tempQueue).isCreated());
            Assertions.assertFalse((boolean)conn.containsTemporaryQueue(SimpleString.of((String)tempQueue.getQueueName())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTemporaryQueueDeletedAfterSessionClosed() throws Exception {
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setAutoCreateAddresses(Boolean.valueOf(false)).setAutoCreateQueues(Boolean.valueOf(false)));
        try (Connection conn = null;){
            conn = this.createConnection();
            Session producerSession = conn.createSession(false, 1);
            Session consumerSession = conn.createSession(false, 1);
            TemporaryQueue tempQueue = producerSession.createTemporaryQueue();
            MessageProducer producer = producerSession.createProducer((Destination)tempQueue);
            MessageConsumer consumer = consumerSession.createConsumer((Destination)tempQueue);
            conn.start();
            String messageText = "This is a message";
            TextMessage m = producerSession.createTextMessage("This is a message");
            producer.send((Message)m);
            TextMessage m2 = (TextMessage)consumer.receive(2000L);
            Assertions.assertNotNull((Object)m2);
            Assertions.assertEquals((Object)"This is a message", (Object)m2.getText());
            consumer.close();
            consumerSession.close();
            producer.close();
            producerSession.close();
            tempQueue.delete();
            producerSession = conn.createSession(false, 1);
            try {
                producer = producerSession.createProducer((Destination)tempQueue);
                producer.send((Message)m);
                Assertions.fail();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTemporaryTopicDeletedAfterSessionClosed() throws Exception {
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setAutoCreateAddresses(Boolean.valueOf(false)).setAutoCreateQueues(Boolean.valueOf(false)));
        try (Connection conn = null;){
            conn = this.createConnection();
            Session producerSession = conn.createSession(false, 1);
            Session consumerSession = conn.createSession(false, 1);
            TemporaryTopic tempTopic = producerSession.createTemporaryTopic();
            MessageProducer producer = producerSession.createProducer((Destination)tempTopic);
            MessageConsumer consumer = consumerSession.createConsumer((Destination)tempTopic);
            conn.start();
            String messageText = "This is a message";
            TextMessage m = producerSession.createTextMessage("This is a message");
            producer.send((Message)m);
            TextMessage m2 = (TextMessage)consumer.receive(2000L);
            Assertions.assertNotNull((Object)m2);
            Assertions.assertEquals((Object)"This is a message", (Object)m2.getText());
            consumer.close();
            consumerSession.close();
            producer.close();
            producerSession.close();
            tempTopic.delete();
            producerSession = conn.createSession(false, 1);
            try {
                producer = producerSession.createProducer((Destination)tempTopic);
                producer.send((Message)m);
                Assertions.fail();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTemporaryResourcesDeletedAfterServerRestart() throws Exception {
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setAutoCreateAddresses(Boolean.valueOf(false)).setAutoCreateQueues(Boolean.valueOf(false)));
        try (Connection conn = null;){
            conn = this.createConnection();
            Session producerSession = conn.createSession(false, 1);
            TemporaryQueue tempQueue = producerSession.createTemporaryQueue();
            Assertions.assertNotNull((Object)this.server.getAddressInfo(SimpleString.of((String)tempQueue.getQueueName())));
            this.server.stop();
            conn.close();
            this.server.start();
            this.waitForServerToStart(this.server);
            Assertions.assertNull((Object)this.server.getAddressInfo(SimpleString.of((String)tempQueue.getQueueName())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testForTempQueueCleanerUpperLeak() throws Exception {
        try {
            this.conn = this.createConnection();
            Session s = this.conn.createSession(false, 1);
            TemporaryQueue temporaryQueue = s.createTemporaryQueue();
            temporaryQueue.delete();
            for (ServerSession serverSession : this.server.getSessions()) {
                Assertions.assertEquals((int)0, (int)((ServerSessionImpl)serverSession).getTempQueueCleanUppers().size());
            }
        }
        finally {
            if (this.conn != null) {
                this.conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testForTempQueueTargetInfosLeak() throws Exception {
        try {
            this.conn = this.createConnection();
            Session s = this.conn.createSession(false, 1);
            TemporaryQueue temporaryQueue = s.createTemporaryQueue();
            MessageProducer producer = s.createProducer((Destination)temporaryQueue);
            producer.send(s.createMessage());
            temporaryQueue.delete();
            for (ServerSession serverSession : this.server.getSessions()) {
                Assertions.assertFalse((boolean)((ServerSessionImpl)serverSession).cloneProducers().containsKey(temporaryQueue.getQueueName()));
            }
            Wait.assertTrue(() -> this.server.locateQueue(temporaryQueue.getQueueName()) == null, (long)1000L, (long)100L);
            Wait.assertTrue(() -> this.server.getAddressInfo(SimpleString.of((String)temporaryQueue.getQueueName())) == null, (long)1000L, (long)100L);
        }
        finally {
            if (this.conn != null) {
                this.conn.close();
            }
        }
    }

    @Test
    public void testTemporaryQueueConnectionClosedRemovedAMQP() throws Exception {
        this.testTemporaryQueueConnectionClosedRemoved("AMQP");
    }

    @Test
    public void testTemporaryQueueConnectionClosedRemovedCORE() throws Exception {
        this.testTemporaryQueueConnectionClosedRemoved("CORE");
    }

    @Test
    public void testTemporaryQueueConnectionClosedRemovedOpenWire() throws Exception {
        this.testTemporaryQueueConnectionClosedRemoved("OPENWIRE");
    }

    private void testTemporaryQueueConnectionClosedRemoved(String protocol) throws Exception {
        TemporaryQueue temporaryQueue;
        ConnectionFactory factory = CFUtil.createConnectionFactory("amqp", "tcp://localhost:61616");
        try (Connection conn = factory.createConnection();){
            Session s = conn.createSession(false, 1);
            temporaryQueue = s.createTemporaryQueue();
            MessageProducer producer = s.createProducer((Destination)temporaryQueue);
            producer.send(s.createMessage());
            Wait.assertFalse(() -> this.server.locateQueue(temporaryQueue.getQueueName()) == null, (long)1000L, (long)100L);
            Wait.assertFalse(() -> this.server.getAddressInfo(SimpleString.of((String)temporaryQueue.getQueueName())) == null, (long)1000L, (long)100L);
        }
        Wait.assertTrue(() -> this.server.locateQueue(temporaryQueue.getQueueName()) == null, (long)1000L, (long)100L);
        Wait.assertTrue(() -> this.server.getAddressInfo(SimpleString.of((String)temporaryQueue.getQueueName())) == null, (long)1000L, (long)100L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testForSecurityCacheLeak() throws Exception {
        this.server.getSecurityStore().setSecurityEnabled(true);
        ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)this.server.getSecurityManager();
        securityManager.getConfiguration().addUser("IDo", "Exist");
        securityManager.getConfiguration().addRole("IDo", "myrole");
        Role myRole = new Role("myrole", true, true, true, true, true, true, true, true, true, true, false, false);
        HashSet<Role> anySet = new HashSet<Role>();
        anySet.add(myRole);
        this.server.getSecurityRepository().addMatch("#", anySet);
        try {
            this.conn = this.addConnection(this.cf.createConnection("IDo", "Exist"));
            Session s = this.conn.createSession(false, 1);
            for (int i = 0; i < 10; ++i) {
                TemporaryQueue temporaryQueue = s.createTemporaryQueue();
                temporaryQueue.delete();
            }
            Assertions.assertEquals((int)0, (int)this.server.getSecurityRepository().getCacheSize());
        }
        finally {
            if (this.conn != null) {
                this.conn.close();
            }
        }
    }
}

