/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.multiprotocol;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import java.lang.invoke.MethodHandles;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.jms.multiprotocol.MultiprotocolJMSClientTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSTopicSubscriberTest
extends MultiprotocolJMSClientTestSupport {
    protected static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    protected void addConfiguration(ActiveMQServer server) throws Exception {
        ((AddressSettings)server.getAddressSettingsRepository().getMatch(this.getTopicName())).setAutoCreateQueues(Boolean.valueOf(false));
    }

    @Test
    @Timeout(value=30L)
    public void testCoreSubscriptionQueueCreatedWhenAutoCreateDisabled() throws Exception {
        Connection connection = this.createCoreConnection();
        this.testSubscriptionQueueCreatedWhenAutoCreateDisabled(connection);
    }

    @Test
    @Timeout(value=30L)
    public void testOpenWireSubscriptionQueueCreatedWhenAutoCreateDisabled() throws Exception {
        Connection connection = this.createOpenWireConnection();
        this.testSubscriptionQueueCreatedWhenAutoCreateDisabled(connection);
    }

    @Test
    @Timeout(value=30L)
    public void testAMQPSubscriptionQueueCreatedWhenAutoCreateDisabled() throws Exception {
        Connection connection = this.createConnection();
        this.testSubscriptionQueueCreatedWhenAutoCreateDisabled(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSubscriptionQueueCreatedWhenAutoCreateDisabled(Connection connection) throws Exception {
        try {
            Session session = connection.createSession(false, 1);
            Topic topic = session.createTopic(this.getTopicName());
            Assertions.assertEquals((int)0, (int)this.server.getPostOffice().getBindingsForAddress(SimpleString.of((String)this.getTopicName())).size());
            session.createConsumer((Destination)topic);
            Wait.assertEquals((int)1, () -> this.server.getPostOffice().getBindingsForAddress(SimpleString.of((String)this.getTopicName())).size(), (long)2000L, (long)100L);
        }
        finally {
            connection.close();
        }
    }
}

