/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.journal;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.nio.NIOSequentialFileFactory;
import org.apache.activemq.artemis.core.journal.Journal;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.collections.AbstractHashMapPersister;
import org.apache.activemq.artemis.core.journal.collections.JournalHashMap;
import org.apache.activemq.artemis.core.journal.collections.JournalHashMapProvider;
import org.apache.activemq.artemis.core.journal.impl.JournalImpl;
import org.apache.activemq.artemis.core.persistence.impl.journal.OperationContextImpl;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.actors.OrderedExecutorFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JournalHashMapTest
extends ActiveMQTestBase {
    @Test
    public void testHashMap() throws Exception {
        long i;
        ExecutorService service = Executors.newFixedThreadPool(10);
        this.runAfter(service::shutdownNow);
        OrderedExecutorFactory executorFactory = new OrderedExecutorFactory((Executor)service);
        NIOSequentialFileFactory factory = new NIOSequentialFileFactory(this.getTestDirfile(), 1);
        JournalImpl journal = new JournalImpl((ExecutorFactory)executorFactory, 10240, 10, 10, 3, 0, 50000, (SequentialFileFactory)factory, "coll", "data", 1, 0);
        journal.start();
        this.runAfter(() -> ((JournalImpl)journal).stop());
        journal.loadInternalOnly();
        AtomicLong sequence = new AtomicLong(1L);
        JournalHashMapProvider journalHashMapProvider = new JournalHashMapProvider(sequence::incrementAndGet, (Journal)journal, (AbstractHashMapPersister)new LongPersister(), 3, OperationContextImpl::getContext, l -> null, (e, m, f) -> e.printStackTrace());
        JournalHashMap journalHashMap = journalHashMapProvider.getMap(1L);
        for (i = 0L; i < 1000L; ++i) {
            journalHashMap.put((Object)i, (Object)RandomUtil.randomLong());
        }
        for (i = 0L; i < 1000L; ++i) {
            journalHashMap.put((Object)i, (Object)RandomUtil.randomLong());
        }
        journal.flush();
        journal.stop();
        journalHashMapProvider.clear();
        journal.start();
        ArrayList<RecordInfo> recordInfos = new ArrayList<RecordInfo>();
        ArrayList preparedTransactions = new ArrayList();
        journal.load(recordInfos, preparedTransactions, (a, b, c) -> {}, true);
        ArrayList records = new ArrayList();
        recordInfos.forEach(r -> {
            Assertions.assertEquals((byte)3, (byte)r.userRecordType);
            journalHashMapProvider.reload(r);
        });
        List existingLists = journalHashMapProvider.getMaps();
        Assertions.assertEquals((int)1, (int)existingLists.size());
        JournalHashMap reloadedList = (JournalHashMap)existingLists.get(0);
        Assertions.assertEquals((int)journalHashMap.size(), (int)reloadedList.size());
        journalHashMap.forEach((a, b) -> Assertions.assertEquals((Long)b, (Long)((Long)reloadedList.get(a))));
    }

    private static class LongPersister
    extends AbstractHashMapPersister<Long, Long> {
        private LongPersister() {
        }

        public byte getID() {
            return 0;
        }

        protected int getKeySize(Long key) {
            return 8;
        }

        protected void encodeKey(ActiveMQBuffer buffer, Long key) {
            buffer.writeLong(key.longValue());
        }

        protected Long decodeKey(ActiveMQBuffer buffer) {
            return buffer.readLong();
        }

        protected int getValueSize(Long value) {
            return 8;
        }

        protected void encodeValue(ActiveMQBuffer buffer, Long value) {
            buffer.writeLong(value.longValue());
        }

        protected Long decodeValue(ActiveMQBuffer buffer, Long key) {
            return buffer.readLong();
        }
    }
}

