/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.journal;

import java.io.File;
import java.util.HashMap;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RelativePathTest
extends ActiveMQTestBase {
    @Test
    public void testRelativePathOnDefaultConfig() throws Exception {
        Configuration configuration = this.createDefaultConfig(false);
        ActiveMQServer server = this.createServer(true, configuration, 0xA00000, -1L, new HashMap<String, AddressSettings>());
        server.start();
        server.stop();
        this.checkData(new File(configuration.getJournalDirectory()), ".amq");
        this.checkData(new File(configuration.getBindingsDirectory()), ".bindings");
    }

    @Test
    public void testDataOutsideHome() throws Exception {
        Configuration configuration = this.createDefaultConfig(false);
        File instanceHome = new File(this.getTemporaryDir(), "artemisHome");
        configuration.setBrokerInstance(instanceHome);
        File journalOutside = new File(this.getTemporaryDir(), "./journalOut").getAbsoluteFile();
        configuration.setJournalDirectory(journalOutside.getAbsolutePath());
        configuration.setBindingsDirectory("./bind");
        File bindingsInside = new File(instanceHome, "bind");
        ActiveMQServer server = this.createServer(true, configuration, 0xA00000, -1L, new HashMap<String, AddressSettings>());
        server.start();
        server.stop();
        this.checkData(journalOutside, ".amq");
        this.checkData(journalOutside, "server.lock");
        this.checkData(bindingsInside, ".bindings");
    }

    @Test
    public void testRelativePath() throws Exception {
        Configuration configuration = this.createDefaultConfig(false);
        File instanceHome = new File(this.getTemporaryDir(), "artemisHome");
        File dataHome = new File(instanceHome, "data");
        File bindingsHome = new File(instanceHome, "../binx");
        instanceHome.mkdirs();
        configuration.setBrokerInstance(instanceHome);
        configuration.setJournalDirectory("./data");
        configuration.setPagingDirectory("./paging");
        configuration.setBindingsDirectory("../binx");
        configuration.setLargeMessagesDirectory("./large");
        ActiveMQServer server = this.createServer(true, configuration, 0xA00000, -1L, new HashMap<String, AddressSettings>());
        server.start();
        server.stop();
        this.checkData(dataHome, ".amq");
        this.checkData(bindingsHome, ".bindings");
    }

    public void checkData(File dataHome, String extension) {
        Assertions.assertTrue((boolean)dataHome.exists(), (String)("Folder " + dataHome + " doesn't exist"));
        File[] files = dataHome.listFiles(pathname -> extension == null || pathname.toString().endsWith(extension));
        Assertions.assertNotNull((Object)files);
        Assertions.assertTrue((files.length > 0 ? (byte)1 : 0) != 0);
    }
}

